/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chrome;

import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.types.ChromeTab;
import java.util.function.Function;
import net.sf.jasperreports.chrome.ChromeInstanceHandle;
import net.sf.jasperreports.chrome.ChromeInstanceRepository;
import net.sf.jasperreports.chrome.LaunchConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ChromeServiceHandle {
    private static final Log log = LogFactory.getLog(ChromeServiceHandle.class);
    private LaunchConfiguration launchConfiguration;

    public ChromeServiceHandle(LaunchConfiguration launchConfiguration) {
        this.launchConfiguration = launchConfiguration;
    }

    public <T> T runInTab(Function<ChromeDevToolsService, T> execution) {
        ChromeInstanceRepository instanceRepository = ChromeInstanceRepository.instance();
        ChromeInstanceHandle instanceHandle = instanceRepository.getChromeInstanceHandle(this.launchConfiguration);
        return (T)instanceHandle.runWithChromeInstance(chromeService -> {
            ChromeTab tab = null;
            try {
                tab = chromeService.createTab();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("created tab " + tab.getId()));
                }
                ChromeDevToolsService devToolsService = chromeService.createDevToolsService(tab);
                Object r = execution.apply(devToolsService);
                return r;
            }
            finally {
                if (tab != null) {
                    chromeService.closeTab(tab);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("closed tab " + tab.getId()));
                    }
                }
            }
        });
    }
}

