/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.xls;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.data.AbstractDataAdapterService;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataFileStream;
import net.sf.jasperreports.data.DataFileUtils;
import net.sf.jasperreports.data.xls.XlsDataAdapter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;

public abstract class AbstractXlsDataAdapterService
extends AbstractDataAdapterService {
    protected DataFileStream dataStream;

    public AbstractXlsDataAdapterService(ParameterContributorContext paramContribContext, XlsDataAdapter xlsDataAdapter) {
        super(paramContribContext, (DataAdapter)xlsDataAdapter);
    }

    public AbstractXlsDataAdapterService(JasperReportsContext jasperReportsContext, XlsDataAdapter xlsDataAdapter) {
        super(jasperReportsContext, (DataAdapter)xlsDataAdapter);
    }

    public XlsDataAdapter getXlsDataAdapter() {
        return (XlsDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        XlsDataAdapter xlsDataAdapter = this.getXlsDataAdapter();
        if (xlsDataAdapter != null) {
            this.dataStream = DataFileUtils.instance(this.getParameterContributorContext()).getDataStream(xlsDataAdapter.getDataFile(), parameters);
            Locale locale = xlsDataAdapter.getLocale();
            TimeZone timeZone = xlsDataAdapter.getTimeZone();
            String datePattern = xlsDataAdapter.getDatePattern();
            String numberPattern = xlsDataAdapter.getNumberPattern();
            String sheetSelection = xlsDataAdapter.getSheetSelection();
            if (xlsDataAdapter.isQueryExecuterMode()) {
                parameters.put("XLS_INPUT_STREAM", this.dataStream);
                if (locale != null) {
                    parameters.put("XLS_LOCALE", locale);
                }
                if (timeZone != null) {
                    parameters.put("XLS_TIMEZONE", timeZone);
                }
                if (datePattern != null && datePattern.length() > 0) {
                    SimpleDateFormat sdf = null;
                    sdf = locale == null ? new SimpleDateFormat(datePattern) : new SimpleDateFormat(datePattern, locale);
                    if (timeZone != null) {
                        sdf.setTimeZone(timeZone);
                    }
                    parameters.put("XLS_DATE_FORMAT", sdf);
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    DecimalFormat df = null;
                    df = locale == null ? new DecimalFormat(numberPattern) : new DecimalFormat(numberPattern, DecimalFormatSymbols.getInstance(locale));
                    parameters.put("XLS_NUMBER_FORMAT", df);
                }
                parameters.put("XLS_USE_FIRST_ROW_AS_HEADER", xlsDataAdapter.isUseFirstRowAsHeader());
                if (sheetSelection != null && sheetSelection.length() > 0) {
                    parameters.put("net.sf.jasperreports.xls.sheet.selection", sheetSelection);
                }
                if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                    String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                    Integer[] indexes = new Integer[xlsDataAdapter.getColumnNames().size()];
                    this.setupColumns(xlsDataAdapter, names, indexes);
                    parameters.put("XLS_COLUMN_NAMES_ARRAY", names);
                    parameters.put("XLS_COLUMN_INDEXES_ARRAY", indexes);
                }
            } else {
                AbstractXlsDataSource ds = this.getXlsDataSource();
                if (locale != null) {
                    ds.setLocale(locale);
                }
                if (timeZone != null) {
                    ds.setTimeZone(timeZone);
                }
                if (datePattern != null && datePattern.length() > 0) {
                    SimpleDateFormat sdf = null;
                    sdf = locale == null ? new SimpleDateFormat(datePattern) : new SimpleDateFormat(datePattern, locale);
                    if (timeZone != null) {
                        sdf.setTimeZone(timeZone);
                    }
                    ds.setDateFormat(sdf);
                }
                if (numberPattern != null && numberPattern.length() > 0) {
                    DecimalFormat df = null;
                    df = locale == null ? new DecimalFormat(numberPattern) : new DecimalFormat(numberPattern, DecimalFormatSymbols.getInstance(locale));
                    ds.setNumberFormat(df);
                }
                ds.setUseFirstRowAsHeader(xlsDataAdapter.isUseFirstRowAsHeader());
                if (sheetSelection != null && sheetSelection.length() > 0) {
                    ds.setSheetSelection(sheetSelection);
                }
                if (!xlsDataAdapter.isUseFirstRowAsHeader()) {
                    String[] names = new String[xlsDataAdapter.getColumnNames().size()];
                    int[] indexes = new int[xlsDataAdapter.getColumnNames().size()];
                    this.setupColumns(xlsDataAdapter, names, indexes);
                    ds.setColumnNames(names, indexes);
                }
                parameters.put("REPORT_DATA_SOURCE", ds);
            }
        }
    }

    protected abstract AbstractXlsDataSource getXlsDataSource() throws JRException;

    protected void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, int[] indexes) {
        for (int i = 0; i < names.length; ++i) {
            names[i] = "" + xlsDataAdapter.getColumnNames().get(i);
            indexes[i] = xlsDataAdapter.getColumnIndexes().size() > i ? xlsDataAdapter.getColumnIndexes().get(i) : i;
        }
    }

    protected void setupColumns(XlsDataAdapter xlsDataAdapter, String[] names, Integer[] indexes) {
        for (int i = 0; i < names.length; ++i) {
            names[i] = "" + xlsDataAdapter.getColumnNames().get(i);
            indexes[i] = xlsDataAdapter.getColumnIndexes().size() > i ? xlsDataAdapter.getColumnIndexes().get(i) : Integer.valueOf(i);
        }
    }

    @Override
    public void dispose() {
        if (this.dataStream != null) {
            this.dataStream.dispose();
        }
    }
}

