/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ScaledGraphics;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.zest.core.widgets.internal.CachedLabel;

public class GraphLabel
extends CachedLabel {
    private Color borderColor;
    private int borderWidth;
    private int arcWidth;
    private boolean painting = false;

    public GraphLabel(boolean cacheLabel) {
        this("", cacheLabel);
    }

    public GraphLabel(String text, boolean cacheLabel) {
        this("", null, cacheLabel);
    }

    public GraphLabel(Image i, boolean cacheLabel) {
        this("", i, cacheLabel);
    }

    public GraphLabel(String text, Image i, boolean cacheLabel) {
        super(cacheLabel);
        this.initLabel();
        this.setText(text);
        this.setIcon(i);
        this.adjustBoundsToFit();
    }

    protected void initLabel() {
        super.setFont(Display.getDefault().getSystemFont());
        this.borderColor = ColorConstants.black;
        this.borderWidth = 0;
        this.arcWidth = 8;
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setBorder((Border)new MarginBorder(1));
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        this.adjustBoundsToFit();
    }

    protected void adjustBoundsToFit() {
        Font font;
        int safeBorderWidth;
        String text = this.getText();
        int n = safeBorderWidth = this.borderWidth > 0 ? this.borderWidth : 1;
        if (text != null && (font = this.getFont()) != null) {
            Dimension minSize = FigureUtilities.getTextExtents((String)text, (Font)font);
            if (this.getIcon() != null) {
                Rectangle imageRect = this.getIcon().getBounds();
                int expandHeight = Math.max(imageRect.height - minSize.height, 0);
                minSize.expand(imageRect.width + 4, expandHeight);
            }
            minSize.expand(10 + 2 * safeBorderWidth, 4 + 2 * safeBorderWidth);
            this.setBounds(new org.eclipse.draw2d.geometry.Rectangle(this.getLocation(), minSize));
        }
    }

    public void paint(Graphics graphics) {
        int blue = this.getBackgroundColor().getBlue();
        blue = (blue = (int)((double)blue - (double)blue * 0.2)) > 0 ? blue : 0;
        int red = this.getBackgroundColor().getRed();
        red = (int)((double)red - (double)red * 0.2);
        red = red > 0 ? red : 0;
        int green = this.getBackgroundColor().getGreen();
        green = (int)((double)green - (double)green * 0.2);
        green = green > 0 ? green : 0;
        Color lightenColor = new Color((Device)Display.getCurrent(), new RGB(red, green, blue));
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(this.getBackgroundColor());
        int safeBorderWidth = this.borderWidth > 0 ? this.borderWidth : 1;
        graphics.pushState();
        double scale = 1.0;
        if (graphics instanceof ScaledGraphics) {
            scale = ((ScaledGraphics)graphics).getAbsoluteScale();
        }
        org.eclipse.draw2d.geometry.Rectangle rect = this.getBounds().getCopy();
        rect.height /= 2;
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.setBackgroundColor(this.getBackgroundColor());
        graphics.fillRoundRectangle(rect, this.arcWidth * safeBorderWidth, this.arcWidth * 2 * safeBorderWidth);
        rect.y += rect.height;
        ++rect.height;
        graphics.setForegroundColor(lightenColor);
        graphics.setBackgroundColor(lightenColor);
        graphics.fillRoundRectangle(rect, this.arcWidth * safeBorderWidth, this.arcWidth * 2 * safeBorderWidth);
        rect = this.bounds.getCopy();
        rect.height -= 2;
        rect.y += safeBorderWidth / 2;
        rect.y += this.arcWidth / 2;
        rect.height -= this.arcWidth / 2;
        rect.height -= safeBorderWidth;
        graphics.setBackgroundColor(lightenColor);
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.fillGradient(rect, true);
        if (this.borderWidth > 0) {
            rect = this.getBounds().getCopy();
            rect.x += safeBorderWidth / 2;
            rect.y += safeBorderWidth / 2;
            rect.width -= safeBorderWidth;
            rect.height -= safeBorderWidth;
            graphics.setForegroundColor(this.borderColor);
            graphics.setBackgroundColor(this.borderColor);
            graphics.setLineWidth((int)((double)safeBorderWidth * scale));
            graphics.drawRoundRectangle(rect, this.arcWidth, this.arcWidth);
        }
        super.paint(graphics);
        graphics.popState();
    }

    @Override
    protected Color getBackgroundTextColor() {
        return this.getBackgroundColor();
    }

    public void invalidate() {
        if (!this.painting) {
            super.invalidate();
        }
    }

    @Override
    public void setText(String s) {
        if (!s.equals("")) {
            super.setText(s);
        } else {
            super.setText("");
        }
        this.adjustBoundsToFit();
    }

    @Override
    public void setIcon(Image image) {
        super.setIcon(image);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color c) {
        this.borderColor = c;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public void setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
    }

    @Override
    public void setBounds(org.eclipse.draw2d.geometry.Rectangle rect) {
        super.setBounds(rect);
    }
}

