/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.commandline;

import com.archimatetool.commandline.AbstractCommandLineProvider;
import com.archimatetool.commandline.CommandLineState;
import com.archimatetool.csv.commandline.Messages;
import com.archimatetool.csv.export.CSVExporter;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.eclipse.osgi.util.NLS;

public class ExportCSVProvider
extends AbstractCommandLineProvider {
    static final String PREFIX = Messages.ExportCSVProvider_0;
    static final String OPTION_EXPORT_CSV = "csv.export";
    static final String OPTION_DELIMITER = "csv.exportDelimiter";
    static final String OPTION_FILE_PREFIX = "csv.exportFilenamePrefix";
    static final String OPTION_STRIP_NEW_LINES = "csv.exportStripNewLines";
    static final String OPTION_EXCEL_COMPATIBLE = "csv.exportExcelCompatible";
    static final String OPTION_ENCODING = "csv.exportEncoding";

    public void run(CommandLine commandLine) throws Exception {
        CSVExporter exporter;
        File folderOutput;
        String value;
        IArchimateModel model;
        block16: {
            if (!this.hasCorrectOptions(commandLine)) {
                return;
            }
            model = CommandLineState.getModel();
            if (model == null) {
                throw new IOException(Messages.ExportCSVProvider_1);
            }
            value = commandLine.getOptionValue(OPTION_EXPORT_CSV);
            if (!StringUtils.isSet((String)value)) {
                this.logError(Messages.ExportCSVProvider_2);
                return;
            }
            folderOutput = new File(value);
            folderOutput.mkdirs();
            if (!folderOutput.exists()) {
                this.logError(NLS.bind((String)Messages.ExportCSVProvider_3, (Object)value));
                return;
            }
            exporter = new CSVExporter(model);
            value = commandLine.getOptionValue(OPTION_DELIMITER);
            if (!StringUtils.isSet((String)value)) break block16;
            switch (value) {
                case "\\t": {
                    exporter.setDelimiter('\t');
                    break;
                }
                case ";": {
                    exporter.setDelimiter(';');
                    break;
                }
                default: {
                    exporter.setDelimiter(',');
                }
            }
        }
        if (StringUtils.isSet((String)(value = commandLine.getOptionValue(OPTION_FILE_PREFIX)))) {
            exporter.setFilePrefix(value);
        }
        if (StringUtils.isSet((String)(value = commandLine.getOptionValue(OPTION_ENCODING)))) {
            exporter.setEncoding(value);
        }
        exporter.setExcelCompatible(commandLine.hasOption(OPTION_EXCEL_COMPATIBLE));
        exporter.setStripNewLines(commandLine.hasOption(OPTION_STRIP_NEW_LINES));
        this.logMessage(NLS.bind((String)Messages.ExportCSVProvider_4, (Object)model.getName(), (Object)folderOutput.getPath()));
        exporter.export(folderOutput);
        this.logMessage(Messages.ExportCSVProvider_5);
    }

    protected String getLogPrefix() {
        return PREFIX;
    }

    public Options getOptions() {
        Options options = new Options();
        Option option = Option.builder().longOpt(OPTION_EXPORT_CSV).hasArg().argName(Messages.ExportCSVProvider_6).desc(Messages.ExportCSVProvider_7).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_DELIMITER).hasArg().argName(Messages.ExportCSVProvider_8).desc(Messages.ExportCSVProvider_9).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_ENCODING).hasArg().argName(Messages.ExportCSVProvider_10).desc(Messages.ExportCSVProvider_11).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_FILE_PREFIX).hasArg().argName(Messages.ExportCSVProvider_12).desc(Messages.ExportCSVProvider_13).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_EXCEL_COMPATIBLE).desc(Messages.ExportCSVProvider_14).build();
        options.addOption(option);
        option = Option.builder().longOpt(OPTION_STRIP_NEW_LINES).desc(Messages.ExportCSVProvider_15).build();
        options.addOption(option);
        return options;
    }

    private boolean hasCorrectOptions(CommandLine commandLine) {
        return commandLine.hasOption(OPTION_EXPORT_CSV);
    }
}

