/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.export;

import com.archimatetool.csv.CSVConstants;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAccessRelationship;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IAssociationRelationship;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IInfluenceRelationship;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProperty;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class CSVExporter
implements CSVConstants {
    private char fDelimiter = (char)44;
    private String fFilePrefix = "";
    private boolean fStripNewLines = false;
    private boolean fExcelCompatible = false;
    private String fEncoding = "UTF-8";
    private boolean fWriteEmptyFile = true;
    private IArchimateModel fModel;

    public CSVExporter(IArchimateModel model) {
        this.fModel = model;
    }

    public void export(File folder) throws IOException {
        this.writeModelAndElements(new File(folder, this.createElementsFileName()));
        this.writeRelationships(new File(folder, this.createRelationsFileName()));
        this.writeProperties(new File(folder, this.createPropertiesFileName()));
    }

    public void setDelimiter(char delimiter) {
        this.fDelimiter = delimiter;
    }

    public void setFilePrefix(String prefix) {
        if (prefix != null) {
            this.fFilePrefix = prefix;
        }
    }

    public void setStripNewLines(boolean set) {
        this.fStripNewLines = set;
    }

    public void setExcelCompatible(boolean set) {
        this.fExcelCompatible = set;
    }

    public void setEncoding(String encoding) {
        this.fEncoding = encoding;
    }

    private void writeModelAndElements(File file) throws IOException {
        OutputStreamWriter writer = this.createOutputStreamWriter(file);
        this.writeBOM(writer);
        String header = this.createHeader(MODEL_ELEMENTS_HEADER);
        writer.write(header);
        writer.write("\r\n");
        String modelRow = this.createModelRow();
        writer.write(modelRow);
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.STRATEGY));
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.BUSINESS));
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.APPLICATION));
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.TECHNOLOGY));
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.MOTIVATION));
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.IMPLEMENTATION_MIGRATION));
        this.writeElementsInFolder(writer, this.fModel.getFolder(FolderType.OTHER));
        ((Writer)writer).close();
    }

    private void writeElementsInFolder(Writer writer, IFolder folder) throws IOException {
        if (folder == null) {
            return;
        }
        List<IArchimateConcept> concepts = this.getConcepts(folder);
        this.sort(concepts);
        for (IArchimateConcept concept : concepts) {
            if (!(concept instanceof IArchimateElement)) continue;
            writer.write("\r\n");
            writer.write(this.createElementRow((IArchimateElement)concept));
        }
    }

    private void writeRelationships(File file) throws IOException {
        List<IArchimateConcept> concepts = this.getConcepts(this.fModel.getFolder(FolderType.RELATIONS));
        this.sort(concepts);
        if (!this.fWriteEmptyFile && concepts.isEmpty()) {
            return;
        }
        OutputStreamWriter writer = this.createOutputStreamWriter(file);
        this.writeBOM(writer);
        String header = this.createHeader(RELATIONSHIPS_HEADER);
        writer.write(header);
        for (IArchimateConcept concept : concepts) {
            if (!(concept instanceof IArchimateRelationship)) continue;
            writer.write("\r\n");
            writer.write(this.createRelationshipRow((IArchimateRelationship)concept));
        }
        ((Writer)writer).close();
    }

    private void writeProperties(File file) throws IOException {
        if (!this.fWriteEmptyFile && !this.hasProperties()) {
            return;
        }
        OutputStreamWriter writer = this.createOutputStreamWriter(file);
        this.writeBOM(writer);
        String header = this.createHeader(PROPERTIES_HEADER);
        writer.write(header);
        for (IProperty property : this.fModel.getProperties()) {
            writer.write("\r\n");
            writer.write(this.createPropertyRow(this.fModel.getId(), property));
        }
        TreeIterator iter = this.fModel.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IArchimateConcept)) continue;
            IArchimateConcept concept = (IArchimateConcept)eObject;
            for (IProperty property : concept.getProperties()) {
                writer.write("\r\n");
                writer.write(this.createPropertyRow(concept.getId(), property));
            }
            this.writeSpecialProperties(writer, concept);
        }
        ((Writer)writer).close();
    }

    private void writeSpecialProperties(Writer writer, IArchimateConcept concept) throws IOException {
        if (concept instanceof IInfluenceRelationship) {
            String strength = ((IInfluenceRelationship)concept).getStrength();
            if (StringUtils.isSet((String)strength)) {
                writer.write("\r\n");
                writer.write(this.createPropertyRow(concept.getId(), "Influence_Strength", strength));
            }
        } else if (concept instanceof IAccessRelationship) {
            writer.write("\r\n");
            writer.write(this.createPropertyRow(concept.getId(), "Access_Type", (String)ACCESS_TYPES.get(((IAccessRelationship)concept).getAccessType())));
        } else if (concept instanceof IAssociationRelationship) {
            writer.write("\r\n");
            writer.write(this.createPropertyRow(concept.getId(), "Directed", ((IAssociationRelationship)concept).isDirected() ? "true" : "false"));
        } else if (concept instanceof IJunction) {
            String type = ((IJunction)concept).getType();
            type = "".equals(type) ? "And" : "Or";
            writer.write("\r\n");
            writer.write(this.createPropertyRow(concept.getId(), "Junction_Type", type));
        }
    }

    boolean hasProperties() {
        if (!this.fModel.getProperties().isEmpty()) {
            return true;
        }
        TreeIterator iter = this.fModel.eAllContents();
        while (iter.hasNext()) {
            IArchimateConcept concept;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IArchimateConcept) || (concept = (IArchimateConcept)eObject).getProperties().isEmpty()) continue;
            return true;
        }
        return false;
    }

    String createHeader(String[] elements) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < elements.length) {
            String s = elements[i];
            sb.append("\"");
            sb.append(s);
            sb.append("\"");
            if (i < elements.length - 1) {
                sb.append(this.fDelimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    String createModelRow() {
        StringBuffer sb = new StringBuffer();
        String id = this.fModel.getId();
        sb.append(this.surroundWithQuotes(id));
        sb.append(this.fDelimiter);
        sb.append(this.surroundWithQuotes("ArchimateModel"));
        sb.append(this.fDelimiter);
        String name = this.normalise(this.fModel.getName());
        sb.append(this.surroundWithQuotes(name));
        sb.append(this.fDelimiter);
        String purpose = this.normalise(this.fModel.getPurpose());
        sb.append(this.surroundWithQuotes(purpose));
        sb.append(this.fDelimiter);
        sb.append("\"\"");
        return sb.toString();
    }

    String createElementRow(IArchimateElement element) {
        StringBuffer sb = new StringBuffer();
        String id = element.getId();
        sb.append(this.surroundWithQuotes(id));
        sb.append(this.fDelimiter);
        sb.append(this.surroundWithQuotes(element.eClass().getName()));
        sb.append(this.fDelimiter);
        String name = this.normalise(element.getName());
        sb.append(this.surroundWithQuotes(name));
        sb.append(this.fDelimiter);
        String documentation = this.normalise(element.getDocumentation());
        sb.append(this.surroundWithQuotes(documentation));
        sb.append(this.fDelimiter);
        IProfile profile = element.getPrimaryProfile();
        String specialization = this.normalise(profile != null ? profile.getName() : "");
        sb.append(this.surroundWithQuotes(specialization));
        return sb.toString();
    }

    String createRelationshipRow(IArchimateRelationship relationship) {
        StringBuffer sb = new StringBuffer();
        String id = relationship.getId();
        sb.append(this.surroundWithQuotes(id));
        sb.append(this.fDelimiter);
        sb.append(this.surroundWithQuotes(relationship.eClass().getName()));
        sb.append(this.fDelimiter);
        String name = this.normalise(relationship.getName());
        sb.append(this.surroundWithQuotes(name));
        sb.append(this.fDelimiter);
        String documentation = this.normalise(relationship.getDocumentation());
        sb.append(this.surroundWithQuotes(documentation));
        sb.append(this.fDelimiter);
        if (relationship.getSource() != null) {
            String sourceID = relationship.getSource().getId();
            sb.append(this.surroundWithQuotes(sourceID));
        } else {
            sb.append("\"\"");
        }
        sb.append(this.fDelimiter);
        if (relationship.getTarget() != null) {
            String targetID = relationship.getTarget().getId();
            sb.append(this.surroundWithQuotes(targetID));
        } else {
            sb.append("\"\"");
        }
        sb.append(this.fDelimiter);
        IProfile profile = relationship.getPrimaryProfile();
        String specialization = this.normalise(profile != null ? profile.getName() : "");
        sb.append(this.surroundWithQuotes(specialization));
        return sb.toString();
    }

    String createPropertyRow(String conceptID, IProperty property) {
        return this.createPropertyRow(conceptID, property.getKey(), property.getValue());
    }

    String createPropertyRow(String conceptID, String key, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.surroundWithQuotes(conceptID));
        sb.append(this.fDelimiter);
        key = this.normalise(key);
        sb.append(this.surroundWithQuotes(key));
        sb.append(this.fDelimiter);
        value = this.normalise(value);
        sb.append(this.surroundWithQuotes(value));
        return sb.toString();
    }

    private void writeBOM(Writer writer) throws IOException {
        if (this.fEncoding.contains("BOM")) {
            writer.write(65279);
        }
    }

    String normalise(String s) {
        if (s == null) {
            return "";
        }
        if (this.fStripNewLines) {
            s = s.replaceAll("(\r\n|\r|\n)", " ");
        }
        s = s.replace("\t", " ");
        s = s.replace("\"", "\"\"");
        return s;
    }

    String surroundWithQuotes(String s) {
        if (this.needsLeadingCharHack((String)s)) {
            return "\"=\"\"" + (String)s + "\"\"\"";
        }
        if (this.needsLeadingCharFormulaHack((String)s)) {
            s = " " + (String)s;
        }
        return "\"" + (String)s + "\"";
    }

    boolean needsLeadingCharHack(String s) {
        return s != null && this.fExcelCompatible && (s.startsWith(" ") || s.startsWith("0"));
    }

    boolean needsLeadingCharFormulaHack(String s) {
        return s != null && this.fExcelCompatible && (s.startsWith("=") || s.startsWith("+") || s.startsWith("-") || s.startsWith("@"));
    }

    private List<IArchimateConcept> getConcepts(IFolder folder) {
        ArrayList<IArchimateConcept> list = new ArrayList<IArchimateConcept>();
        if (folder == null) {
            return list;
        }
        for (EObject object : folder.getElements()) {
            if (!(object instanceof IArchimateConcept)) continue;
            list.add((IArchimateConcept)object);
        }
        for (IFolder f : folder.getFolders()) {
            list.addAll(this.getConcepts(f));
        }
        return list;
    }

    void sort(List<IArchimateConcept> list) {
        if (list == null || list.size() < 2) {
            return;
        }
        Collections.sort(list, new Comparator<IArchimateConcept>(){

            @Override
            public int compare(IArchimateConcept o1, IArchimateConcept o2) {
                if (o1.eClass().equals(o2.eClass())) {
                    String name1 = StringUtils.safeString((String)o1.getName().toLowerCase().trim());
                    String name2 = StringUtils.safeString((String)o2.getName().toLowerCase().trim());
                    return name1.compareTo(name2);
                }
                String name1 = o1.eClass().getName().toLowerCase();
                String name2 = o2.eClass().getName().toLowerCase();
                return name1.compareTo(name2);
            }
        });
    }

    String createElementsFileName() {
        return this.fFilePrefix + "elements.csv";
    }

    String createRelationsFileName() {
        return this.fFilePrefix + "relations.csv";
    }

    String createPropertiesFileName() {
        return this.fFilePrefix + "properties.csv";
    }

    OutputStreamWriter createOutputStreamWriter(File file) throws IOException {
        if ("ANSI".equals(this.fEncoding)) {
            return new OutputStreamWriter(new FileOutputStream(file));
        }
        if (this.fEncoding.startsWith("UTF-8")) {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        }
        return new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.fEncoding);
    }
}

