/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.export;

import com.archimatetool.csv.CSVConstants;
import com.archimatetool.csv.CSVImportExportPlugin;
import com.archimatetool.csv.IPreferenceConstants;
import com.archimatetool.csv.export.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportAsCSVPage
extends WizardPage
implements IPreferenceConstants,
CSVConstants {
    private static String HELP_ID = "com.archimatetool.help.ExportAsCSVPage";
    private Text fFolderTextField;
    private Combo fDelimiterCombo;
    private Text fFilePrefixTextField;
    private Button fStripNewlinesButton;
    private Button fExcelCompatibleButton;
    private Label fElementsFileNameLabel;
    private Label fRelationsFileNameLabel;
    private Label fPropertiesFileNameLabel;
    private Combo fEncodingCombo;

    public ExportAsCSVPage() {
        super("ExportAsCSVPage");
        this.setTitle(Messages.ExportAsCSVPage_0);
        this.setDescription(Messages.ExportAsCSVPage_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/exportdir_wiz.png"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Group exportGroup = new Group(container, 0);
        exportGroup.setText(Messages.ExportAsCSVPage_2);
        exportGroup.setLayout((Layout)new GridLayout(3, false));
        exportGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportAsCSVPage_3);
        this.fFolderTextField = UIUtils.createSingleTextControl((Composite)exportGroup, (int)2048, (boolean)false);
        this.fFolderTextField.setLayoutData((Object)new GridData(768));
        this.fFolderTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAsCSVPage.this.validateFields();
                ExportAsCSVPage.this.updateFileLabels();
            }
        });
        Button folderButton = new Button((Composite)exportGroup, 8);
        folderButton.setText(Messages.ExportAsCSVPage_4);
        folderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String folderPath = ExportAsCSVPage.this.chooseFolderPath();
                if (folderPath != null) {
                    ExportAsCSVPage.this.fFolderTextField.setText(folderPath);
                }
            }
        });
        label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportAsCSVPage_5);
        this.fDelimiterCombo = new Combo((Composite)exportGroup, 8);
        this.fDelimiterCombo.setItems(DELIMITER_NAMES);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.fDelimiterCombo.setLayoutData((Object)gd);
        label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportAsCSVPage_6);
        this.fFilePrefixTextField = UIUtils.createSingleTextControl((Composite)exportGroup, (int)2048, (boolean)false);
        this.fFilePrefixTextField.setLayoutData((Object)new GridData(768));
        gd = new GridData();
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        this.fFilePrefixTextField.setLayoutData((Object)gd);
        this.fFilePrefixTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAsCSVPage.this.validateFields();
                ExportAsCSVPage.this.updateFileLabels();
            }
        });
        label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportAsCSVPage_15);
        this.fEncodingCombo = new Combo((Composite)exportGroup, 8);
        this.fEncodingCombo.setItems(ENCODINGS);
        Group optionsGroup = new Group(container, 0);
        optionsGroup.setText(Messages.ExportAsCSVPage_7);
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.fStripNewlinesButton = new Button((Composite)optionsGroup, 32);
        this.fStripNewlinesButton.setText(Messages.ExportAsCSVPage_8);
        this.fExcelCompatibleButton = new Button((Composite)optionsGroup, 32);
        this.fExcelCompatibleButton.setText(Messages.ExportAsCSVPage_9);
        label = new Label(container, 0);
        Group filesGroup = new Group(container, 0);
        filesGroup.setText(Messages.ExportAsCSVPage_10);
        filesGroup.setLayout((Layout)new GridLayout(1, false));
        filesGroup.setLayoutData((Object)new GridData(768));
        this.fElementsFileNameLabel = new Label((Composite)filesGroup, 0);
        this.fRelationsFileNameLabel = new Label((Composite)filesGroup, 0);
        this.fPropertiesFileNameLabel = new Label((Composite)filesGroup, 0);
        this.loadPreferences();
        this.validateFields();
    }

    private void updateFileLabels() {
        this.fElementsFileNameLabel.setText(this.fFilePrefixTextField.getText() + "elements.csv");
        this.fRelationsFileNameLabel.setText(this.fFilePrefixTextField.getText() + "relations.csv");
        this.fPropertiesFileNameLabel.setText(this.fFilePrefixTextField.getText() + "properties.csv");
        this.fElementsFileNameLabel.getParent().layout();
    }

    String getExportFolderPath() {
        return this.fFolderTextField.getText();
    }

    int getDelimiterIndex() {
        return this.fDelimiterCombo.getSelectionIndex();
    }

    String getFilenamePrefix() {
        return this.fFilePrefixTextField.getText().trim();
    }

    boolean getStripNewlines() {
        return this.fStripNewlinesButton.getSelection();
    }

    boolean getExcelCompatible() {
        return this.fExcelCompatibleButton.getSelection();
    }

    String getEncoding() {
        return this.fEncodingCombo.getText();
    }

    private String chooseFolderPath() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(Messages.ExportAsCSVPage_11);
        dialog.setMessage(Messages.ExportAsCSVPage_12);
        dialog.setFilterPath(this.fFolderTextField.getText());
        return dialog.open();
    }

    private void validateFields() {
        String folderPath = this.getExportFolderPath();
        if (!StringUtils.isSetAfterTrim((String)folderPath)) {
            this.setErrorMessage(Messages.ExportAsCSVPage_13);
            return;
        }
        File file = new File(folderPath);
        if (file.isFile()) {
            this.setErrorMessage(Messages.ExportAsCSVPage_14);
            return;
        }
        try {
            file = new File(this.getExportFolderPath(), this.fFilePrefixTextField.getText() + "elements.csv");
            file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.setErrorMessage(Messages.ExportAsCSVPage_14);
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    void storePreferences() {
        IPreferenceStore store = CSVImportExportPlugin.getInstance().getPreferenceStore();
        store.setValue("lastFolder", this.getExportFolderPath());
        store.setValue("separator", this.getDelimiterIndex());
        store.setValue("filePrefix", this.getFilenamePrefix());
        store.setValue("stripNewLines", this.getStripNewlines());
        store.setValue("excelCompatible", this.getExcelCompatible());
        store.setValue("encoding", this.getEncoding());
    }

    void loadPreferences() {
        String lastFilePrefix;
        IPreferenceStore store = CSVImportExportPlugin.getInstance().getPreferenceStore();
        String lastFolderPath = store.getString("lastFolder");
        if (lastFolderPath != null && !"".equals(lastFolderPath)) {
            this.fFolderTextField.setText(lastFolderPath);
        } else {
            this.fFolderTextField.setText(new File(System.getProperty("user.home")).getPath());
        }
        int separator = store.getInt("separator");
        if (separator > -1 && separator < DELIMITER_NAMES.length) {
            this.fDelimiterCombo.setText(DELIMITER_NAMES[separator]);
        }
        if ((lastFilePrefix = store.getString("filePrefix")) != null && !"".equals(lastFilePrefix)) {
            this.fFilePrefixTextField.setText(lastFilePrefix);
        }
        boolean selected = store.getBoolean("stripNewLines");
        this.fStripNewlinesButton.setSelection(selected);
        selected = store.getBoolean("excelCompatible");
        this.fExcelCompatibleButton.setSelection(selected);
        String encoding = store.getString("encoding");
        this.fEncodingCombo.setText(encoding);
    }
}

