/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.export;

import com.archimatetool.csv.CSVConstants;
import com.archimatetool.csv.export.CSVExporter;
import com.archimatetool.csv.export.ExportAsCSVPage;
import com.archimatetool.csv.export.Messages;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ExportAsCSVWizard
extends Wizard
implements CSVConstants {
    private ExportAsCSVPage fPage;
    private CSVExporter fExporter;

    public ExportAsCSVWizard(CSVExporter exporter) {
        this.fExporter = exporter;
        this.setWindowTitle(Messages.ExportAsCSVWizard_0);
    }

    public void addPages() {
        this.fPage = new ExportAsCSVPage();
        this.addPage((IWizardPage)this.fPage);
    }

    public boolean performFinish() {
        boolean result;
        String folderPath = this.fPage.getExportFolderPath();
        if (folderPath == null) {
            return false;
        }
        this.fExporter.setFilePrefix(this.fPage.getFilenamePrefix());
        this.fExporter.setDelimiter(DELIMITERS[this.fPage.getDelimiterIndex()]);
        this.fExporter.setStripNewLines(this.fPage.getStripNewlines());
        this.fExporter.setExcelCompatible(this.fPage.getExcelCompatible());
        this.fExporter.setEncoding(this.fPage.getEncoding());
        File folder = new File(folderPath);
        folder.mkdirs();
        File elementsFile = new File(folder, this.fExporter.createElementsFileName());
        if (elementsFile.exists() && !(result = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ExportAsCSVWizard_1, (String)Messages.ExportAsCSVWizard_2))) {
            return false;
        }
        this.fPage.storePreferences();
        try {
            this.fExporter.export(folder);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ExportAsCSVWizard_3, (String)(Messages.ExportAsCSVWizard_4 + " " + ex.getMessage()));
            return false;
        }
        return true;
    }
}

