/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.importer;

import com.archimatetool.csv.CSVParseException;
import com.archimatetool.csv.importer.CSVImporter;
import com.archimatetool.csv.importer.Messages;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.modelimporter.ImportException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class CSVImportHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IArchimateModel model;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IArchimateModel iArchimateModel = model = part != null ? (IArchimateModel)part.getAdapter(IArchimateModel.class) : null;
        if (model != null) {
            this.doImport(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), model);
        }
        return null;
    }

    private void doImport(IWorkbenchWindow window, IArchimateModel model) {
        File file = this.askOpenFile(window);
        if (file == null) {
            return;
        }
        if (!(CSVImporter.isElementsFileName(file) || CSVImporter.isRelationsFileName(file) || CSVImporter.isPropertiesFileName(file))) {
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.CSVImportHandler_0, (String)Messages.CSVImportHandler_1);
            return;
        }
        try {
            CSVImporter importer = new CSVImporter(model);
            importer.doImport(file);
        }
        catch (CSVParseException | ImportException | IOException ex) {
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.CSVImportHandler_0, (String)ex.getMessage());
        }
    }

    private File askOpenFile(IWorkbenchWindow window) {
        FileDialog dialog = new FileDialog(window.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.csv", "*.txt", "*.*"});
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }
}

