/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.csv.importer;

import com.archimatetool.csv.CSVConstants;
import com.archimatetool.csv.CSVParseException;
import com.archimatetool.csv.importer.Messages;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAccessRelationship;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IAssociationRelationship;
import com.archimatetool.model.IInfluenceRelationship;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.util.UUIDFactory;
import com.archimatetool.modelimporter.ImportException;
import com.archimatetool.modelimporter.ModelImporter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.input.BOMInputStream;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

public class CSVImporter
implements CSVConstants {
    private IArchimateModel targetModel;
    IArchimateModel newModel;
    Map<String, IArchimateRelationship> newRelations = new HashMap<String, IArchimateRelationship>();
    Map<IProperties, List<IProperty>> newProperties = new HashMap<IProperties, List<IProperty>>();
    Map<IArchimateRelationship, String[]> relationshipSourceTargets = new HashMap<IArchimateRelationship, String[]>();
    Map<String, IArchimateModelObject> objectLookup = new HashMap<String, IArchimateModelObject>();
    static final String EXPECTED_ERROR_MESSAGE = "Invalid character between encapsulated token and delimiter";

    public CSVImporter(IArchimateModel model) {
        this.targetModel = model;
    }

    public void doImport(File file) throws IOException, CSVParseException, ImportException {
        File propertiesFile;
        File relationsFile;
        this.copyModel();
        File elementsFile = this.getMatchingFile(file, "elements");
        if (elementsFile != null && elementsFile.exists()) {
            this.importElements(elementsFile);
        }
        if ((relationsFile = this.getMatchingFile(file, "relations")) != null && relationsFile.exists()) {
            this.importRelations(relationsFile);
        }
        if ((propertiesFile = this.getMatchingFile(file, "properties")) != null && propertiesFile.exists()) {
            this.importProperties(propertiesFile);
        }
        ModelImporter importer = new ModelImporter();
        importer.setUpdateAll(true);
        importer.doImport(this.newModel, this.targetModel);
    }

    void copyModel() {
        this.newModel = (IArchimateModel)EcoreUtil.copy((EObject)this.targetModel);
        IArchiveManager archiveManager = IArchiveManager.FACTORY.createArchiveManager((IArchimateModel)this.newModel);
        this.newModel.setAdapter(IArchiveManager.class, (Object)archiveManager);
        this.newModel.getFolder(FolderType.DIAGRAMS).getFolders().clear();
        this.newModel.getFolder(FolderType.DIAGRAMS).getElements().clear();
        TreeIterator iter = this.newModel.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof IArchimateModelObject)) continue;
            this.objectLookup.put(((IArchimateModelObject)element).getId(), (IArchimateModelObject)element);
        }
    }

    void importElements(File file) throws IOException, CSVParseException {
        List<CSVRecord> records = this.getRecords(file);
        if (records.isEmpty()) {
            throw new CSVParseException(Messages.CSVImporter_1);
        }
        if (!this.isHeaderRecord(records.get(0), MODEL_ELEMENTS_HEADER)) {
            throw new CSVParseException(Messages.CSVImporter_13);
        }
        int headerSize = records.get(0).size();
        int i = 1;
        while (i < records.size()) {
            CSVRecord csvRecord = records.get(i);
            if (csvRecord.size() != headerSize) {
                throw new CSVParseException(NLS.bind((String)Messages.CSVImporter_2, (Object)csvRecord.toString()));
            }
            if (this.isModelRecord(csvRecord)) {
                this.parseModelRecord(records.get(i));
            } else {
                this.createElementFromRecord(csvRecord);
            }
            ++i;
        }
    }

    private boolean isModelRecord(CSVRecord csvRecord) {
        return "ArchimateModel".equals(csvRecord.get(1));
    }

    private void parseModelRecord(CSVRecord csvRecord) {
        String modelPurpose;
        String modelName;
        String id = csvRecord.get(0);
        if (StringUtils.isSet((String)id)) {
            this.objectLookup.put(id, (IArchimateModelObject)this.newModel);
        }
        if ((modelName = csvRecord.get(2)) != null) {
            this.newModel.setName(modelName);
        }
        if ((modelPurpose = csvRecord.get(3)) != null) {
            this.newModel.setPurpose(modelPurpose);
        }
    }

    private void createElementFromRecord(CSVRecord csvRecord) throws CSVParseException {
        String specializationName;
        String id = csvRecord.get(0);
        if (!StringUtils.isSet((String)id)) {
            id = this.generateID();
        } else {
            this.checkIDForInvalidCharacters(id);
        }
        String type = csvRecord.get(1);
        EClass eClass = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(type);
        if (!this.isArchimateElementEClass(eClass)) {
            throw new CSVParseException(Messages.CSVImporter_3);
        }
        IArchimateElement element = (IArchimateElement)this.findObjectInModel(id, eClass);
        if (element == null) {
            element = (IArchimateElement)IArchimateFactory.eINSTANCE.create(eClass);
            element.setId(id);
            this.newModel.getDefaultFolderForObject((EObject)element).getElements().add((Object)element);
            this.objectLookup.put(element.getId(), (IArchimateModelObject)element);
        }
        String name = this.normalise(csvRecord.get(2));
        element.setName(name);
        String documentation = csvRecord.get(3);
        element.setDocumentation(documentation);
        String string = specializationName = csvRecord.size() > 4 ? csvRecord.get(4) : null;
        if (StringUtils.isSet((String)specializationName)) {
            this.setProfileForNewConcept((IArchimateConcept)element, specializationName);
        }
    }

    void importRelations(File file) throws IOException, CSVParseException {
        List<CSVRecord> records = this.getRecords(file);
        if (!this.isHeaderRecord(records.get(0), RELATIONSHIPS_HEADER)) {
            throw new CSVParseException(Messages.CSVImporter_14);
        }
        int headerSize = records.get(0).size();
        int i = 1;
        while (i < records.size()) {
            CSVRecord csvRecord = records.get(i);
            if (csvRecord.size() != headerSize) {
                throw new CSVParseException(NLS.bind((String)Messages.CSVImporter_2, (Object)csvRecord.toString()));
            }
            this.createRelationFromRecord(csvRecord);
            ++i;
        }
        for (Map.Entry<String, IArchimateRelationship> entry : this.newRelations.entrySet()) {
            IArchimateRelationship relation = entry.getValue();
            String[] sourceTargets = this.relationshipSourceTargets.get(relation);
            IArchimateConcept source = this.findReferencedConcept(sourceTargets[0]);
            IArchimateConcept target = this.findReferencedConcept(sourceTargets[1]);
            if (!ArchimateModelUtils.isValidRelationship((EClass)source.eClass(), (EClass)target.eClass(), (EClass)relation.eClass())) {
                throw new CSVParseException(Messages.CSVImporter_5 + relation.getId());
            }
            relation.connect(source, target);
        }
    }

    private void createRelationFromRecord(CSVRecord csvRecord) throws CSVParseException {
        String specializationName;
        String id = csvRecord.get(0);
        if (!StringUtils.isSet((String)id)) {
            id = this.generateID();
        } else {
            this.checkIDForInvalidCharacters(id);
        }
        String type = csvRecord.get(1);
        EClass eClass = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(type);
        if (!this.isArchimateRelationshipEClass(eClass)) {
            throw new CSVParseException(Messages.CSVImporter_4 + id);
        }
        String sourceID = csvRecord.get(4);
        String targetID = csvRecord.get(5);
        IArchimateRelationship relation = (IArchimateRelationship)this.findObjectInModel(id, eClass);
        if (relation == null || !Objects.equals(sourceID, relation.getSource().getId()) || !Objects.equals(targetID, relation.getTarget().getId())) {
            relation = (IArchimateRelationship)IArchimateFactory.eINSTANCE.create(eClass);
            relation.setId(id);
            this.newModel.getDefaultFolderForObject((EObject)relation).getElements().add((Object)relation);
            this.newRelations.put(id, relation);
            this.objectLookup.put(relation.getId(), (IArchimateModelObject)relation);
        }
        this.relationshipSourceTargets.put(relation, new String[]{sourceID, targetID});
        String name = this.normalise(csvRecord.get(2));
        relation.setName(name);
        String documentation = csvRecord.get(3);
        relation.setDocumentation(documentation);
        String string = specializationName = csvRecord.size() > 6 ? csvRecord.get(6) : null;
        if (StringUtils.isSet((String)specializationName)) {
            this.setProfileForNewConcept((IArchimateConcept)relation, specializationName);
        }
    }

    void importProperties(File file) throws IOException, CSVParseException {
        for (CSVRecord cSVRecord : this.getRecords(file)) {
            if (!this.isPropertiesRecordCorrectSize(cSVRecord)) {
                throw new CSVParseException(Messages.CSVImporter_2);
            }
            if (this.isHeaderRecord(cSVRecord, PROPERTIES_HEADER)) continue;
            this.createPropertyFromRecord(cSVRecord);
        }
        for (Map.Entry entry : this.newProperties.entrySet()) {
            for (IProperty p : (List)entry.getValue()) {
                ((IProperties)entry.getKey()).getProperties().add((Object)p);
            }
        }
    }

    private boolean isPropertiesRecordCorrectSize(CSVRecord csvRecord) {
        return csvRecord.size() == PROPERTIES_HEADER.length;
    }

    private void createPropertyFromRecord(CSVRecord csvRecord) throws CSVParseException {
        String id = csvRecord.get(0);
        if (!StringUtils.isSet((String)id)) {
            throw new CSVParseException(Messages.CSVImporter_6);
        }
        this.checkIDForInvalidCharacters(id);
        IProperties propertiesObject = (IProperties)this.findObjectInModel(id, IArchimatePackage.eINSTANCE.getProperties());
        if (propertiesObject == null) {
            throw new CSVParseException(Messages.CSVImporter_7 + id);
        }
        String key = this.normalise(csvRecord.get(1));
        String value = this.normalise(csvRecord.get(2));
        if ("Influence_Strength".equals(key) && propertiesObject instanceof IInfluenceRelationship) {
            ((IInfluenceRelationship)propertiesObject).setStrength(value);
            return;
        }
        if ("Access_Type".equals(key) && propertiesObject instanceof IAccessRelationship) {
            int newvalue = ACCESS_TYPES.indexOf(value);
            ((IAccessRelationship)propertiesObject).setAccessType(newvalue);
            return;
        }
        if ("Directed".endsWith(key) && propertiesObject instanceof IAssociationRelationship) {
            boolean newvalue = "true".equalsIgnoreCase(value);
            ((IAssociationRelationship)propertiesObject).setDirected(newvalue);
            return;
        }
        if ("Junction_Type".equals(key) && propertiesObject instanceof IJunction) {
            value = "And".equals(value) ? "" : "or";
            ((IJunction)propertiesObject).setType(value);
            return;
        }
        IProperty property = this.getProperty(propertiesObject, key);
        if (property != null) {
            property.setValue(value);
        } else {
            property = IArchimateFactory.eINSTANCE.createProperty();
            property.setKey(key);
            property.setValue(value);
            List<IProperty> list = this.newProperties.get(propertiesObject);
            if (list == null) {
                list = new ArrayList<IProperty>();
                this.newProperties.put(propertiesObject, list);
            }
            list.add(property);
        }
    }

    List<CSVRecord> getRecords(File file) throws IOException {
        char[] delimiters = new char[]{',', ';', '\t'};
        IOException ex = new IOException("Failed to parse CSV!");
        char[] cArray = delimiters;
        int n = delimiters.length;
        int n2 = 0;
        while (n2 < n) {
            char delimiter = cArray[n2];
            BOMInputStream bomIn = ((BOMInputStream.Builder)BOMInputStream.builder().setFile(file)).get();
            InputStreamReader reader = new InputStreamReader((InputStream)bomIn, "UTF-8");
            CSVFormat csvFormat = CSVFormat.Builder.create().setDelimiter(delimiter).get();
            try {
                Throwable throwable = null;
                Object var12_14 = null;
                try (CSVParser parser = CSVParser.parse((Reader)reader, (CSVFormat)csvFormat);){
                    return parser.getRecords();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (UncheckedIOException ex1) {
                ex = ex1.getCause();
                if (ex.getMessage() == null || !ex.getMessage().contains(EXPECTED_ERROR_MESSAGE)) break;
                ++n2;
            }
        }
        throw ex;
    }

    static boolean isElementsFileName(File file) {
        String name = FileUtils.getFileNameWithoutExtension((File)file);
        return name.endsWith("elements");
    }

    static boolean isRelationsFileName(File file) {
        String name = FileUtils.getFileNameWithoutExtension((File)file);
        return name.endsWith("relations");
    }

    static boolean isPropertiesFileName(File file) {
        String name = FileUtils.getFileNameWithoutExtension((File)file);
        return name.endsWith("properties");
    }

    File getMatchingFile(File file, String target) {
        String match = null;
        if (CSVImporter.isElementsFileName(file)) {
            match = "elements";
        } else if (CSVImporter.isRelationsFileName(file)) {
            match = "relations";
        } else if (CSVImporter.isPropertiesFileName(file)) {
            match = "properties";
        } else {
            return null;
        }
        String path = file.getPath();
        int index = path.lastIndexOf(match);
        path = new StringBuilder(path).replace(index, index + match.length(), target).toString();
        return new File(path);
    }

    String normalise(String s) {
        if (s == null) {
            return "";
        }
        s = s.replaceAll("(\r\n|\r|\n|\t)", " ");
        return s;
    }

    private boolean isHeaderRecord(CSVRecord csvRecord, String[] fields) {
        if (csvRecord.getRecordNumber() != 1L) {
            return false;
        }
        int i = 0;
        while (i < csvRecord.size()) {
            String r = csvRecord.get(i);
            if (!r.equalsIgnoreCase(fields[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String generateID() {
        return UUIDFactory.createID(null);
    }

    void checkIDForInvalidCharacters(String id) throws CSVParseException {
        if (!id.matches("^[a-zA-Z0-9._-]+$")) {
            throw new CSVParseException(Messages.CSVImporter_12 + id);
        }
    }

    EObject findObjectInModel(String id, EClass eClass) throws CSVParseException {
        EObject eObject = (EObject)this.objectLookup.get(id);
        if (eObject != null) {
            if (eClass != null && eClass.isInstance((Object)eObject)) {
                return eObject;
            }
            throw new CSVParseException(Messages.CSVImporter_9 + id);
        }
        return null;
    }

    IArchimateConcept findReferencedConcept(String id) throws CSVParseException {
        EObject eObject = (EObject)this.objectLookup.get(id);
        if (eObject == null) {
            throw new CSVParseException(Messages.CSVImporter_10 + id);
        }
        if (!this.isArchimateConceptEClass(eObject.eClass())) {
            throw new CSVParseException(Messages.CSVImporter_11 + id);
        }
        return (IArchimateConcept)eObject;
    }

    boolean isArchimateConceptEClass(EClass eClass) {
        return eClass != null && IArchimatePackage.eINSTANCE.getArchimateConcept().isSuperTypeOf(eClass);
    }

    boolean isArchimateElementEClass(EClass eClass) {
        return eClass != null && IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(eClass);
    }

    boolean isArchimateRelationshipEClass(EClass eClass) {
        return eClass != null && IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass);
    }

    IProperty getProperty(IProperties propertiesObject, String key) {
        for (IProperty property : propertiesObject.getProperties()) {
            if (!property.getKey().equals(key)) continue;
            return property;
        }
        return null;
    }

    private void setProfileForNewConcept(IArchimateConcept newConcept, String specializationName) {
        IProfile profile = ArchimateModelUtils.getProfileByNameAndType((IArchimateModel)this.newModel, (String)specializationName, (String)newConcept.eClass().getName());
        if (profile == null) {
            profile = IArchimateFactory.eINSTANCE.createProfile();
            profile.setName(specializationName);
            profile.setConceptType(newConcept.eClass().getName());
            this.newModel.getProfiles().add((Object)profile);
        }
        newConcept.getProfiles().add((Object)profile);
    }
}

