/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.help.hints;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.IHelpHintProvider;
import com.archimatetool.editor.ui.ThemeUtils;
import com.archimatetool.editor.ui.services.ComponentSelectionManager;
import com.archimatetool.editor.ui.services.IComponentSelectionListener;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.help.ArchiHelpPlugin;
import com.archimatetool.help.hints.IHintsView;
import com.archimatetool.help.hints.Messages;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IDiagramModelComponent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Files;
import java.util.Hashtable;
import java.util.function.Consumer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class HintsView
extends ViewPart
implements IContextProvider,
IHintsView,
ISelectionListener,
IComponentSelectionListener,
IContributedContentsView {
    private String cssString = "";
    private Browser fBrowser;
    private IAction fActionPinContent;
    private Hashtable<String, Hint> fLookupTable = new Hashtable();
    private String fLastPath;
    private CLabel fTitleLabel;

    public HintsView() {
        try {
            this.cssString = Files.readString(java.nio.file.Path.of(ArchiHelpPlugin.getInstance().getHintsFolder().getPath(), "style.css"));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (!JFaceResources.getFontRegistry().hasValueFor("HintsTitleFont")) {
            FontData[] fontData = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont").getFontData();
            fontData[0].setHeight(fontData[0].getHeight() + 4);
            JFaceResources.getFontRegistry().put("HintsTitleFont", fontData);
        }
        this.fTitleLabel = new CLabel(parent, 0);
        this.fTitleLabel.setFont(JFaceResources.getFont((String)"HintsTitleFont"));
        if (!ThemeUtils.isDarkTheme()) {
            this.fTitleLabel.setData("style", (Object)"background-color: RGB(220, 235, 235); color: #000;");
            this.fTitleLabel.setBackground(new Color(220, 235, 235));
        }
        GridData gd = new GridData(768);
        this.fTitleLabel.setLayoutData((Object)gd);
        this.fBrowser = this.createBrowser(parent);
        if (this.fBrowser == null) {
            this.fTitleLabel.setText(Messages.HintsView_2);
            Text text = new Text(parent, 66);
            text.setLayoutData((Object)new GridData(1808));
            text.setText(Messages.HintsView_3);
            text.setForeground(new Color(255, 45, 45));
            return;
        }
        gd = new GridData(1808);
        this.fBrowser.setLayoutData((Object)gd);
        ComponentSelectionManager.INSTANCE.addSelectionListener((IComponentSelectionListener)this);
        this.fActionPinContent = new PinAction();
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(this.fActionPinContent);
        this.createFileMap();
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.hintsViewHelp");
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        IWorkbenchPart part = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
        this.selectionChanged(part, selection);
    }

    /*
     * Unable to fully structure code
     */
    private Browser createBrowser(Composite parent) {
        try {
            browser = new Browser(parent, 0);
            browser.addLocationListener(LocationListener.changingAdapter((Consumer<LocationEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$0(org.eclipse.swt.browser.LocationEvent ), (Lorg/eclipse/swt/browser/LocationEvent;)V)((HintsView)this)));
            browser.addProgressListener(ProgressListener.completedAdapter((Consumer<ProgressEvent>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$1(org.eclipse.swt.browser.Browser org.eclipse.swt.browser.ProgressEvent ), (Lorg/eclipse/swt/browser/ProgressEvent;)V)((HintsView)this, (Browser)browser)));
            browser.setText(this.makeHTMLEntry(""));
            return browser;
        }
        catch (SWTError error) {
            error.printStackTrace();
            var6_4 = parent.getChildren();
            var5_5 = var6_4.length;
            var4_6 = 0;
            ** while (var4_6 < var5_5)
        }
lbl-1000:
        // 1 sources

        {
            child = var6_4[var4_6];
            if (child != this.fTitleLabel) {
                child.dispose();
            }
            ++var4_6;
            continue;
        }
lbl19:
        // 1 sources

        return null;
    }

    public void setFocus() {
        if (this.fBrowser != null) {
            this.fBrowser.setFocus();
        } else if (this.fTitleLabel != null) {
            this.fTitleLabel.setFocus();
        }
    }

    public void componentSelectionChanged(Object component, Object selection) {
        this.showHintForSelected(component, selection);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object selected = ((IStructuredSelection)selection).getFirstElement();
            this.showHintForSelected(part, selected);
        }
    }

    private void showHintForSelected(Object source, Object selected) {
        IHelpHintProvider provider;
        if (this.fBrowser == null) {
            return;
        }
        if (this.fActionPinContent.isChecked()) {
            return;
        }
        Object actualObject = selected;
        if (selected instanceof IAdaptable && (actualObject = ((IAdaptable)selected).getAdapter(IArchimateConcept.class)) == null) {
            actualObject = ((IAdaptable)selected).getAdapter(IDiagramModelComponent.class);
        }
        String title = "";
        String content = null;
        String path = null;
        Hint hint = this.getHintForObject(actualObject);
        if (hint != null) {
            title = hint.title;
            path = hint.path;
        }
        if ((provider = (IHelpHintProvider)(actualObject instanceof IHelpHintProvider ? actualObject : (selected instanceof IHelpHintProvider ? selected : null))) != null) {
            if (StringUtils.isSet((String)provider.getHelpHintTitle())) {
                title = provider.getHelpHintTitle();
            }
            if (StringUtils.isSet((String)provider.getHelpHintContent())) {
                content = this.makeHTMLEntry(provider.getHelpHintContent());
            }
        }
        this.fTitleLabel.setText(title);
        this.fBrowser.setJavascriptEnabled(ArchiPlugin.getInstance().getPreferenceStore().getBoolean("hintsJSEnabled"));
        if (content != null) {
            this.fBrowser.setText(content);
            this.fLastPath = "";
        } else if (path != null) {
            if (this.fLastPath != path) {
                this.fBrowser.setUrl("file:///" + path);
                this.fLastPath = path;
            }
        } else {
            this.fBrowser.setText("");
            this.fLastPath = "";
        }
    }

    private Hint getHintForObject(Object object) {
        if (object == null) {
            return null;
        }
        Object className = object instanceof EClass ? ((EClass)object).getName() : object.getClass().getSimpleName();
        if (object instanceof IArchimateDiagramModel) {
            className = (String)className + ((IArchimateDiagramModel)object).getViewpoint();
        }
        return this.fLookupTable.get(className);
    }

    private String makeHTMLEntry(String text) {
        if (text == null) {
            return "";
        }
        StringBuffer html = new StringBuffer();
        html.append("<html><head>");
        html.append("<style>");
        html.append(this.cssString);
        html.append("</style>");
        html.append("</head>");
        html.append("<body>");
        html.append(text);
        html.append("</body>");
        html.append("</html>");
        return html.toString();
    }

    private boolean isLocalURL(String url) {
        return url != null && (url.startsWith("file:") || url.startsWith("data:") || url.startsWith("about:"));
    }

    private void createFileMap() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor("com.archimatetool.help.hints");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                Object className = configurationElement.getAttribute("className");
                String fileName = configurationElement.getAttribute("file");
                String title = configurationElement.getAttribute("title");
                String key = configurationElement.getAttribute("key");
                String id = configurationElement.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)id);
                URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("$nl$/" + fileName), null);
                try {
                    url = FileLocator.resolve((URL)url);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    break block5;
                }
                if (url != null) {
                    File f = new File(url.getPath());
                    Hint hint = new Hint(title, f.getPath());
                    if (key != null) {
                        className = (String)className + key;
                    }
                    this.fLookupTable.put((String)className, hint);
                }
            }
            ++n2;
        }
    }

    public IWorkbenchPart getContributingPart() {
        return null;
    }

    public void dispose() {
        super.dispose();
        ComponentSelectionManager.INSTANCE.removeSelectionListener((IComponentSelectionListener)this);
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.hintsViewHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.HintsView_4;
    }

    private /* synthetic */ void lambda$0(LocationEvent e) {
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("hintsExternalHostsEnabled")) {
            e.doit = this.isLocalURL(e.location);
        }
    }

    private /* synthetic */ void lambda$1(Browser browser, ProgressEvent e) {
        if (browser.getJavascriptEnabled() && ThemeUtils.isDarkTheme() && this.isLocalURL(browser.getUrl())) {
            browser.execute("document.body.classList.add('dark-mode');");
        }
    }

    private static class Hint {
        String title;
        String path;

        Hint(String title, String path) {
            this.title = title;
            this.path = path;
        }
    }

    private static class PinAction
    extends Action {
        PinAction() {
            super(Messages.HintsView_0, 2);
            this.setToolTipText(Messages.HintsView_1);
            this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/pin.png"));
        }
    }
}

