/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.zest;

import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.editor.views.AbstractModelView;
import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.editor.views.tree.actions.IViewerAction;
import com.archimatetool.editor.views.tree.actions.PropertiesAction;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import com.archimatetool.zest.ArchiZestPlugin;
import com.archimatetool.zest.CopyZestViewAsImageToClipboardAction;
import com.archimatetool.zest.DrillDownManager;
import com.archimatetool.zest.ExportAsImageAction;
import com.archimatetool.zest.IZestView;
import com.archimatetool.zest.Messages;
import com.archimatetool.zest.ZestGraphViewer;
import com.archimatetool.zest.ZestViewerContentProvider;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;

public class ZestView
extends AbstractModelView
implements IZestView,
ISelectionListener {
    private ZestGraphViewer fGraphViewer;
    private CLabel fLabel;
    private IAction fActionLayout;
    private IViewerAction fActionProperties;
    private IAction fActionPinContent;
    private IAction fActionCopyImageToClipboard;
    private IAction fActionExportImageToFile;
    private IAction fActionSelectInModelTree;
    private IAction[] fDepthActions;
    private IAction[] fDirectionActions;
    private List<IAction> fViewpointActions;
    private List<IAction> fRelationshipActions;
    private IAction fNoneRelationshipAction;
    private List<IAction> fAllElementActions;
    private IAction fNoneElementAction;
    private List<IAction> fStrategyElementActions;
    private List<IAction> fBusinessElementActions;
    private List<IAction> fApplicationElementActions;
    private List<IAction> fTechnologyElementActions;
    private List<IAction> fPhysicalElementActions;
    private List<IAction> fImplementationMigrationElementActions;
    private List<IAction> fMotivationElementActions;
    private List<IAction> fOtherElementActions;
    private DrillDownManager fDrillDownManager;

    protected void doCreatePartControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fLabel = new CLabel(parent, 0);
        this.fLabel.setLayoutData((Object)new GridData(768));
        this.fGraphViewer = new ZestGraphViewer(parent, 0);
        this.fGraphViewer.getGraphControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fGraphViewer.setLayoutAlgorithm((LayoutAlgorithm)new SpringLayoutAlgorithm(1), true);
        this.fGraphViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ZestView.this.updateActions();
                ZestView.this.getSite().getSelectionProvider().setSelection(event.getSelection());
            }
        });
        this.fGraphViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ZestView.this.fDrillDownManager.goInto();
            }
        });
        this.fDrillDownManager = new DrillDownManager(this);
        this.makeActions();
        this.hookContextMenu();
        this.registerGlobalActions();
        this.makeLocalToolBar();
        this.updateActions();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.getSite().getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fGraphViewer.getControl(), "com.archimatetool.help.zestViewHelp");
        ISelection selection = this.getSite().getWorkbenchWindow().getSelectionService().getSelection();
        this.selectionChanged(null, selection);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == this) {
            return;
        }
        if (this.fActionPinContent.isChecked()) {
            return;
        }
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            this.setElement(object);
        }
    }

    protected void selectAll() {
        this.fGraphViewer.getGraphControl().selectAll();
    }

    private void setElement(Object object) {
        IArchimateConcept concept = null;
        if (object instanceof IArchimateConcept) {
            concept = (IArchimateConcept)object;
        } else if (object instanceof IAdaptable) {
            concept = (IArchimateConcept)((IAdaptable)object).getAdapter(IArchimateConcept.class);
        }
        this.fDrillDownManager.setNewInput(concept);
        this.updateActions();
        this.updateLabel();
    }

    void refresh() {
        this.updateActions();
        this.updateLabel();
        this.getViewer().refresh();
    }

    void updateLabel() {
        Object relations;
        Object elements;
        String text = ArchiLabelProvider.INSTANCE.getLabel((Object)this.fDrillDownManager.getCurrentConcept());
        text = StringUtils.escapeAmpersandsInText((String)text);
        String viewPointName = this.getContentProvider().getViewpointFilter().getName();
        if (this.getContentProvider().getElementFilters().isEmpty()) {
            elements = Messages.ZestView_7;
        } else {
            elements = "[";
            for (EClass eClass : this.getContentProvider().getElementFilters()) {
                elements = (String)elements + this.getFilterName(eClass) + ", ";
            }
            elements = ((String)elements).replaceAll(", $", "");
            elements = (String)elements + "]";
        }
        if (this.getContentProvider().getRelationshipFilters().isEmpty()) {
            relations = Messages.ZestView_7;
        } else {
            relations = "[";
            for (EClass eClass : this.getContentProvider().getRelationshipFilters()) {
                relations = (String)relations + this.getFilterName(eClass) + ", ";
            }
            relations = ((String)relations).replaceAll(", $", "");
            relations = (String)relations + "]";
        }
        this.fLabel.setText(text + " (" + Messages.ZestView_5 + ": " + viewPointName + ", " + Messages.ZestView_9 + ": " + (String)elements + ", " + Messages.ZestView_6 + ": " + (String)relations + ")");
        this.fLabel.setImage(ArchiLabelProvider.INSTANCE.getImage((Object)this.fDrillDownManager.getCurrentConcept()));
    }

    void updateActions() {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        this.fActionProperties.update();
        this.fActionSelectInModelTree.setEnabled(!selection.isEmpty());
        boolean hasData = this.fGraphViewer.getInput() != null;
        this.fActionExportImageToFile.setEnabled(hasData);
        this.fActionCopyImageToClipboard.setEnabled(hasData);
        this.fActionLayout.setEnabled(hasData);
        this.updateUndoActions();
    }

    private void makeLocalToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.fDrillDownManager.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionPinContent);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionLayout);
        IMenuManager menuManager = bars.getMenuManager();
        menuManager.add((IContributionItem)this.createDepthMenu());
        menuManager.add((IContributionItem)this.createViewpointMenu());
        menuManager.add((IContributionItem)this.createElementsMenu());
        menuManager.add((IContributionItem)this.createRelationshipsMenu());
        menuManager.add((IContributionItem)this.createDirectionMenu());
        menuManager.add((IContributionItem)new Separator());
        menuManager.add(this.fActionSelectInModelTree);
        menuManager.add(this.fActionCopyImageToClipboard);
        menuManager.add(this.fActionExportImageToFile);
    }

    private String getFilterName(EClass eClass) {
        return eClass == null ? Messages.ZestView_7 : ArchiLabelProvider.INSTANCE.getDefaultName(eClass);
    }

    public void setFocus() {
        if (this.fGraphViewer != null) {
            this.fGraphViewer.getControl().setFocus();
        }
    }

    public ZestGraphViewer getViewer() {
        return this.fGraphViewer;
    }

    private void makeActions() {
        this.createDepthActions();
        this.createViewpointActions();
        this.createElementsActions();
        this.createRelationshipsActions();
        this.createDirectionActions();
        this.fActionProperties = new PropertiesAction((ISelectionProvider)this.getViewer());
        this.fActionLayout = new Action(Messages.ZestView_0){

            public void run() {
                ZestView.this.fGraphViewer.doApplyLayout();
            }

            public String getToolTipText() {
                return this.getText();
            }

            public ImageDescriptor getImageDescriptor() {
                return ResourceLocator.imageDescriptorFromBundle((String)"com.archimatetool.zest", (String)"img/layout.gif").orElse(null);
            }
        };
        this.fActionPinContent = new Action(Messages.ZestView_4, 2){
            {
                this.setToolTipText(Messages.ZestView_1);
                this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/pin.png"));
            }
        };
        this.fActionCopyImageToClipboard = new CopyZestViewAsImageToClipboardAction(this);
        this.fActionExportImageToFile = new ExportAsImageAction(this.fGraphViewer);
        this.fActionSelectInModelTree = new Action(Messages.ZestView_8){
            {
                this.setToolTipText(this.getText());
                this.setActionDefinitionId("com.archimatetool.editor.selectInModelTree");
                IHandlerService service = (IHandlerService)ZestView.this.getSite().getService(IHandlerService.class);
                service.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
            }

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ZestView.this.getViewer().getSelection();
                ITreeModelView view = (ITreeModelView)ViewManager.showViewPart((String)"com.archimatetool.editor.treeModelView", (boolean)true);
                if (view != null && !selection.isEmpty()) {
                    view.getViewer().setSelection((ISelection)new StructuredSelection(selection.toArray()), true);
                }
            }
        };
    }

    private void createDepthActions() {
        this.fDepthActions = new Action[6];
        int i = 0;
        while (i < this.fDepthActions.length) {
            this.fDepthActions[i] = this.createDepthAction(i, i + 1);
            ++i;
        }
        int depth = ArchiZestPlugin.getInstance().getPreferenceStore().getInt("visualiserDepth");
        this.getContentProvider().setDepth(depth);
        this.fDepthActions[depth].setChecked(true);
    }

    private IAction createDepthAction(int actionId, int depth) {
        Action act = new Action(Messages.ZestView_3 + " " + depth, 8){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ZestView.this.fGraphViewer.getSelection();
                int depth = Integer.valueOf(this.getId());
                ZestView.this.getContentProvider().setDepth(depth);
                ArchiZestPlugin.getInstance().getPreferenceStore().setValue("visualiserDepth", depth);
                ZestView.this.fGraphViewer.setInput(ZestView.this.fGraphViewer.getInput());
                ZestView.this.fGraphViewer.setSelection((ISelection)selection);
                ZestView.this.fGraphViewer.doApplyLayout();
            }
        };
        act.setId(Integer.toString(actionId));
        return act;
    }

    private void createViewpointActions() {
        String viewpointID = ArchiZestPlugin.getInstance().getPreferenceStore().getString("visualiserViewpoint");
        this.getContentProvider().setViewpointFilter(ViewpointManager.INSTANCE.getViewpoint(viewpointID));
        this.fViewpointActions = new ArrayList<IAction>();
        for (IViewpoint vp : ViewpointManager.INSTANCE.getAllViewpoints()) {
            IAction action = this.createViewpointMenuAction(vp);
            this.fViewpointActions.add(action);
            if (!vp.getID().equals(viewpointID)) continue;
            action.setChecked(true);
        }
    }

    private IAction createViewpointMenuAction(final IViewpoint vp) {
        Action act = new Action(vp.getName(), 8){

            public void run() {
                ZestView.this.getContentProvider().setViewpointFilter(vp);
                ArchiZestPlugin.getInstance().getPreferenceStore().setValue("visualiserViewpoint", vp.getID());
                ZestView.this.fGraphViewer.setInput(ZestView.this.fGraphViewer.getInput());
                IStructuredSelection selection = (IStructuredSelection)ZestView.this.fGraphViewer.getSelection();
                ZestView.this.fGraphViewer.setSelection((ISelection)selection);
                ZestView.this.fGraphViewer.doApplyLayout();
                ZestView.this.updateLabel();
            }
        };
        act.setId(vp.getID());
        return act;
    }

    private void createElementsActions() {
        this.fAllElementActions = new ArrayList<IAction>();
        this.fNoneElementAction = this.createElementAction(null);
        this.fAllElementActions.add(this.fNoneElementAction);
        this.fStrategyElementActions = this.createElementActionsGroup(ArchimateModelUtils.getStrategyClasses());
        this.fBusinessElementActions = this.createElementActionsGroup(ArchimateModelUtils.getBusinessClasses());
        this.fApplicationElementActions = this.createElementActionsGroup(ArchimateModelUtils.getApplicationClasses());
        this.fTechnologyElementActions = this.createElementActionsGroup(ArchimateModelUtils.getTechnologyClasses());
        this.fPhysicalElementActions = this.createElementActionsGroup(ArchimateModelUtils.getPhysicalClasses());
        this.fMotivationElementActions = this.createElementActionsGroup(ArchimateModelUtils.getMotivationClasses());
        this.fImplementationMigrationElementActions = this.createElementActionsGroup(ArchimateModelUtils.getImplementationMigrationClasses());
        this.fOtherElementActions = this.createElementActionsGroup(ArchimateModelUtils.getOtherClasses());
        String elementPrefs = ArchiZestPlugin.getInstance().getPreferenceStore().getString("visualiserElements");
        if ("".equals(elementPrefs)) {
            this.fNoneElementAction.setChecked(true);
        } else {
            String[] stringArray = elementPrefs.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                EClass elementClass = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(s);
                if (elementClass != null) {
                    this.getContentProvider().addElementFilter(elementClass);
                    for (IAction a : this.fAllElementActions) {
                        if (!a.getId().equals(elementClass.getName())) continue;
                        a.setChecked(true);
                    }
                }
                ++n2;
            }
        }
    }

    private List<IAction> createElementActionsGroup(EClass[] eClasses) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        ArrayList<EClass> list = new ArrayList<EClass>(Arrays.asList(eClasses));
        list.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (EClass elem : list) {
            IAction elementAction = this.createElementAction(elem);
            actions.add(elementAction);
            this.fAllElementActions.add(elementAction);
        }
        return actions;
    }

    private IAction createElementAction(final EClass elementClass) {
        String id = elementClass == null ? "none" : elementClass.getName();
        Action act = new Action(this.getFilterName(elementClass), 2){

            public void run() {
                if (this.isChecked()) {
                    ZestView.this.getContentProvider().addElementFilter(elementClass);
                } else {
                    ZestView.this.getContentProvider().removeElementFilter(elementClass);
                }
                ZestView.this.fGraphViewer.setInput(ZestView.this.fGraphViewer.getInput());
                IStructuredSelection selection = (IStructuredSelection)ZestView.this.fGraphViewer.getSelection();
                ZestView.this.fGraphViewer.setSelection((ISelection)selection);
                ZestView.this.fGraphViewer.doApplyLayout();
                ZestView.this.updateLabel();
                if (elementClass == null) {
                    for (IAction a : ZestView.this.fAllElementActions) {
                        a.setChecked(a == this);
                    }
                } else {
                    ZestView.this.fNoneElementAction.setChecked(ZestView.this.getContentProvider().getElementFilters().isEmpty());
                }
                Object elements = "";
                for (EClass eClass : ZestView.this.getContentProvider().getElementFilters()) {
                    elements = (String)elements + eClass.getName() + " ";
                }
                ArchiZestPlugin.getInstance().getPreferenceStore().setValue("visualiserElements", (String)elements);
            }
        };
        act.setId(id);
        return act;
    }

    private void createRelationshipsActions() {
        this.fRelationshipActions = new ArrayList<IAction>();
        this.fNoneRelationshipAction = this.createRelationshipMenuAction(null);
        this.fRelationshipActions.add(this.fNoneRelationshipAction);
        ArrayList<EClass> list = new ArrayList<EClass>(Arrays.asList(ArchimateModelUtils.getRelationsClasses()));
        list.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
        for (EClass rel : list) {
            this.fRelationshipActions.add(this.createRelationshipMenuAction(rel));
        }
        String relationsPrefs = ArchiZestPlugin.getInstance().getPreferenceStore().getString("visualiserRelationships");
        if ("".equals(relationsPrefs)) {
            this.fNoneRelationshipAction.setChecked(true);
        } else {
            String[] stringArray = relationsPrefs.split(" ");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                EClass relationClass = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(s);
                if (relationClass != null) {
                    this.getContentProvider().addRelationshipFilter(relationClass);
                    for (IAction a : this.fRelationshipActions) {
                        if (!a.getId().equals(relationClass.getName())) continue;
                        a.setChecked(true);
                    }
                }
                ++n2;
            }
        }
    }

    private IAction createRelationshipMenuAction(final EClass relationClass) {
        String id = relationClass == null ? "none" : relationClass.getName();
        Action act = new Action(this.getFilterName(relationClass), 2){

            public void run() {
                if (this.isChecked()) {
                    ZestView.this.getContentProvider().addRelationshipFilter(relationClass);
                } else {
                    ZestView.this.getContentProvider().removeElementFilter(relationClass);
                }
                ZestView.this.fGraphViewer.setInput(ZestView.this.fGraphViewer.getInput());
                IStructuredSelection selection = (IStructuredSelection)ZestView.this.fGraphViewer.getSelection();
                ZestView.this.fGraphViewer.setSelection((ISelection)selection);
                ZestView.this.fGraphViewer.doApplyLayout();
                ZestView.this.updateLabel();
                if (relationClass == null) {
                    for (IAction a : ZestView.this.fRelationshipActions) {
                        a.setChecked(a == this);
                    }
                } else {
                    ZestView.this.fNoneRelationshipAction.setChecked(ZestView.this.getContentProvider().getRelationshipFilters().isEmpty());
                }
                Object relations = "";
                for (EClass eClass : ZestView.this.getContentProvider().getRelationshipFilters()) {
                    relations = (String)relations + eClass.getName() + " ";
                }
                ArchiZestPlugin.getInstance().getPreferenceStore().setValue("visualiserRelationships", (String)relations);
            }
        };
        act.setId(id);
        return act;
    }

    private void createDirectionActions() {
        this.fDirectionActions = new Action[3];
        this.fDirectionActions[0] = this.createDirectionMenuAction(0, Messages.ZestView_33, 1);
        this.fDirectionActions[1] = this.createDirectionMenuAction(1, Messages.ZestView_34, 2);
        this.fDirectionActions[2] = this.createDirectionMenuAction(2, Messages.ZestView_35, 3);
        int direction = ArchiZestPlugin.getInstance().getPreferenceStore().getInt("visualiserDirection");
        this.getContentProvider().setDirection(direction);
        this.fDirectionActions[direction].setChecked(true);
    }

    private IAction createDirectionMenuAction(final int actionId, String label, final int orientation) {
        Action act = new Action(label, 8){

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)ZestView.this.fGraphViewer.getSelection();
                ZestView.this.getContentProvider().setDirection(orientation);
                ArchiZestPlugin.getInstance().getPreferenceStore().setValue("visualiserDirection", actionId);
                ZestView.this.fGraphViewer.setInput(ZestView.this.fGraphViewer.getInput());
                ZestView.this.fGraphViewer.setSelection((ISelection)selection);
                ZestView.this.fGraphViewer.doApplyLayout();
            }
        };
        act.setId(Integer.toString(actionId));
        return act;
    }

    private void registerGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fActionProperties);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#ZestViewPopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ZestView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getViewer());
    }

    private void fillContextMenu(IMenuManager manager) {
        Object selected = ((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
        boolean isEmpty = selected == null;
        this.fDrillDownManager.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionLayout);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)this.createDepthMenu());
        manager.add((IContributionItem)this.createViewpointMenu());
        manager.add((IContributionItem)this.createElementsMenu());
        manager.add((IContributionItem)this.createRelationshipsMenu());
        manager.add((IContributionItem)this.createDirectionMenu());
        manager.add((IContributionItem)new Separator());
        manager.add(this.fActionCopyImageToClipboard);
        manager.add(this.fActionExportImageToFile);
        if (!isEmpty) {
            manager.add(this.fActionSelectInModelTree);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.fActionProperties);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private IMenuManager createViewpointMenu() {
        MenuManager vpMenuManager = new MenuManager(Messages.ZestView_5);
        for (IAction action : this.fViewpointActions) {
            vpMenuManager.add(action);
        }
        return vpMenuManager;
    }

    private IMenuManager createDirectionMenu() {
        MenuManager directionMenuManager = new MenuManager(Messages.ZestView_32);
        IAction[] iActionArray = this.fDirectionActions;
        int n = this.fDirectionActions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            directionMenuManager.add(action);
            ++n2;
        }
        return directionMenuManager;
    }

    private IMenuManager createDepthMenu() {
        MenuManager depthMenuManager = new MenuManager(Messages.ZestView_3);
        IAction[] iActionArray = this.fDepthActions;
        int n = this.fDepthActions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            depthMenuManager.add(action);
            ++n2;
        }
        return depthMenuManager;
    }

    private IMenuManager createElementsMenu() {
        MenuManager elementMenuManager = new MenuManager(Messages.ZestView_9);
        elementMenuManager.add(this.fNoneElementAction);
        MenuManager strategyElementMenuManager = new MenuManager(Messages.ZestView_10);
        elementMenuManager.add((IContributionItem)strategyElementMenuManager);
        for (IAction action : this.fStrategyElementActions) {
            strategyElementMenuManager.add(action);
        }
        MenuManager businessElementMenuManager = new MenuManager(Messages.ZestView_11);
        elementMenuManager.add((IContributionItem)businessElementMenuManager);
        for (IAction action : this.fBusinessElementActions) {
            businessElementMenuManager.add(action);
        }
        MenuManager applicationElementMenuManager = new MenuManager(Messages.ZestView_12);
        elementMenuManager.add((IContributionItem)applicationElementMenuManager);
        for (IAction action : this.fApplicationElementActions) {
            applicationElementMenuManager.add(action);
        }
        MenuManager technologyElementMenuManager = new MenuManager(Messages.ZestView_13);
        elementMenuManager.add((IContributionItem)technologyElementMenuManager);
        for (IAction action : this.fTechnologyElementActions) {
            technologyElementMenuManager.add(action);
        }
        MenuManager physicalElementMenuManager = new MenuManager(Messages.ZestView_14);
        elementMenuManager.add((IContributionItem)physicalElementMenuManager);
        for (IAction action : this.fPhysicalElementActions) {
            physicalElementMenuManager.add(action);
        }
        MenuManager motivationElementMenuManager = new MenuManager(Messages.ZestView_15);
        elementMenuManager.add((IContributionItem)motivationElementMenuManager);
        for (IAction action : this.fMotivationElementActions) {
            motivationElementMenuManager.add(action);
        }
        MenuManager implementationMigrationElementMenuManager = new MenuManager(Messages.ZestView_16);
        elementMenuManager.add((IContributionItem)implementationMigrationElementMenuManager);
        for (IAction action : this.fImplementationMigrationElementActions) {
            implementationMigrationElementMenuManager.add(action);
        }
        MenuManager otherElementMenuManager = new MenuManager(Messages.ZestView_17);
        elementMenuManager.add((IContributionItem)otherElementMenuManager);
        for (IAction action : this.fOtherElementActions) {
            otherElementMenuManager.add(action);
        }
        return elementMenuManager;
    }

    private IMenuManager createRelationshipsMenu() {
        MenuManager relationshipMenuManager = new MenuManager(Messages.ZestView_6);
        for (IAction action : this.fRelationshipActions) {
            relationshipMenuManager.add(action);
        }
        return relationshipMenuManager;
    }

    protected IArchimateModel getActiveArchimateModel() {
        IArchimateConcept concept = this.fDrillDownManager.getCurrentConcept();
        return concept != null ? concept.getArchimateModel() : null;
    }

    protected ZestViewerContentProvider getContentProvider() {
        return (ZestViewerContentProvider)this.fGraphViewer.getContentProvider();
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        if (propertyName == "IEditorModelManager.model.removed") {
            Object input = this.getViewer().getInput();
            if (input instanceof IArchimateModelObject && ((IArchimateModelObject)input).getArchimateModel() == newValue) {
                this.fDrillDownManager.reset();
            }
        } else if (propertyName == "IEditorModelManager.model.dirty") {
            this.updateActions();
        } else {
            super.propertyChange(evt);
        }
    }

    protected void eCoreChanged(Notification msg) {
        this.doRefresh(msg);
    }

    protected void doRefreshFromNotifications(List<Notification> notifications) {
        for (Notification msg : notifications) {
            if (this.doRefresh(msg)) break;
        }
    }

    private boolean doRefresh(Notification msg) {
        if (msg.getFeature() == IArchimatePackage.Literals.NAMEABLE__NAME) {
            this.getViewer().update(msg.getNotifier(), null);
            if (msg.getNotifier() == this.fDrillDownManager.getCurrentConcept()) {
                this.updateLabel();
            }
        } else if (this.isRefreshEvent(msg)) {
            this.refresh();
            return true;
        }
        return false;
    }

    private boolean isRefreshEvent(Notification msg) {
        return msg.getNewValue() instanceof IArchimateConcept || msg.getOldValue() instanceof IArchimateConcept;
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.zestViewHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.ZestView_2;
    }
}

