/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.impl;

import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAdapter;
import com.archimatetool.model.IApplicationElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IBusinessElement;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.IFeatures;
import com.archimatetool.model.IFeaturesEList;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IGrouping;
import com.archimatetool.model.IIdentifier;
import com.archimatetool.model.IImplementationMigrationElement;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.ILocation;
import com.archimatetool.model.IMetadata;
import com.archimatetool.model.IMotivationElement;
import com.archimatetool.model.INameable;
import com.archimatetool.model.IPhysicalElement;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import com.archimatetool.model.IStrategyElement;
import com.archimatetool.model.ITechnologyElement;
import com.archimatetool.model.impl.FeaturesEList;
import com.archimatetool.model.util.IModelContentListener;
import com.archimatetool.model.util.UUIDFactory;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class ArchimateModel
extends EObjectImpl
implements IArchimateModel {
    protected EList<IFolder> folders;
    protected static final String NAME_EDEFAULT = "";
    protected String name = "";
    protected static final String ID_EDEFAULT = null;
    protected String id = ID_EDEFAULT;
    protected EList<IFeature> features;
    protected EList<IProperty> properties;
    protected static final String PURPOSE_EDEFAULT = "";
    protected String purpose = "";
    protected static final File FILE_EDEFAULT = null;
    protected File file = FILE_EDEFAULT;
    protected static final String VERSION_EDEFAULT = "";
    protected String version = "";
    protected IMetadata metadata;
    protected EList<IProfile> profiles;
    private Map<Object, Object> fAdapterMap = new HashMap<Object, Object>();
    private CopyOnWriteArrayList<IModelContentListener> fContentListeners = new CopyOnWriteArrayList();
    private EContentAdapter eContentAdapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            if (notification.getEventType() == 8) {
                return;
            }
            if (ArchimateModel.this.fContentListeners != null) {
                for (IModelContentListener listener : ArchimateModel.this.fContentListeners) {
                    listener.notifyChanged(notification);
                }
            }
        }
    };

    protected ArchimateModel() {
        this.id = UUIDFactory.createID(this);
    }

    @Override
    public boolean addModelContentListener(IModelContentListener listener) {
        if (listener == null || this.fContentListeners == null) {
            return false;
        }
        if (!this.eAdapters().contains((Object)this.eContentAdapter)) {
            this.eAdapters().add((Object)this.eContentAdapter);
        }
        return this.fContentListeners.addIfAbsent(listener);
    }

    @Override
    public boolean removeModelContentListener(IModelContentListener listener) {
        if (listener == null || this.fContentListeners == null) {
            return false;
        }
        return this.fContentListeners.remove(listener);
    }

    @Override
    public void setDefaults() {
        this.addDefaultFolders();
    }

    protected void addDefaultFolders() {
        int index = 0;
        this.createDefaultFolder(FolderType.STRATEGY, index++);
        this.createDefaultFolder(FolderType.BUSINESS, index++);
        this.createDefaultFolder(FolderType.APPLICATION, index++);
        this.createDefaultFolder(FolderType.TECHNOLOGY, index++);
        this.createDefaultFolder(FolderType.MOTIVATION, index++);
        this.createDefaultFolder(FolderType.IMPLEMENTATION_MIGRATION, index++);
        this.createDefaultFolder(FolderType.OTHER, index++);
        this.createDefaultFolder(FolderType.RELATIONS, index++);
        this.createDefaultFolder(FolderType.DIAGRAMS, index++);
    }

    private void createDefaultFolder(FolderType folderType, int index) {
        if (this.getFolder(folderType) == null) {
            IFolder folder = IArchimateFactory.eINSTANCE.createFolder();
            folder.setType(folderType);
            folder.setName(folderType.getLabel());
            this.getFolders().add(index, (Object)folder);
        }
    }

    @Override
    public IFolder getDefaultFolderForObject(EObject object) {
        this.addDefaultFolders();
        if (object instanceof IStrategyElement) {
            return this.getFolder(FolderType.STRATEGY);
        }
        if (object instanceof IBusinessElement) {
            return this.getFolder(FolderType.BUSINESS);
        }
        if (object instanceof IApplicationElement) {
            return this.getFolder(FolderType.APPLICATION);
        }
        if (object instanceof ITechnologyElement || object instanceof IPhysicalElement) {
            return this.getFolder(FolderType.TECHNOLOGY);
        }
        if (object instanceof IMotivationElement) {
            return this.getFolder(FolderType.MOTIVATION);
        }
        if (object instanceof IImplementationMigrationElement) {
            return this.getFolder(FolderType.IMPLEMENTATION_MIGRATION);
        }
        if (object instanceof IJunction || object instanceof ILocation || object instanceof IGrouping) {
            return this.getFolder(FolderType.OTHER);
        }
        if (object instanceof IArchimateRelationship) {
            return this.getFolder(FolderType.RELATIONS);
        }
        if (object instanceof IDiagramModel) {
            return this.getFolder(FolderType.DIAGRAMS);
        }
        return null;
    }

    @Override
    public IFolder getFolder(FolderType type) {
        for (IFolder folder : this.getFolders()) {
            if (!folder.getType().equals((Object)type)) continue;
            return folder;
        }
        return null;
    }

    @Override
    public Object getAdapter(Object adapter) {
        if (!this.fAdapterMap.containsKey(adapter) && this.eContainer() instanceof IAdapter) {
            return ((IAdapter)this.eContainer()).getAdapter(adapter);
        }
        return this.fAdapterMap.get(adapter);
    }

    @Override
    public void setAdapter(Object adapter, Object object) {
        this.fAdapterMap.put(adapter, object);
    }

    @Override
    public IDiagramModel getDefaultDiagramModel() {
        EList<IDiagramModel> list = this.getDiagramModels();
        return list.size() > 0 ? (IDiagramModel)list.get(0) : null;
    }

    @Override
    public EList<IDiagramModel> getDiagramModels() {
        BasicEList list = new BasicEList();
        IFolder folder = this.getFolder(FolderType.DIAGRAMS);
        if (folder != null) {
            TreeIterator iter = folder.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModel)) continue;
                list.add((Object)((IDiagramModel)eObject));
            }
        }
        return list;
    }

    protected EClass eStaticClass() {
        return IArchimatePackage.Literals.ARCHIMATE_MODEL;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String newId) {
        String oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldId, (Object)this.id));
        }
    }

    @Override
    public IFeaturesEList getFeatures() {
        if (this.features == null) {
            this.features = new FeaturesEList(IFeature.class, (InternalEObject)this, 3);
        }
        return (IFeaturesEList)this.features;
    }

    @Override
    public IArchimateModel getArchimateModel() {
        return this;
    }

    @Override
    public EList<IProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new EObjectContainmentEList(IProperty.class, (InternalEObject)this, 4);
        }
        return this.properties;
    }

    @Override
    public IMetadata getMetadata() {
        return this.metadata;
    }

    public NotificationChain basicSetMetadata(IMetadata newMetadata, NotificationChain msgs) {
        IMetadata oldMetadata = this.metadata;
        this.metadata = newMetadata;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldMetadata, (Object)newMetadata);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setMetadata(IMetadata newMetadata) {
        if (newMetadata != this.metadata) {
            NotificationChain msgs = null;
            if (this.metadata != null) {
                msgs = ((InternalEObject)this.metadata).eInverseRemove((InternalEObject)this, -9, null, msgs);
            }
            if (newMetadata != null) {
                msgs = ((InternalEObject)newMetadata).eInverseAdd((InternalEObject)this, -9, null, msgs);
            }
            if ((msgs = this.basicSetMetadata(newMetadata, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)newMetadata, (Object)newMetadata));
        }
    }

    @Override
    public EList<IProfile> getProfiles() {
        if (this.profiles == null) {
            this.profiles = new EObjectContainmentEList(IProfile.class, (InternalEObject)this, 9);
        }
        return this.profiles;
    }

    @Override
    public String getPurpose() {
        return this.purpose;
    }

    @Override
    public void setPurpose(String newPurpose) {
        String oldPurpose = this.purpose;
        this.purpose = newPurpose;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldPurpose, (Object)this.purpose));
        }
    }

    @Override
    public EList<IFolder> getFolders() {
        if (this.folders == null) {
            this.folders = new EObjectContainmentEList(IFolder.class, (InternalEObject)this, 0);
        }
        return this.folders;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void setFile(File newFile) {
        File oldFile = this.file;
        this.file = newFile;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldFile, (Object)this.file));
        }
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String newVersion) {
        String oldVersion = this.version;
        this.version = newVersion;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldVersion, (Object)this.version));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getFolders()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getFeatures()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return this.basicSetMetadata(null, msgs);
            }
            case 9: {
                return ((InternalEList)this.getProfiles()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFolders();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getId();
            }
            case 3: {
                return this.getFeatures();
            }
            case 4: {
                return this.getProperties();
            }
            case 5: {
                return this.getPurpose();
            }
            case 6: {
                return this.getFile();
            }
            case 7: {
                return this.getVersion();
            }
            case 8: {
                return this.getMetadata();
            }
            case 9: {
                return this.getProfiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getFolders().clear();
                this.getFolders().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setId((String)newValue);
                return;
            }
            case 3: {
                this.getFeatures().clear();
                this.getFeatures().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.getProperties().clear();
                this.getProperties().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setPurpose((String)newValue);
                return;
            }
            case 6: {
                this.setFile((File)newValue);
                return;
            }
            case 7: {
                this.setVersion((String)newValue);
                return;
            }
            case 8: {
                this.setMetadata((IMetadata)newValue);
                return;
            }
            case 9: {
                this.getProfiles().clear();
                this.getProfiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getFolders().clear();
                return;
            }
            case 1: {
                this.setName("");
                return;
            }
            case 2: {
                this.setId(ID_EDEFAULT);
                return;
            }
            case 3: {
                this.getFeatures().clear();
                return;
            }
            case 4: {
                this.getProperties().clear();
                return;
            }
            case 5: {
                this.setPurpose("");
                return;
            }
            case 6: {
                this.setFile(FILE_EDEFAULT);
                return;
            }
            case 7: {
                this.setVersion("");
                return;
            }
            case 8: {
                this.setMetadata(null);
                return;
            }
            case 9: {
                this.getProfiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.folders != null && !this.folders.isEmpty();
            }
            case 1: {
                return "" == null ? this.name != null : !"".equals(this.name);
            }
            case 2: {
                return ID_EDEFAULT == null ? this.id != null : !ID_EDEFAULT.equals(this.id);
            }
            case 3: {
                return this.features != null && !this.features.isEmpty();
            }
            case 4: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 5: {
                return "" == null ? this.purpose != null : !"".equals(this.purpose);
            }
            case 6: {
                return FILE_EDEFAULT == null ? this.file != null : !FILE_EDEFAULT.equals(this.file);
            }
            case 7: {
                return "" == null ? this.version != null : !"".equals(this.version);
            }
            case 8: {
                return this.metadata != null;
            }
            case 9: {
                return this.profiles != null && !this.profiles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IAdapter.class) {
            return -1;
        }
        if (baseClass == INameable.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == IIdentifier.class) {
            switch (derivedFeatureID) {
                case 2: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == IFeatures.class) {
            switch (derivedFeatureID) {
                case 3: {
                    return 0;
                }
            }
            return -1;
        }
        if (baseClass == IArchimateModelObject.class) {
            return -1;
        }
        if (baseClass == IProperties.class) {
            switch (derivedFeatureID) {
                case 4: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IAdapter.class) {
            return -1;
        }
        if (baseClass == INameable.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == IIdentifier.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 2;
                }
            }
            return -1;
        }
        if (baseClass == IFeatures.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 3;
                }
            }
            return -1;
        }
        if (baseClass == IArchimateModelObject.class) {
            return -1;
        }
        if (baseClass == IProperties.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", id: ");
        result.append(this.id);
        result.append(", purpose: ");
        result.append(this.purpose);
        result.append(", file: ");
        result.append(this.file);
        result.append(", version: ");
        result.append(this.version);
        result.append(')');
        return result.toString();
    }

    @Override
    public void dispose() {
        this.id = null;
        this.name = null;
        this.purpose = null;
        this.file = null;
        if (this.eAdapters != null) {
            this.eAdapters = null;
        }
        this.fAdapterMap.clear();
        this.fAdapterMap = null;
        this.fContentListeners.clear();
        this.fContentListeners = null;
        for (IDiagramModel dm : this.getDiagramModels()) {
            dm.getProperties().clear();
            dm.getChildren().clear();
        }
        if (this.folders != null) {
            this.folders.clear();
            this.folders = null;
        }
        if (this.properties != null) {
            this.properties.clear();
            this.properties = null;
        }
        if (this.metadata != null) {
            this.metadata.getEntries().clear();
            this.metadata = null;
        }
    }
}

