/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.impl;

import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IFeature;
import com.archimatetool.model.IFeaturesEList;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;

public class FeaturesEList
extends EObjectContainmentEList<IFeature>
implements IFeaturesEList {
    public FeaturesEList(Class<?> dataClass, InternalEObject owner, int featureID) {
        super(dataClass, owner, featureID);
    }

    @Override
    public IFeature putString(String name, String value) {
        return this.putString(name, value, null);
    }

    @Override
    public IFeature putString(String name, String value, String defaultValue) {
        this.checkNull(name);
        if (value == null) {
            value = "";
        }
        if (defaultValue == null) {
            defaultValue = "";
        }
        if (Objects.equals(value, defaultValue)) {
            this.remove(name);
            return null;
        }
        IFeature feature = this.getFeature(name);
        if (feature == null) {
            feature = IArchimateFactory.eINSTANCE.createFeature();
            feature.setName(name);
            feature.setValue(value);
            this.add(feature);
        } else if (!Objects.equals(value, feature.getValue())) {
            feature.setValue(value);
        }
        return feature;
    }

    @Override
    public IFeature putInt(String name, int value) {
        return this.putString(name, Integer.toString(value), null);
    }

    @Override
    public IFeature putInt(String name, int value, int defaultValue) {
        return this.putString(name, Integer.toString(value), Integer.toString(defaultValue));
    }

    @Override
    public IFeature putBoolean(String name, boolean value) {
        return this.putString(name, Boolean.toString(value), null);
    }

    @Override
    public IFeature putBoolean(String name, boolean value, boolean defaultValue) {
        return this.putString(name, Boolean.toString(value), Boolean.toString(defaultValue));
    }

    @Override
    public String getString(String name, String defaultValue) {
        IFeature feature = this.getFeature(name);
        return feature == null ? defaultValue : feature.getValue();
    }

    @Override
    public int getInt(String name, int defaultValue) {
        String val = this.getString(name, String.valueOf(defaultValue));
        try {
            return Integer.valueOf(val);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String val = this.getString(name, Boolean.toString(defaultValue));
        return Boolean.valueOf(val);
    }

    @Override
    public boolean remove(String name) {
        this.checkNull(name);
        IFeature feature = this.getFeature(name);
        if (feature != null) {
            return this.remove(feature);
        }
        return false;
    }

    @Override
    public boolean has(String name) {
        return this.getFeature(name) != null;
    }

    @Override
    public IFeature getFeature(String name) {
        this.checkNull(name);
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            IFeature f = (IFeature)iterator.next();
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    private void checkNull(String s) {
        if (s == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
    }

    protected boolean useEquals() {
        return true;
    }
}

