/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.util;

import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IIdentifier;
import com.archimatetool.model.IJunction;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import com.archimatetool.model.util.RelationshipsMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ArchimateModelUtils {
    public static final boolean isValidRelationshipStart(IArchimateConcept sourceConcept, EClass relationshipType) {
        if (sourceConcept instanceof IJunction) {
            for (IArchimateRelationship rel : ArchimateModelUtils.getAllRelationshipsForConcept(sourceConcept)) {
                if (rel.eClass().equals(relationshipType)) continue;
                return false;
            }
        }
        return RelationshipsMatrix.INSTANCE.isValidRelationshipStart(sourceConcept.eClass(), relationshipType);
    }

    public static final boolean isValidRelationship(IArchimateConcept sourceConcept, IArchimateConcept targetConcept, EClass relationshipType) {
        if (ArchimateModelUtils.hasDirectRelationship(sourceConcept, targetConcept)) {
            return false;
        }
        if (sourceConcept instanceof IJunction) {
            for (IArchimateRelationship rel : sourceConcept.getTargetRelationships()) {
                if (ArchimateModelUtils.isValidRelationship(rel.getSource().eClass(), targetConcept.eClass(), relationshipType)) continue;
                return false;
            }
            for (IArchimateRelationship rel : ArchimateModelUtils.getAllRelationshipsForConcept(sourceConcept)) {
                if (rel.eClass().equals(relationshipType)) continue;
                return false;
            }
        }
        if (targetConcept instanceof IJunction) {
            for (IArchimateRelationship rel : targetConcept.getSourceRelationships()) {
                if (ArchimateModelUtils.isValidRelationship(sourceConcept.eClass(), rel.getTarget().eClass(), relationshipType)) continue;
                return false;
            }
            for (IArchimateRelationship rel : ArchimateModelUtils.getAllRelationshipsForConcept(targetConcept)) {
                if (rel.eClass().equals(relationshipType)) continue;
                return false;
            }
        }
        return ArchimateModelUtils.isValidRelationship(sourceConcept.eClass(), targetConcept.eClass(), relationshipType);
    }

    public static final boolean isValidRelationship(EClass sourceType, EClass targetType, EClass relationshipType) {
        return RelationshipsMatrix.INSTANCE.isValidRelationship(sourceType, targetType, relationshipType);
    }

    public static EClass[] getValidRelationships(IArchimateConcept sourceConcept, IArchimateConcept targetConcept) {
        ArrayList<EClass> list = new ArrayList<EClass>();
        EClass[] eClassArray = ArchimateModelUtils.getRelationsClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (ArchimateModelUtils.isValidRelationship(sourceConcept, targetConcept, eClass)) {
                list.add(eClass);
            }
            ++n2;
        }
        return list.toArray(new EClass[list.size()]);
    }

    public static EClass[] getValidRelationships(EClass sourceType, EClass targetType) {
        ArrayList<EClass> list = new ArrayList<EClass>();
        EClass[] eClassArray = ArchimateModelUtils.getRelationsClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (ArchimateModelUtils.isValidRelationship(sourceType, targetType, eClass)) {
                list.add(eClass);
            }
            ++n2;
        }
        return list.toArray(new EClass[list.size()]);
    }

    public static boolean hasDirectRelationship(IArchimateConcept concept1, IArchimateConcept concept2) {
        if (concept1 instanceof IArchimateRelationship && ArchimateModelUtils.getAllRelationshipsForConcept(concept2).contains(concept1)) {
            return true;
        }
        return concept2 instanceof IArchimateRelationship && ArchimateModelUtils.getAllRelationshipsForConcept(concept1).contains(concept2);
    }

    public static List<IArchimateRelationship> getAllRelationshipsForConcept(IArchimateConcept concept) {
        HashSet<IArchimateRelationship> set = new HashSet<IArchimateRelationship>();
        set.addAll((Collection<IArchimateRelationship>)concept.getSourceRelationships());
        set.addAll((Collection<IArchimateRelationship>)concept.getTargetRelationships());
        return new ArrayList<IArchimateRelationship>(set);
    }

    public static EObject getObjectByID(IArchimateModel model, String id) {
        if (id == null || model == null) {
            return null;
        }
        if (id.equals(model.getId())) {
            return model;
        }
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof IIdentifier) || !id.equals(((IIdentifier)element).getId())) continue;
            return element;
        }
        return null;
    }

    public static Map<String, EObject> getObjectIDMap(IArchimateModel model) {
        HashMap<String, EObject> map = new HashMap<String, EObject>();
        if (model == null) {
            return map;
        }
        if (model.getId() != null) {
            map.put(model.getId(), model);
        }
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            IIdentifier object;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IIdentifier) || (object = (IIdentifier)eObject).getId() == null) continue;
            map.put(object.getId(), object);
        }
        return map;
    }

    public static EClass[] getStrategyClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getResource(), IArchimatePackage.eINSTANCE.getCapability(), IArchimatePackage.eINSTANCE.getValueStream(), IArchimatePackage.eINSTANCE.getCourseOfAction()};
    }

    public static EClass[] getBusinessClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getBusinessActor(), IArchimatePackage.eINSTANCE.getBusinessRole(), IArchimatePackage.eINSTANCE.getBusinessCollaboration(), IArchimatePackage.eINSTANCE.getBusinessInterface(), IArchimatePackage.eINSTANCE.getBusinessProcess(), IArchimatePackage.eINSTANCE.getBusinessFunction(), IArchimatePackage.eINSTANCE.getBusinessInteraction(), IArchimatePackage.eINSTANCE.getBusinessEvent(), IArchimatePackage.eINSTANCE.getBusinessService(), IArchimatePackage.eINSTANCE.getBusinessObject(), IArchimatePackage.eINSTANCE.getContract(), IArchimatePackage.eINSTANCE.getRepresentation(), IArchimatePackage.eINSTANCE.getProduct()};
    }

    public static EClass[] getApplicationClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getApplicationComponent(), IArchimatePackage.eINSTANCE.getApplicationCollaboration(), IArchimatePackage.eINSTANCE.getApplicationInterface(), IArchimatePackage.eINSTANCE.getApplicationFunction(), IArchimatePackage.eINSTANCE.getApplicationInteraction(), IArchimatePackage.eINSTANCE.getApplicationProcess(), IArchimatePackage.eINSTANCE.getApplicationEvent(), IArchimatePackage.eINSTANCE.getApplicationService(), IArchimatePackage.eINSTANCE.getDataObject()};
    }

    public static EClass[] getTechnologyClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getNode(), IArchimatePackage.eINSTANCE.getDevice(), IArchimatePackage.eINSTANCE.getSystemSoftware(), IArchimatePackage.eINSTANCE.getTechnologyCollaboration(), IArchimatePackage.eINSTANCE.getTechnologyInterface(), IArchimatePackage.eINSTANCE.getPath(), IArchimatePackage.eINSTANCE.getCommunicationNetwork(), IArchimatePackage.eINSTANCE.getTechnologyFunction(), IArchimatePackage.eINSTANCE.getTechnologyProcess(), IArchimatePackage.eINSTANCE.getTechnologyInteraction(), IArchimatePackage.eINSTANCE.getTechnologyEvent(), IArchimatePackage.eINSTANCE.getTechnologyService(), IArchimatePackage.eINSTANCE.getArtifact()};
    }

    public static EClass[] getPhysicalClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getEquipment(), IArchimatePackage.eINSTANCE.getFacility(), IArchimatePackage.eINSTANCE.getDistributionNetwork(), IArchimatePackage.eINSTANCE.getMaterial()};
    }

    public static EClass[] getMotivationClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getStakeholder(), IArchimatePackage.eINSTANCE.getDriver(), IArchimatePackage.eINSTANCE.getAssessment(), IArchimatePackage.eINSTANCE.getGoal(), IArchimatePackage.eINSTANCE.getOutcome(), IArchimatePackage.eINSTANCE.getPrinciple(), IArchimatePackage.eINSTANCE.getRequirement(), IArchimatePackage.eINSTANCE.getConstraint(), IArchimatePackage.eINSTANCE.getMeaning(), IArchimatePackage.eINSTANCE.getValue()};
    }

    public static EClass[] getImplementationMigrationClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getWorkPackage(), IArchimatePackage.eINSTANCE.getDeliverable(), IArchimatePackage.eINSTANCE.getImplementationEvent(), IArchimatePackage.eINSTANCE.getPlateau(), IArchimatePackage.eINSTANCE.getGap()};
    }

    public static EClass[] getOtherClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getLocation(), IArchimatePackage.eINSTANCE.getGrouping()};
    }

    public static EClass[] getConnectorClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getJunction()};
    }

    public static EClass[] getRelationsClasses() {
        return new EClass[]{IArchimatePackage.eINSTANCE.getCompositionRelationship(), IArchimatePackage.eINSTANCE.getAggregationRelationship(), IArchimatePackage.eINSTANCE.getAssignmentRelationship(), IArchimatePackage.eINSTANCE.getRealizationRelationship(), IArchimatePackage.eINSTANCE.getServingRelationship(), IArchimatePackage.eINSTANCE.getAccessRelationship(), IArchimatePackage.eINSTANCE.getInfluenceRelationship(), IArchimatePackage.eINSTANCE.getTriggeringRelationship(), IArchimatePackage.eINSTANCE.getFlowRelationship(), IArchimatePackage.eINSTANCE.getSpecializationRelationship(), IArchimatePackage.eINSTANCE.getAssociationRelationship()};
    }

    public static EClass[] getAllArchimateClasses() {
        ArrayList<EClass> list = new ArrayList<EClass>();
        list.addAll(Arrays.asList(ArchimateModelUtils.getStrategyClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getBusinessClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getApplicationClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getTechnologyClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getPhysicalClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getMotivationClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getImplementationMigrationClasses()));
        list.addAll(Arrays.asList(ArchimateModelUtils.getOtherClasses()));
        return list.toArray(new EClass[list.size()]);
    }

    public static boolean hasProfileByNameAndType(IArchimateModel model, String profileName, String conceptType) {
        return ArchimateModelUtils.getProfileByNameAndType(model, profileName, conceptType) != null;
    }

    public static boolean hasProfileByNameAndType(Collection<IProfile> profiles, String profileName, String conceptType) {
        return ArchimateModelUtils.getProfileByNameAndType(profiles, profileName, conceptType) != null;
    }

    public static IProfile getProfileByNameAndType(IArchimateModel model, String profileName, String conceptType) {
        return ArchimateModelUtils.getProfileByNameAndType(model.getProfiles(), profileName, conceptType);
    }

    public static IProfile getProfileByNameAndType(Collection<IProfile> profiles, String profileName, String conceptType) {
        for (IProfile p : profiles) {
            if (p.getName() == null || !p.getName().equalsIgnoreCase(profileName) || p.getConceptType() == null || !p.getConceptType().equals(conceptType)) continue;
            return p;
        }
        return null;
    }

    public static List<IProfile> findProfilesForConceptType(IArchimateModel model, EClass conceptType) {
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        for (IProfile profile : model.getProfiles()) {
            if (conceptType == null || !conceptType.getName().equals(profile.getConceptType())) continue;
            profiles.add(profile);
        }
        return profiles;
    }

    public static List<IProfiles> findProfileUsage(IProfile profile) {
        ArrayList<IProfiles> profiles = new ArrayList<IProfiles>();
        if (profile != null && profile.getArchimateModel() != null) {
            for (EStructuralFeature.Setting setting : EcoreUtil.UsageCrossReferencer.find((EObject)profile, (EObject)profile.getArchimateModel())) {
                profiles.add((IProfiles)setting.getEObject());
            }
        }
        return profiles;
    }

    public static Map<IProfile, List<IProfiles>> findProfilesUsage(IArchimateModel model) {
        HashMap<IProfile, List<IProfiles>> map = new HashMap<IProfile, List<IProfiles>>();
        TreeIterator iter = model.eAllContents();
        while (iter.hasNext()) {
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof IProfiles)) continue;
            for (IProfile profile : ((IProfiles)eObject).getProfiles()) {
                ArrayList<IProfiles> list = (ArrayList<IProfiles>)map.get(profile);
                if (list == null) {
                    list = new ArrayList<IProfiles>();
                    map.put(profile, list);
                }
                list.add((IProfiles)eObject);
            }
        }
        return map;
    }

    public static boolean isMatchingProfile(IProfile p1, IProfile p2) {
        return p1.getName() != null && p1.getName().equalsIgnoreCase(p2.getName()) && p1.getConceptType() != null && p1.getConceptType().equals(p2.getConceptType());
    }
}

