/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.model.util;

import com.archimatetool.model.IArchimatePackage;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class RelationshipsMatrix {
    public static RelationshipsMatrix INSTANCE = new RelationshipsMatrix();
    static final String BUNDLE_ID = "com.archimatetool.model";
    static final String RELATIONSHIPS_KEYS_FILE = "model/relationships-keys.xml";
    static final String RELATIONSHIPS_FILE = "model/relationships.xml";
    static final String XML_ELEMENT_ROOT = "relationships";
    static final String XML_ELEMENT_KEYS = "keys";
    static final String XML_ELEMENT_KEY = "key";
    static final String XML_ELEMENT_SOURCE = "source";
    static final String XML_ELEMENT_TARGET = "target";
    static final String XML_ATTRIBUTE_CHAR = "char";
    static final String XML_ATTRIBUTE_RELATIONSHIP = "relationship";
    static final String XML_ATTRIBUTE_RELATIONS = "relations";
    static final String XML_ATTRIBUTE_CONCEPT = "concept";
    private Map<EClass, List<TargetMatrix>> matrixMap = new HashMap<EClass, List<TargetMatrix>>();
    private Map<Character, EClass> relationsKeyMap = new LinkedHashMap<Character, EClass>();
    private Map<EClass, Character> relationsValueMap = new LinkedHashMap<EClass, Character>();

    private RelationshipsMatrix() {
        this.loadKeyLetters();
        this.loadRelationships();
    }

    public Map<EClass, List<TargetMatrix>> getRelationshipsMatrix() {
        return Collections.unmodifiableMap(this.matrixMap);
    }

    public Map<EClass, Character> getRelationshipsValueMap() {
        return Collections.unmodifiableMap(this.relationsValueMap);
    }

    boolean isValidRelationshipStart(EClass sourceType, EClass relationshipType) {
        List<TargetMatrix> listMatrix;
        if (IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(sourceType)) {
            sourceType = IArchimatePackage.eINSTANCE.getArchimateRelationship();
        }
        if ((listMatrix = this.matrixMap.get(sourceType)) != null) {
            for (TargetMatrix targetMatrix : listMatrix) {
                if (!targetMatrix.getRelationships().contains(relationshipType)) continue;
                return true;
            }
        }
        return false;
    }

    boolean isValidRelationship(EClass sourceType, EClass targetType, EClass relationshipType) {
        List<TargetMatrix> listMatrix;
        if (relationshipType == null) {
            return false;
        }
        if (!IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(relationshipType)) {
            return false;
        }
        if (IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(sourceType)) {
            sourceType = IArchimatePackage.eINSTANCE.getArchimateRelationship();
        }
        if (IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(targetType)) {
            targetType = IArchimatePackage.eINSTANCE.getArchimateRelationship();
        }
        if ((listMatrix = this.matrixMap.get(sourceType)) != null) {
            for (TargetMatrix targetMatrix : listMatrix) {
                if (targetMatrix.getTargetClass() != targetType || !targetMatrix.getRelationships().contains(relationshipType)) continue;
                return true;
            }
        }
        return false;
    }

    private void loadKeyLetters() {
        URL url = Platform.getBundle((String)BUNDLE_ID).getEntry(RELATIONSHIPS_KEYS_FILE);
        Document doc = null;
        try {
            doc = new SAXBuilder().build(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        for (Object object : doc.getRootElement().getChildren(XML_ELEMENT_KEY)) {
            Element elementKey = (Element)object;
            String keyLetter = elementKey.getAttributeValue(XML_ATTRIBUTE_CHAR);
            if (keyLetter == null || keyLetter.length() != 1) {
                System.err.println(String.valueOf(this.getClass()) + ": Key letter incorrect: " + keyLetter);
                continue;
            }
            String relationName = elementKey.getAttributeValue(XML_ATTRIBUTE_RELATIONSHIP);
            if (relationName == null) {
                System.err.println(String.valueOf(this.getClass()) + ": Relationship name incorrect: " + relationName);
                continue;
            }
            EClass relationship = (EClass)IArchimatePackage.eINSTANCE.getEClassifier(relationName);
            if (relationship == null) {
                System.err.println(String.valueOf(this.getClass()) + ": Couldn't find relationship " + relationName);
                continue;
            }
            this.relationsKeyMap.put(Character.valueOf(keyLetter.charAt(0)), relationship);
            this.relationsValueMap.put(relationship, Character.valueOf(keyLetter.charAt(0)));
        }
    }

    private void loadRelationships() {
        URL url = Platform.getBundle((String)BUNDLE_ID).getEntry(RELATIONSHIPS_FILE);
        Document doc = null;
        try {
            doc = new SAXBuilder().build(url);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        for (Object object : doc.getRootElement().getChildren(XML_ELEMENT_SOURCE)) {
            Element elementSource = (Element)object;
            String sourceName = elementSource.getAttributeValue(XML_ATTRIBUTE_CONCEPT);
            if (sourceName == null) continue;
            EClass source = null;
            source = sourceName.equals("Relationship") ? IArchimatePackage.eINSTANCE.getArchimateRelationship() : (EClass)IArchimatePackage.eINSTANCE.getEClassifier(sourceName);
            if (source == null) {
                System.err.println(String.valueOf(this.getClass()) + ": Couldn't find source " + sourceName);
                continue;
            }
            ArrayList<TargetMatrix> matrixList = new ArrayList<TargetMatrix>();
            this.matrixMap.put(source, matrixList);
            for (Object objectChild : elementSource.getChildren(XML_ELEMENT_TARGET)) {
                Element elementTarget = (Element)objectChild;
                String targetName = elementTarget.getAttributeValue(XML_ATTRIBUTE_CONCEPT);
                if (targetName == null) continue;
                EClass target = null;
                target = targetName.equals("Relationship") ? IArchimatePackage.eINSTANCE.getArchimateRelationship() : (EClass)IArchimatePackage.eINSTANCE.getEClassifier(targetName);
                if (target == null) {
                    System.err.println(String.valueOf(this.getClass()) + ": Couldn't find target " + targetName);
                    continue;
                }
                TargetMatrix matrix = new TargetMatrix();
                matrixList.add(matrix);
                matrix.targetClass = target;
                String relations = elementTarget.getAttributeValue(XML_ATTRIBUTE_RELATIONS);
                if (relations == null) continue;
                int i = 0;
                while (i < relations.length()) {
                    char key = relations.charAt(i);
                    EClass relationship = this.relationsKeyMap.get(Character.valueOf(key));
                    if (relationship != null) {
                        matrix.getRelationships().add(relationship);
                    } else {
                        System.err.println(String.valueOf(this.getClass()) + ": Found unmapped key char: " + key);
                    }
                    ++i;
                }
            }
        }
    }

    public static class TargetMatrix {
        EClass targetClass;
        Set<EClass> relationships = new LinkedHashSet<EClass>();

        public EClass getTargetClass() {
            return this.targetClass;
        }

        public Set<EClass> getRelationships() {
            return this.relationships;
        }
    }
}

