/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import com.archimatetool.editor.ui.components.ExtendedWizardDialog;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.opengroup.archimate.xmlexchange.IXMLExchangeGlobals;
import org.opengroup.archimate.xmlexchange.Messages;
import org.opengroup.archimate.xmlexchange.XMLModelExporter;
import org.opengroup.archimate.xmlexchange.XMLValidator;
import org.opengroup.archimate.xmlexchange.wizard.ExportToXMLWizard;

public class XMLExchangeExportHandler
extends AbstractHandler
implements IXMLExchangeGlobals {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IArchimateModel model;
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        IArchimateModel iArchimateModel = model = part != null ? (IArchimateModel)part.getAdapter(IArchimateModel.class) : null;
        if (model != null) {
            this.export(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event), model);
        }
        return null;
    }

    private void export(final IWorkbenchWindow window, final IArchimateModel model) {
        File file;
        final ExportToXMLWizard wizard = new ExportToXMLWizard(model.getName());
        ExtendedWizardDialog dialog = new ExtendedWizardDialog(window.getShell(), (IWizard)wizard, "ExportToXMLWizard"){

            protected void createButtonsForButtonBar(Composite parent) {
                super.createButtonsForButtonBar(parent);
                Button b = this.getButton(16);
                b.setText(Messages.XMLExchangeExportHandler_0);
            }
        };
        if (dialog.open() == 0 && (file = wizard.getFile()) != null) {
            boolean result;
            try {
                file.getCanonicalPath();
            }
            catch (IOException iOException) {
                MessageDialog.openError((Shell)window.getShell(), (String)Messages.XMLExchangeExportHandler_1, (String)Messages.XMLExchangeExportHandler_2);
            }
            if (file.exists() && !(result = MessageDialog.openQuestion((Shell)window.getShell(), (String)Messages.XMLExchangeExportHandler_3, (String)("'" + String.valueOf(file) + "' already exists. Are you sure you want to overwrite it?")))) {
                return;
            }
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        XMLModelExporter xmlModelExporter = new XMLModelExporter();
                        xmlModelExporter.setMetadata(wizard.getMetadata());
                        xmlModelExporter.setSaveOrganisation(wizard.doSaveOrganisation());
                        xmlModelExporter.setIncludeXSD(wizard.doIncludeXSD());
                        xmlModelExporter.setLanguageCode(wizard.getLanguageCode());
                        xmlModelExporter.exportModel(model, file);
                        if (wizard.doValidateAfterExport()) {
                            XMLValidator validator = new XMLValidator();
                            validator.validateXML(file);
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        MessageDialog.openError((Shell)window.getShell(), (String)Messages.XMLExchangeExportHandler_3, (String)(Messages.XMLExchangeExportHandler_4 + " " + ex.getMessage()));
                    }
                }
            });
        }
    }
}

