/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.model.IArchimateModel;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jdom2.JDOMException;
import org.opengroup.archimate.xmlexchange.IXMLExchangeGlobals;
import org.opengroup.archimate.xmlexchange.Messages;
import org.opengroup.archimate.xmlexchange.XMLModelImporter;
import org.opengroup.archimate.xmlexchange.XMLModelParserException;
import org.opengroup.archimate.xmlexchange.XMLValidator;
import org.xml.sax.SAXException;

public class XMLExchangeImportHandler
extends AbstractHandler
implements IXMLExchangeGlobals {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doImport(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event));
        return null;
    }

    private void doImport(IWorkbenchWindow window) {
        final File file = this.askOpenFile(window);
        if (file == null) {
            return;
        }
        final Exception[] exception = new Exception[1];
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    XMLValidator validator = new XMLValidator();
                    validator.validateXML(file);
                    XMLModelImporter xmlModelImporter = new XMLModelImporter();
                    IArchimateModel model = xmlModelImporter.createArchiMateModel(file);
                    if (model != null) {
                        IEditorModelManager.INSTANCE.openModel(model);
                    }
                }
                catch (IOException | JDOMException | XMLModelParserException | SAXException ex) {
                    exception[0] = ex;
                    ex.printStackTrace();
                }
            }
        });
        if (exception[0] != null) {
            MessageDialog.openError((Shell)window.getShell(), (String)Messages.XMLExchangeImportHandler_0, (String)(Messages.XMLExchangeImportHandler_1 + " " + exception[0].getMessage()));
        }
    }

    private File askOpenFile(IWorkbenchWindow window) {
        FileDialog dialog = new FileDialog(window.getShell(), 4096);
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        String path = dialog.open();
        return path != null ? new File(path) : null;
    }
}

