/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange;

import com.archimatetool.editor.diagram.ArchimateDiagramModelFactory;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.jdom.JDOMUtils;
import com.archimatetool.model.FolderType;
import com.archimatetool.model.IAccessRelationship;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateModelObject;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IAssociationRelationship;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelBendpoint;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelNote;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IFontAttribute;
import com.archimatetool.model.IInfluenceRelationship;
import com.archimatetool.model.IProperties;
import com.archimatetool.model.IProperty;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.opengroup.archimate.xmlexchange.IXMLExchangeGlobals;
import org.opengroup.archimate.xmlexchange.Messages;
import org.opengroup.archimate.xmlexchange.XMLModelParserException;
import org.opengroup.archimate.xmlexchange.XMLTypeMapper;

public class XMLModelImporter
implements IXMLExchangeGlobals {
    private IArchimateModel fModel;
    private Map<String, String> fPropertyDefinitionsList;
    private Map<String, IArchimateConcept> fConceptsLookup;
    private Map<String, IConnectable> fConnectionsNodesLookup;
    private Map<String, IArchimateDiagramModel> fDiagramsLookup;
    private Map<IDiagramModelReference, String> fDiagramRefsLookup;

    public IArchimateModel createArchiMateModel(File instanceFile) throws IOException, JDOMException, XMLModelParserException {
        this.fPropertyDefinitionsList = new HashMap<String, String>();
        this.fConceptsLookup = new HashMap<String, IArchimateConcept>();
        this.fConnectionsNodesLookup = new HashMap<String, IConnectable>();
        this.fDiagramsLookup = new HashMap<String, IArchimateDiagramModel>();
        this.fDiagramRefsLookup = new HashMap<IDiagramModelReference, String>();
        this.fModel = IArchimateFactory.eINSTANCE.createArchimateModel();
        this.fModel.setDefaults();
        Document doc = JDOMUtils.readXMLFile((File)instanceFile);
        Element rootElement = doc.getRootElement();
        this.parsePropertyDefinitions(rootElement.getChild("propertyDefinitions", ARCHIMATE3_NAMESPACE));
        this.parseRootElement(rootElement);
        this.parseArchiMateElements(rootElement.getChild("elements", ARCHIMATE3_NAMESPACE));
        this.parseArchiMateRelations(rootElement.getChild("relationships", ARCHIMATE3_NAMESPACE));
        Element viewsElement = rootElement.getChild("views", ARCHIMATE3_NAMESPACE);
        if (viewsElement != null) {
            this.parseViews(viewsElement.getChild("diagrams", ARCHIMATE3_NAMESPACE));
        }
        for (Element orgsElement : rootElement.getChildren("organizations", ARCHIMATE3_NAMESPACE)) {
            this.parseOrganizations(orgsElement);
        }
        return this.fModel;
    }

    private void parsePropertyDefinitions(Element propertydefsElement) {
        if (propertydefsElement == null) {
            return;
        }
        for (Element propertyDefElement : propertydefsElement.getChildren("propertyDefinition", ARCHIMATE3_NAMESPACE)) {
            String identifier = propertyDefElement.getAttributeValue("identifier");
            String name = this.getChildElementText(propertyDefElement, "name", false);
            if (identifier == null || name == null) continue;
            this.fPropertyDefinitionsList.put(identifier, name);
        }
    }

    private void parseRootElement(Element rootElement) {
        String documentation;
        String name;
        String id = rootElement.getAttributeValue("identifier");
        if (id != null) {
            this.fModel.setId(id);
        }
        if ((name = this.getChildElementText(rootElement, "name", true)) != null) {
            this.fModel.setName(name);
        }
        if ((documentation = this.getChildElementText(rootElement, "documentation", false)) != null) {
            this.fModel.setPurpose(documentation);
        }
        this.addProperties((IProperties)this.fModel, rootElement);
    }

    private void addProperties(IProperties propertiesModel, Element parentElement) {
        Element propertiesElement = parentElement.getChild("properties", ARCHIMATE3_NAMESPACE);
        if (propertiesElement != null) {
            for (Element propertyElement : propertiesElement.getChildren("property", ARCHIMATE3_NAMESPACE)) {
                String propertyName;
                String idref = propertyElement.getAttributeValue("propertyDefinitionRef");
                if (idref == null || (propertyName = this.fPropertyDefinitionsList.get(idref)) == null) continue;
                String propertyValue = this.getChildElementText(propertyElement, "value", true);
                IProperty property = IArchimateFactory.eINSTANCE.createProperty();
                property.setKey(propertyName);
                property.setValue(propertyValue);
                propertiesModel.getProperties().add((Object)property);
            }
        }
    }

    private void parseArchiMateElements(Element elementsElement) throws XMLModelParserException {
        if (elementsElement == null) {
            throw new XMLModelParserException(Messages.XMLModelImporter_0);
        }
        for (Element childElement : elementsElement.getChildren("element", ARCHIMATE3_NAMESPACE)) {
            String documentation;
            String type = childElement.getAttributeValue("type", XSI_NAMESPACE);
            if (type == null) continue;
            IArchimateElement element = (IArchimateElement)XMLTypeMapper.createArchimateConcept(type);
            if (element == null) {
                throw new XMLModelParserException(NLS.bind((String)Messages.XMLModelImporter_1, (Object)type));
            }
            String id = childElement.getAttributeValue("identifier");
            if (id != null) {
                element.setId(id);
            }
            this.fModel.getDefaultFolderForObject((EObject)element).getElements().add((Object)element);
            String name = this.getChildElementText(childElement, "name", true);
            if (name != null) {
                element.setName(name);
            }
            if ((documentation = this.getChildElementText(childElement, "documentation", false)) != null) {
                element.setDocumentation(documentation);
            }
            this.addProperties((IProperties)element, childElement);
            this.fConceptsLookup.put(element.getId(), (IArchimateConcept)element);
        }
    }

    private void parseArchiMateRelations(Element relationsElement) throws IOException {
        if (relationsElement == null) {
            return;
        }
        class RelationInfo {
            IArchimateRelationship relation;
            String sourceID;
            String targetID;

            RelationInfo() {
            }
        }
        ArrayList<RelationInfo> relationInfoList = new ArrayList<RelationInfo>();
        IFolder relationshipFolder = this.fModel.getFolder(FolderType.RELATIONS);
        for (Element childElement : relationsElement.getChildren("relationship", ARCHIMATE3_NAMESPACE)) {
            String targetID;
            String sourceID;
            IArchimateRelationship relation;
            block27: {
                String isDirected;
                block26: {
                    String documentation;
                    String type = childElement.getAttributeValue("type", XSI_NAMESPACE);
                    if (type == null) continue;
                    relation = (IArchimateRelationship)XMLTypeMapper.createArchimateConcept(type);
                    if (relation == null) {
                        throw new IOException(NLS.bind((String)Messages.XMLModelImporter_2, (Object)type));
                    }
                    String id = childElement.getAttributeValue("identifier");
                    if (id != null) {
                        relation.setId(id);
                    }
                    relationshipFolder.getElements().add((Object)relation);
                    String name = this.getChildElementText(childElement, "name", true);
                    if (name != null) {
                        relation.setName(name);
                    }
                    if ((documentation = this.getChildElementText(childElement, "documentation", false)) != null) {
                        relation.setDocumentation(documentation);
                    }
                    this.addProperties((IProperties)relation, childElement);
                    sourceID = childElement.getAttributeValue("source");
                    targetID = childElement.getAttributeValue("target");
                    if (!(relation instanceof IAccessRelationship)) break block26;
                    String accessType = childElement.getAttributeValue("accessType");
                    if (accessType == null) break block27;
                    IAccessRelationship accessRelationship = (IAccessRelationship)relation;
                    switch (accessType) {
                        case "Access": {
                            accessRelationship.setAccessType(2);
                            break;
                        }
                        case "Read": {
                            accessRelationship.setAccessType(1);
                            break;
                        }
                        case "ReadWrite": {
                            accessRelationship.setAccessType(3);
                            break;
                        }
                        default: {
                            accessRelationship.setAccessType(0);
                            break;
                        }
                    }
                    break block27;
                }
                if (relation instanceof IInfluenceRelationship) {
                    String influenceStrength = childElement.getAttributeValue("modifier");
                    if (influenceStrength != null) {
                        ((IInfluenceRelationship)relation).setStrength(influenceStrength);
                    }
                } else if (relation instanceof IAssociationRelationship && "true".equalsIgnoreCase(isDirected = childElement.getAttributeValue("isDirected"))) {
                    ((IAssociationRelationship)relation).setDirected(true);
                }
            }
            this.fConceptsLookup.put(relation.getId(), (IArchimateConcept)relation);
            RelationInfo rInfo = new RelationInfo();
            rInfo.relation = relation;
            rInfo.sourceID = sourceID;
            rInfo.targetID = targetID;
            relationInfoList.add(rInfo);
        }
        for (RelationInfo rInfo : relationInfoList) {
            IArchimateConcept source = this.fConceptsLookup.get(rInfo.sourceID);
            if (source == null) {
                throw new IOException(Messages.XMLModelImporter_3 + rInfo.sourceID);
            }
            IArchimateConcept target = this.fConceptsLookup.get(rInfo.targetID);
            if (target == null) {
                throw new IOException(Messages.XMLModelImporter_4 + rInfo.targetID);
            }
            rInfo.relation.setSource(source);
            rInfo.relation.setTarget(target);
        }
    }

    private void parseOrganizations(Element organizationsElement) {
        for (Element childElement : organizationsElement.getChildren("item", ARCHIMATE3_NAMESPACE)) {
            this.parseItem(childElement);
        }
    }

    private void parseItem(Element itemElement) {
        boolean result = this.addObjectItemToFolder(itemElement);
        if (!result) {
            this.getSubFolder(itemElement, this.getTopLevelArchiFolderInHierarchy(itemElement));
        }
        for (Element childElement : itemElement.getChildren("item", ARCHIMATE3_NAMESPACE)) {
            this.parseItem(childElement);
        }
    }

    private boolean addObjectItemToFolder(Element itemElement) {
        IArchimateModelObject object = this.getItemObject(itemElement);
        if (object == null) {
            return false;
        }
        IFolder folder = this.getSubFolder(itemElement.getParentElement(), this.fModel.getDefaultFolderForObject((EObject)object));
        if (folder != null) {
            folder.getElements().add((Object)object);
        }
        return folder != null;
    }

    private IArchimateModelObject getItemObject(Element itemElement) {
        String idref = itemElement.getAttributeValue("identifierRef");
        if (!this.hasValue(idref)) {
            return null;
        }
        if (!itemElement.getChildren("item", ARCHIMATE3_NAMESPACE).isEmpty()) {
            return null;
        }
        IArchimateModelObject concept = (IArchimateModelObject)this.fConceptsLookup.get(idref);
        return concept != null ? concept : (IArchimateModelObject)this.fDiagramsLookup.get(idref);
    }

    private IFolder getSubFolder(Element itemElement, IFolder folder) {
        if (folder == null) {
            return null;
        }
        for (Element element : this.getItemHierarchy(itemElement)) {
            String name = StringUtils.safeString((String)this.getChildElementText(element, "label", true));
            String documentation = StringUtils.safeString((String)this.getChildElementText(element, "documentation", true));
            IFolder toplevelFolder = this.getTopLevelArchiFolder(element);
            if (toplevelFolder != null) {
                toplevelFolder.setDocumentation(documentation);
                continue;
            }
            folder = this.createSubFolder(folder, name, documentation);
        }
        return folder;
    }

    private IFolder createSubFolder(IFolder parent, String name, String documentation) {
        for (IFolder f : parent.getFolders()) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        IFolder folder = IArchimateFactory.eINSTANCE.createFolder();
        folder.setName(name);
        folder.setDocumentation(documentation);
        parent.getFolders().add((Object)folder);
        return folder;
    }

    private List<Element> getItemHierarchy(Element itemElement) {
        ArrayList<Element> elements = new ArrayList<Element>();
        while (itemElement != null && !"organizations".equals(itemElement.getName())) {
            elements.add(0, itemElement);
            itemElement = itemElement.getParentElement();
        }
        return elements;
    }

    private IFolder getTopLevelArchiFolderInHierarchy(Element itemElement) {
        while (itemElement != null && !"organizations".equals(itemElement.getName())) {
            IFolder folder = this.getTopLevelArchiFolder(itemElement);
            if (folder != null) {
                return folder;
            }
            itemElement = itemElement.getParentElement();
        }
        return null;
    }

    private IFolder getTopLevelArchiFolder(Element itemElement) {
        if (this.isTopLevelItem(itemElement)) {
            String name = this.getChildElementText(itemElement, "label", true);
            for (IFolder folder : this.fModel.getFolders()) {
                if (!folder.getName().equals(name)) continue;
                return folder;
            }
        }
        return null;
    }

    private boolean isTopLevelItem(Element itemElement) {
        return itemElement != null && itemElement.getParentElement() != null && "organizations".equals(itemElement.getParentElement().getName());
    }

    private void parseViews(Element viewsElement) throws XMLModelParserException {
        if (viewsElement == null) {
            return;
        }
        for (Element element : viewsElement.getChildren("view", ARCHIMATE3_NAMESPACE)) {
            String documentation;
            String name;
            String viewPointName;
            IArchimateDiagramModel dm = IArchimateFactory.eINSTANCE.createArchimateDiagramModel();
            this.fModel.getDefaultFolderForObject((EObject)dm).getElements().add((Object)dm);
            String id = element.getAttributeValue("identifier");
            if (id != null) {
                dm.setId(id);
                this.fDiagramsLookup.put(id, dm);
            }
            if ((viewPointName = element.getAttributeValue("viewpoint")) != null) {
                String viewPointID = XMLTypeMapper.getViewpointID(viewPointName);
                dm.setViewpoint(viewPointID);
            }
            if ((name = this.getChildElementText(element, "name", true)) != null) {
                dm.setName(name);
            }
            if ((documentation = this.getChildElementText(element, "documentation", false)) != null) {
                dm.setDocumentation(documentation);
            }
            this.addProperties((IProperties)dm, element);
            this.addNodes((IDiagramModelContainer)dm, element);
            this.addConnections(element);
        }
        for (Map.Entry entry : this.fDiagramRefsLookup.entrySet()) {
            IDiagramModelReference dmRef = (IDiagramModelReference)entry.getKey();
            String refID = (String)entry.getValue();
            IArchimateDiagramModel dm = this.fDiagramsLookup.get(refID);
            if (dm != null) {
                dmRef.setReferencedModel((IDiagramModel)dm);
                continue;
            }
            throw new XMLModelParserException(Messages.XMLModelImporter_15 + refID);
        }
    }

    private void addNodes(IDiagramModelContainer parentContainer, Element parentElement) throws XMLModelParserException {
        for (Element nodeElement : parentElement.getChildren("node", ARCHIMATE3_NAMESPACE)) {
            IDiagramModelArchimateObject dmo = null;
            String elementRef = nodeElement.getAttributeValue("elementRef");
            if (this.hasValue(elementRef)) {
                IArchimateConcept concept = this.fConceptsLookup.get(elementRef);
                if (!(concept instanceof IArchimateElement)) {
                    throw new XMLModelParserException(Messages.XMLModelImporter_5 + elementRef);
                }
                dmo = ArchimateDiagramModelFactory.createDiagramModelArchimateObject((IArchimateElement)((IArchimateElement)concept));
            } else {
                boolean isViewRef;
                boolean isGroup = "Container".equals(nodeElement.getAttributeValue("type", XSI_NAMESPACE));
                boolean isLabel = "Label".equals(nodeElement.getAttributeValue("type", XSI_NAMESPACE));
                boolean hasChildren = nodeElement.getChildren("node", ARCHIMATE3_NAMESPACE).size() > 0;
                boolean bl = isViewRef = isLabel && nodeElement.getChild("viewRef", ARCHIMATE3_NAMESPACE) != null;
                if (isGroup || hasChildren) {
                    String documentation;
                    factory = new ArchimateDiagramModelFactory(IArchimatePackage.eINSTANCE.getDiagramModelGroup());
                    IDiagramModelGroup group = (IDiagramModelGroup)factory.getNewObject();
                    dmo = group;
                    String name = this.getChildElementText(nodeElement, "label", true);
                    if (name != null) {
                        dmo.setName(name);
                    }
                    if ((documentation = this.getChildElementText(nodeElement, "documentation", false)) != null) {
                        group.setDocumentation(documentation);
                    }
                } else if (isViewRef) {
                    IDiagramModelReference ref = IArchimateFactory.eINSTANCE.createDiagramModelReference();
                    dmo = ref;
                    Element viewRefElement = nodeElement.getChild("viewRef", ARCHIMATE3_NAMESPACE);
                    String viewRefID = viewRefElement.getAttributeValue("ref");
                    this.fDiagramRefsLookup.put(ref, viewRefID);
                } else {
                    factory = new ArchimateDiagramModelFactory(IArchimatePackage.eINSTANCE.getDiagramModelNote());
                    IDiagramModelNote note = (IDiagramModelNote)factory.getNewObject();
                    dmo = note;
                    String text = this.getChildElementText(nodeElement, "label", false);
                    if (text != null) {
                        note.setContent(text);
                    }
                }
            }
            if (dmo == null) continue;
            String identifier = nodeElement.getAttributeValue("identifier");
            dmo.setId(identifier);
            parentContainer.getChildren().add((Object)dmo);
            IBounds bounds = this.getNodeBounds(nodeElement);
            if (parentContainer instanceof IDiagramModelObject) {
                bounds = DiagramModelUtils.getRelativeBounds((IBounds)bounds, (IDiagramModelObject)((IDiagramModelObject)parentContainer));
            }
            dmo.setBounds(bounds);
            this.addNodeStyle((IDiagramModelObject)dmo, nodeElement.getChild("style", ARCHIMATE3_NAMESPACE));
            this.fConnectionsNodesLookup.put(dmo.getId(), (IConnectable)dmo);
            if (!(dmo instanceof IDiagramModelContainer)) continue;
            this.addNodes((IDiagramModelContainer)dmo, nodeElement);
        }
    }

    IBounds getNodeBounds(Element nodeElement) throws XMLModelParserException {
        String xString = nodeElement.getAttributeValue("x");
        String yString = nodeElement.getAttributeValue("y");
        String wString = nodeElement.getAttributeValue("w");
        String hString = nodeElement.getAttributeValue("h");
        if (!(this.hasValue(xString) && this.hasValue(yString) && this.hasValue(wString) && this.hasValue(hString))) {
            throw new XMLModelParserException(Messages.XMLModelImporter_6);
        }
        int x = Integer.valueOf(xString);
        int y = Integer.valueOf(yString);
        int width = Integer.valueOf(wString);
        int height = Integer.valueOf(hString);
        return IArchimateFactory.eINSTANCE.createBounds(x, y, width, height);
    }

    private void addNodeStyle(IDiagramModelObject dmo, Element styleElement) throws XMLModelParserException {
        if (styleElement == null) {
            return;
        }
        dmo.setFillColor(this.getRGBColorString(styleElement.getChild("fillColor", ARCHIMATE3_NAMESPACE)));
        dmo.setAlpha(this.getRGBAlphaValue(styleElement.getChild("fillColor", ARCHIMATE3_NAMESPACE)));
        dmo.setLineColor(this.getRGBColorString(styleElement.getChild("lineColor", ARCHIMATE3_NAMESPACE)));
        dmo.setLineAlpha(this.getRGBAlphaValue(styleElement.getChild("lineColor", ARCHIMATE3_NAMESPACE)));
        this.addFont((IFontAttribute)dmo, styleElement.getChild("font", ARCHIMATE3_NAMESPACE));
    }

    private void addConnections(Element viewElement) throws XMLModelParserException {
        class ConnectionInfo {
            IDiagramModelConnection connection;
            Element connectionElement;

            ConnectionInfo() {
            }
        }
        ArrayList<ConnectionInfo> connectionInfoList = new ArrayList<ConnectionInfo>();
        for (Element connectionElement : viewElement.getChildren("connection", ARCHIMATE3_NAMESPACE)) {
            IDiagramModelConnection connection = null;
            String relationshipRef = connectionElement.getAttributeValue("relationshipRef");
            if (this.hasValue(relationshipRef)) {
                IArchimateConcept concept = this.fConceptsLookup.get(relationshipRef);
                if (!(concept instanceof IArchimateRelationship)) {
                    throw new XMLModelParserException(Messages.XMLModelImporter_7 + relationshipRef);
                }
                connection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection((IArchimateRelationship)((IArchimateRelationship)concept));
            } else {
                connection = IArchimateFactory.eINSTANCE.createDiagramModelConnection();
            }
            if (connection == null) continue;
            String identifier = connectionElement.getAttributeValue("identifier");
            connection.setId(identifier);
            ConnectionInfo cInfo = new ConnectionInfo();
            cInfo.connection = connection;
            cInfo.connectionElement = connectionElement;
            connectionInfoList.add(cInfo);
            this.fConnectionsNodesLookup.put(connection.getId(), (IConnectable)connection);
        }
        for (ConnectionInfo cInfo : connectionInfoList) {
            String sourceRef = cInfo.connectionElement.getAttributeValue("source");
            IConnectable connectableSource = this.fConnectionsNodesLookup.get(sourceRef);
            if (connectableSource == null) {
                throw new XMLModelParserException(Messages.XMLModelImporter_9 + sourceRef);
            }
            String targetRef = cInfo.connectionElement.getAttributeValue("target");
            IConnectable connectableTarget = this.fConnectionsNodesLookup.get(targetRef);
            if (connectableTarget == null) {
                throw new XMLModelParserException(Messages.XMLModelImporter_10 + targetRef);
            }
            if (cInfo.connection instanceof IDiagramModelArchimateConnection) {
                if (!(connectableSource instanceof IDiagramModelArchimateComponent)) {
                    throw new XMLModelParserException(Messages.XMLModelImporter_11 + sourceRef);
                }
                if (!(connectableTarget instanceof IDiagramModelArchimateComponent)) {
                    throw new XMLModelParserException(Messages.XMLModelImporter_12 + targetRef);
                }
            } else if (connectableSource instanceof IDiagramModelArchimateComponent && connectableTarget instanceof IDiagramModelArchimateComponent || connectableSource instanceof IDiagramModelConnection || connectableTarget instanceof IDiagramModelConnection) continue;
            cInfo.connection.connect(connectableSource, connectableTarget);
            this.addBendpoints(cInfo.connection, cInfo.connectionElement);
            this.addConnectionStyle(cInfo.connection, cInfo.connectionElement.getChild("style", ARCHIMATE3_NAMESPACE));
        }
        this.addNestedConnections();
    }

    private void addNestedConnections() {
        for (IDiagramModel dm : this.fModel.getDiagramModels()) {
            TreeIterator iter = dm.eAllContents();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!(eObject instanceof IDiagramModelArchimateObject)) continue;
                IDiagramModelArchimateObject parent = (IDiagramModelArchimateObject)eObject;
                for (IDiagramModelObject dmo : parent.getChildren()) {
                    IDiagramModelArchimateConnection connection;
                    if (!(dmo instanceof IDiagramModelArchimateObject)) continue;
                    IDiagramModelArchimateObject child = (IDiagramModelArchimateObject)dmo;
                    IArchimateElement parentElement = parent.getArchimateElement();
                    IArchimateElement childElement = child.getArchimateElement();
                    for (IArchimateRelationship relation : List.copyOf(parentElement.getSourceRelationships())) {
                        if (relation.getTarget() != childElement || DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)parent, (IConnectable)child, (IArchimateRelationship)relation)) continue;
                        connection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection((IArchimateRelationship)relation);
                        connection.connect((IConnectable)parent, (IConnectable)child);
                    }
                    for (IArchimateRelationship relation : List.copyOf(childElement.getSourceRelationships())) {
                        if (relation.getTarget() != parentElement || DiagramModelUtils.hasDiagramModelArchimateConnection((IConnectable)child, (IConnectable)parent, (IArchimateRelationship)relation)) continue;
                        connection = ArchimateDiagramModelFactory.createDiagramModelArchimateConnection((IArchimateRelationship)relation);
                        connection.connect((IConnectable)child, (IConnectable)parent);
                    }
                }
            }
        }
    }

    private void addBendpoints(IDiagramModelConnection connection, Element connectionElement) throws XMLModelParserException {
        if (connection.getSource() instanceof IDiagramModelConnection || connection.getTarget() instanceof IDiagramModelConnection) {
            return;
        }
        for (Element bendpointElement : connectionElement.getChildren("bendpoint", ARCHIMATE3_NAMESPACE)) {
            int y;
            String xString = bendpointElement.getAttributeValue("x");
            String yString = bendpointElement.getAttributeValue("y");
            if (!this.hasValue(xString) || !this.hasValue(yString)) {
                throw new XMLModelParserException(Messages.XMLModelImporter_13);
            }
            int x = Integer.valueOf(xString);
            IDiagramModelBendpoint bendpoint = DiagramModelUtils.createBendPointFromAbsolutePosition((IDiagramModelConnection)connection, (int)x, (int)(y = Integer.valueOf(yString).intValue()));
            if (bendpoint == null) continue;
            connection.getBendpoints().add((Object)bendpoint);
        }
    }

    private void addConnectionStyle(IDiagramModelConnection connection, Element styleElement) throws XMLModelParserException {
        if (styleElement == null) {
            return;
        }
        String lineWidthString = styleElement.getAttributeValue("lineWidth");
        if (this.hasValue(lineWidthString)) {
            int width = Integer.valueOf(lineWidthString);
            if (width < 0) {
                width = 1;
            }
            if (width > 3) {
                width = 3;
            }
            connection.setLineWidth(width);
        }
        connection.setLineColor(this.getRGBColorString(styleElement.getChild("lineColor", ARCHIMATE3_NAMESPACE)));
        this.addFont((IFontAttribute)connection, styleElement.getChild("font", ARCHIMATE3_NAMESPACE));
    }

    private void addFont(IFontAttribute fontObject, Element fontElement) throws XMLModelParserException {
        String fontStyle;
        String fontSize;
        if (fontElement == null) {
            return;
        }
        FontData newFontData = new FontData(FontFactory.getDefaultUserViewFontData().toString());
        String fontName = fontElement.getAttributeValue("name");
        if (this.hasValue(fontName)) {
            newFontData.setName(fontName);
        }
        if (this.hasValue(fontSize = fontElement.getAttributeValue("size"))) {
            int val = Double.valueOf(fontSize).intValue();
            newFontData.setHeight(val);
        }
        if (this.hasValue(fontStyle = fontElement.getAttributeValue("style"))) {
            int styleValue = 0;
            if (fontStyle.contains("bold")) {
                styleValue |= 1;
            }
            if (fontStyle.contains("italic")) {
                styleValue |= 2;
            }
            newFontData.setStyle(styleValue);
        }
        fontObject.setFont(newFontData.toString());
        fontObject.setFontColor(this.getRGBColorString(fontElement.getChild("color", ARCHIMATE3_NAMESPACE)));
    }

    String getRGBColorString(Element rgbElement) throws XMLModelParserException {
        String colorStr = null;
        if (rgbElement != null) {
            String rString = rgbElement.getAttributeValue("r");
            String gString = rgbElement.getAttributeValue("g");
            String bString = rgbElement.getAttributeValue("b");
            if (!(this.hasValue(rString) && this.hasValue(gString) && this.hasValue(bString))) {
                throw new XMLModelParserException(Messages.XMLModelImporter_14);
            }
            int red = Integer.valueOf(rString);
            int green = Integer.valueOf(gString);
            int blue = Integer.valueOf(bString);
            colorStr = ColorFactory.convertRGBToString((RGB)new RGB(red, green, blue));
        }
        return colorStr;
    }

    int getRGBAlphaValue(Element rgbElement) {
        String alphaString;
        if (rgbElement != null && this.hasValue(alphaString = rgbElement.getAttributeValue("a"))) {
            int alpha = Integer.valueOf(alphaString);
            return Math.round((float)alpha * 255.0f / 100.0f);
        }
        return 255;
    }

    String getChildElementText(Element parentElement, String childElementName, boolean normalise) {
        String code = Locale.getDefault().getLanguage();
        if (code == null) {
            code = "en";
        }
        for (Element childElement : parentElement.getChildren(childElementName, ARCHIMATE3_NAMESPACE)) {
            String lang = childElement.getAttributeValue("lang", Namespace.XML_NAMESPACE);
            if (!code.equals(lang)) continue;
            return normalise ? childElement.getTextNormalize() : childElement.getText();
        }
        Element element = parentElement.getChild(childElementName, ARCHIMATE3_NAMESPACE);
        return element == null ? null : (normalise ? element.getTextNormalize() : element.getText());
    }

    boolean hasValue(String val) {
        return StringUtils.isSet((String)val);
    }
}

