/*
 * Decompiled with CFR 0.152.
 */
package org.opengroup.archimate.xmlexchange.wizard;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.ui.UIUtils;
import com.archimatetool.editor.utils.StringUtils;
import java.io.File;
import java.util.Locale;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.opengroup.archimate.xmlexchange.IPreferenceConstants;
import org.opengroup.archimate.xmlexchange.XMLExchangePlugin;
import org.opengroup.archimate.xmlexchange.wizard.Messages;

public class ExportToXMLPage
extends WizardPage
implements IPreferenceConstants {
    private static String HELP_ID = "com.archimatetool.help.ExportToXMLPage";
    private Text fFileTextField;
    private Button fOrganiseButton;
    private Button fIncludeXSDButton;
    private Button fValidateAfterExportButton;
    private Combo fLanguageCombo;
    private String fModelName;

    public ExportToXMLPage(String modelName) {
        super("ExportToXMLPage");
        this.fModelName = modelName;
        this.setTitle(Messages.ExportToXMLPage_0);
        this.setDescription(Messages.ExportToXMLPage_1);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/exportdir_wiz.png"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Group exportGroup = new Group(container, 0);
        exportGroup.setText(Messages.ExportToXMLPage_2);
        exportGroup.setLayout((Layout)new GridLayout(3, false));
        exportGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)exportGroup, 0);
        label.setText(Messages.ExportToXMLPage_3);
        this.fFileTextField = UIUtils.createSingleTextControl((Composite)exportGroup, (int)2048, (boolean)false);
        this.fFileTextField.setLayoutData((Object)new GridData(768));
        String fileName = StringUtils.isSet((String)this.fModelName) ? this.fModelName + ".xml" : "exported.xml";
        String lastFolderName = XMLExchangePlugin.getInstance().getPreferenceStore().getString("ExportXMLExchangeLastFileLocation");
        File lastFolder = new File(lastFolderName);
        if (lastFolder.exists() && lastFolder.isDirectory()) {
            this.fFileTextField.setText(new File(lastFolder, fileName).getPath());
        } else {
            this.fFileTextField.setText(new File(System.getProperty("user.home"), fileName).getPath());
        }
        this.fFileTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportToXMLPage.this.validateFields();
            }
        });
        Button fileButton = new Button((Composite)exportGroup, 8);
        fileButton.setText(Messages.ExportToXMLPage_10);
        fileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File file = ExportToXMLPage.this.chooseFile();
                if (file != null) {
                    ExportToXMLPage.this.fFileTextField.setText(file.getPath());
                }
            }
        });
        Group optionsGroup = new Group(container, 0);
        optionsGroup.setText(Messages.ExportToXMLPage_4);
        optionsGroup.setLayout((Layout)new GridLayout(2, false));
        optionsGroup.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fOrganiseButton = new Button((Composite)optionsGroup, 32);
        this.fOrganiseButton.setSelection(XMLExchangePlugin.getInstance().getPreferenceStore().getBoolean("ExportXMLExchangeOrganisation"));
        this.fOrganiseButton.setText(Messages.ExportToXMLPage_5);
        this.fOrganiseButton.setLayoutData((Object)gd);
        this.fValidateAfterExportButton = new Button((Composite)optionsGroup, 32);
        this.fValidateAfterExportButton.setSelection(XMLExchangePlugin.getInstance().getPreferenceStore().getBoolean("ExportXMLExchangeValidate"));
        this.fValidateAfterExportButton.setText(Messages.ExportToXMLPage_11);
        this.fValidateAfterExportButton.setLayoutData((Object)gd);
        this.fIncludeXSDButton = new Button((Composite)optionsGroup, 32);
        this.fIncludeXSDButton.setSelection(XMLExchangePlugin.getInstance().getPreferenceStore().getBoolean("ExportXMLExchangeIncludeXSD"));
        this.fIncludeXSDButton.setText(Messages.ExportToXMLPage_6);
        this.fIncludeXSDButton.setLayoutData((Object)gd);
        label = new Label((Composite)optionsGroup, 0);
        label.setText(Messages.ExportToXMLPage_7);
        this.fLanguageCombo = new Combo((Composite)optionsGroup, 8);
        this.fLanguageCombo.setItems(Locale.getISOLanguages());
        gd = new GridData();
        gd.widthHint = 70;
        this.fLanguageCombo.setLayoutData((Object)gd);
        String lastLanguage = XMLExchangePlugin.getInstance().getPreferenceStore().getString("ExportXMLExchangeLanguage");
        if (StringUtils.isSet((String)lastLanguage)) {
            this.fLanguageCombo.setText(lastLanguage);
        } else {
            String code = Locale.getDefault().getLanguage();
            if (code == null) {
                code = "en";
            }
            this.fLanguageCombo.setText(code);
        }
    }

    String getFileName() {
        return this.fFileTextField.getText();
    }

    boolean doSaveOrganisation() {
        return this.fOrganiseButton.getSelection();
    }

    boolean doIncludeXSD() {
        return this.fIncludeXSDButton.getSelection();
    }

    boolean doValidateAfterExport() {
        return this.fValidateAfterExportButton.getSelection();
    }

    String getLanguageCode() {
        return this.fLanguageCombo.getText();
    }

    private void validateFields() {
        String fileName = this.getFileName();
        if (!StringUtils.isSetAfterTrim((String)fileName)) {
            this.setErrorMessage(Messages.ExportToXMLPage_8);
            return;
        }
        this.setErrorMessage(null);
    }

    public void setErrorMessage(String message) {
        super.setErrorMessage(message);
        this.setPageComplete(message == null);
    }

    private File chooseFile() {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.ExportToXMLPage_9);
        File file = new File(this.fFileTextField.getText());
        dialog.setFileName(file.getName());
        dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
        dialog.setOverwrite(false);
        Object path = dialog.open();
        if (path == null) {
            return null;
        }
        if (dialog.getFilterIndex() == 0 && !((String)path).endsWith(".xml")) {
            path = (String)path + ".xml";
        }
        return new File((String)path);
    }

    void storePreferences() {
        IPreferenceStore store = XMLExchangePlugin.getInstance().getPreferenceStore();
        File file = new File(this.getFileName());
        if (file.getParentFile().exists()) {
            store.setValue("ExportXMLExchangeLastFileLocation", file.getParentFile().getPath());
        } else {
            store.setValue("ExportXMLExchangeLastFileLocation", "");
        }
        store.setValue("ExportXMLExchangeOrganisation", this.doSaveOrganisation());
        store.setValue("ExportXMLExchangeIncludeXSD", this.doIncludeXSD());
        store.setValue("ExportXMLExchangeValidate", this.doValidateAfterExport());
        store.setValue("ExportXMLExchangeLanguage", this.getLanguageCode());
    }
}

