/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports;

import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.jasperreports.JasperReportsPlugin;
import com.archimatetool.jasperreports.Messages;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class ExportJasperReportsWizardPage2
extends WizardPage {
    private static String HELP_ID = "com.archimatetool.help.ExportJasperReportsWizardPage2";
    private ComboViewer fComboTemplateViewer;
    private ComboViewer fComboLocale;
    private Template fLastSelectedTemplate;
    private static Locale fSelectedLocale = Locale.getDefault();
    private List<Template> fTemplates = new ArrayList<Template>();

    public ExportJasperReportsWizardPage2() {
        super("ExportJasperReportsWizardPage2");
        this.setTitle(Messages.ExportJasperReportsWizardPage2_2);
        this.setDescription(Messages.ExportJasperReportsWizardPage2_3);
        this.setImageDescriptor(IArchiImages.ImageFactory.getImageDescriptor("img/exportdir_wiz.png"));
        this.discoverReports();
    }

    private void discoverReports() {
        File inbuiltReportsFolder = JasperReportsPlugin.getInstance().getJasperReportsFolder();
        this.scanFolder(inbuiltReportsFolder);
        File userReportsFolder = JasperReportsPlugin.getInstance().getUserTemplatesFolder();
        this.scanFolder(userReportsFolder);
        this.fTemplates.add(new Template(Messages.ExportJasperReportsWizardPage2_1, null));
    }

    private void scanFolder(File folder) {
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File report;
                File file = fileArray[n2];
                if (file.isDirectory() && (report = new File(file, "main.jrxml")).exists() && report.canRead()) {
                    this.fTemplates.add(new Template(file.getName(), report));
                }
                ++n2;
            }
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, HELP_ID);
        Composite fieldContainer = new Composite(container, 0);
        fieldContainer.setLayoutData((Object)new GridData(768));
        fieldContainer.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(fieldContainer, 0);
        label.setText(Messages.ExportJasperReportsWizardPage2_4);
        this.fComboTemplateViewer = new ComboViewer(new Combo(fieldContainer, 2056));
        this.fComboTemplateViewer.getControl().setLayoutData((Object)new GridData(768));
        this.fComboTemplateViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Template template = (Template)((IStructuredSelection)event.getSelection()).getFirstElement();
                if (template.location == null) {
                    ExportJasperReportsWizardPage2.this.handleCustomDialog();
                } else {
                    ExportJasperReportsWizardPage2.this.fLastSelectedTemplate = template;
                }
            }
        });
        this.fComboTemplateViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ExportJasperReportsWizardPage2.this.fTemplates.toArray();
            }
        });
        this.fComboTemplateViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Template)element).name;
            }
        });
        this.fComboTemplateViewer.setInput((Object)"");
        this.fComboTemplateViewer.setSelection((ISelection)new StructuredSelection((Object)this.fTemplates.get(0)));
        label = new Label(fieldContainer, 0);
        label.setText(Messages.ExportJasperReportsWizardPage2_6);
        this.fComboLocale = new ComboViewer(new Combo(fieldContainer, 2056));
        this.fComboLocale.getControl().setLayoutData((Object)new GridData(768));
        this.fComboLocale.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                ArrayList<Locale> locales = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
                if (Locale.getDefault() != null && !locales.contains(Locale.getDefault())) {
                    locales.add(Locale.getDefault());
                }
                Collections.sort(locales, (locale1, locale2) -> locale1.toLanguageTag().compareTo(locale2.toLanguageTag()));
                return locales.toArray();
            }
        });
        this.fComboLocale.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Locale)element).toLanguageTag();
            }
        });
        this.fComboLocale.setInput((Object)"");
        if (fSelectedLocale != null) {
            this.fComboLocale.setSelection((ISelection)new StructuredSelection((Object)fSelectedLocale));
        }
        this.fComboLocale.addSelectionChangedListener(event -> {
            fSelectedLocale = (Locale)((IStructuredSelection)event.getSelection()).getFirstElement();
        });
    }

    public File getMainTemplateFile() {
        Template template = (Template)((IStructuredSelection)this.fComboTemplateViewer.getSelection()).getFirstElement();
        return template.location;
    }

    public Locale getLocale() {
        return fSelectedLocale;
    }

    private void handleCustomDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        dialog.setText(Messages.ExportJasperReportsWizardPage2_5);
        if (!PlatformUtils.isMac()) {
            dialog.setFilterExtensions(new String[]{"main.jrxml", "*.jrxml", "*.*"});
            dialog.setFileName("main.jrxml");
        } else {
            dialog.setFilterExtensions(new String[]{"*.jrxml", "*.*"});
        }
        String path = dialog.open();
        if (path != null) {
            Template template2;
            File file = new File(path);
            for (Template template2 : this.fTemplates) {
                if (!file.equals(template2.location)) continue;
                this.fComboTemplateViewer.setSelection((ISelection)new StructuredSelection((Object)template2));
                return;
            }
            template2 = new Template(ExportJasperReportsWizardPage2.getShortPath(file), file);
            this.fTemplates.add(this.fTemplates.size() - 1, template2);
            this.fComboTemplateViewer.refresh();
            this.fComboTemplateViewer.setSelection((ISelection)new StructuredSelection((Object)template2));
        } else {
            this.fComboTemplateViewer.setSelection((ISelection)new StructuredSelection((Object)this.fLastSelectedTemplate));
        }
    }

    private static String getShortPath(File file) {
        Object path = file.getAbsolutePath();
        try {
            Object pathPart = file.getParent();
            if (((String)pathPart).length() > 38) {
                pathPart = ((String)pathPart).substring(0, 35);
                pathPart = (String)pathPart + "..." + File.separator;
                path = pathPart = (String)pathPart + file.getName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return path;
    }

    private static class Template {
        String name;
        File location;

        Template(String name, File location) {
            this.name = name;
            this.location = location;
        }
    }
}

