/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.jasperreports.data;

import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.jasperreports.data.ArchimateModelDataSource;
import com.archimatetool.jasperreports.data.FieldDataFactory;
import com.archimatetool.jasperreports.data.IPropertiesDataSource;
import com.archimatetool.jasperreports.data.PropertiesModelDataSource;
import com.archimatetool.jasperreports.data.ViewModelDataSource;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IFolder;
import com.archimatetool.model.IProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ElementsDataSource
implements JRRewindableDataSource,
IPropertiesDataSource {
    List<IArchimateConcept> fConcepts = new ArrayList<IArchimateConcept>();
    private IArchimateConcept fCurrentConcept;
    private int currentIndex = -1;

    public ElementsDataSource(IArchimateModel model, String types) {
        this(model, types, false);
    }

    public ElementsDataSource(IArchimateModel model, String types, boolean sortFirstByType) {
        Set<EClass> desiredEClasses = ArchimateModelDataSource.getClasses(types);
        this.getConcepts(model, desiredEClasses);
        if (sortFirstByType) {
            ArchimateModelDataSource.sortByTypeThenName(this.fConcepts);
        } else {
            ArchimateModelDataSource.sort(this.fConcepts);
        }
    }

    public ElementsDataSource(IDiagramModel dm) {
        this(dm, false);
    }

    public ElementsDataSource(IDiagramModel dm, boolean sortFirstByType) {
        this(dm, "elements", sortFirstByType);
    }

    public ElementsDataSource(IDiagramModel dm, String types) {
        this(dm, types, false);
    }

    public ElementsDataSource(IDiagramModel dm, String types, boolean sortFirstByType) {
        this.fConcepts.addAll(ArchimateModelDataSource.getConceptsInDiagram(dm, types));
        if (sortFirstByType) {
            ArchimateModelDataSource.sortByTypeThenName(this.fConcepts);
        } else {
            ArchimateModelDataSource.sort(this.fConcepts);
        }
    }

    public int size() {
        return this.fConcepts.size();
    }

    @Override
    public PropertiesModelDataSource getPropertiesDataSource() {
        return new PropertiesModelDataSource((IProperties)this.fCurrentConcept);
    }

    public IArchimateConcept getElement() {
        return this.fCurrentConcept;
    }

    public boolean next() throws JRException {
        this.fCurrentConcept = this.currentIndex < this.fConcepts.size() - 1 ? this.fConcepts.get(++this.currentIndex) : null;
        return this.fCurrentConcept != null;
    }

    public Object getFieldValue(JRField jrField) throws JRException {
        return FieldDataFactory.getFieldValue(this.fCurrentConcept, jrField.getName());
    }

    public void moveFirst() throws JRException {
        this.currentIndex = -1;
    }

    public ViewModelDataSource getReferencedViews() {
        if (this.fCurrentConcept == null) {
            return null;
        }
        List views = DiagramModelUtils.findReferencedDiagramsForArchimateConcept((IArchimateConcept)this.fCurrentConcept);
        return new ViewModelDataSource(views);
    }

    private void getConcepts(IArchimateModel model, Set<EClass> desiredEClasses) {
        for (IFolder folder : model.getFolders()) {
            this.getConcepts(folder, desiredEClasses);
        }
    }

    private void getConcepts(IFolder folder, Set<EClass> desiredEClasses) {
        for (EObject object : folder.getElements()) {
            if (!(object instanceof IArchimateConcept) || !desiredEClasses.contains(object.eClass()) || this.fConcepts.contains(object)) continue;
            this.fConcepts.add((IArchimateConcept)object);
        }
        for (IFolder f : folder.getFolders()) {
            this.getConcepts(f, desiredEClasses);
        }
    }
}

