/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import com.archimatetool.editor.Archi4Migrator;
import com.archimatetool.editor.ArchiWorkbenchAdvisor;
import com.archimatetool.editor.OpenDocumentHandler;
import com.archimatetool.editor.WorkbenchCleaner;
import com.archimatetool.editor.preferences.PrefUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class Application
implements IApplication {
    public static String ID = "com.archimatetool.editor.app";

    public Object start(IApplicationContext context) throws Exception {
        if (PlatformUtils.isWindows() || PlatformUtils.isLinux()) {
            Location loc = Platform.getInstanceLocation();
            if (loc.isLocked()) {
                return EXIT_OK;
            }
            if (loc.isSet()) {
                loc.lock();
            }
        }
        if (Archi4Migrator.check()) {
            return EXIT_RESTART;
        }
        PrefUtils.init();
        Display display = PlatformUI.createDisplay();
        OpenDocumentHandler.getInstance().hook(display);
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new ArchiWorkbenchAdvisor());
            boolean restart = returnCode == 1;
            WorkbenchCleaner.clean(restart);
            if (restart) {
                Integer n = EXIT_RESTART;
                return n;
            }
            Integer n = EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
    }
}

