/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.utils.FileUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Archi4Migrator {
    private static File previousLocation;
    private static File currentLocation;
    private static int DONT_ASK_AGAIN;

    static {
        DONT_ASK_AGAIN = 2;
    }

    public static boolean check() throws Exception {
        previousLocation = ArchiPlugin.getInstance().getUserPropertyLocation("workspaceMigrationLocation");
        if (previousLocation == null) {
            previousLocation = PlatformUtils.isWindows() ? new File(System.getProperty("user.home") + "/AppData/Roaming/Archi4") : (PlatformUtils.isMac() ? new File(System.getProperty("user.home") + "/Library/Application Support/Archi4") : new File(System.getProperty("user.home") + "/.archi4"));
        }
        if (Platform.getInstanceLocation() == null || Platform.getInstanceLocation().getURL() == null) {
            return false;
        }
        currentLocation = new File(Platform.getInstanceLocation().getURL().getPath());
        File migratedFile = new File(previousLocation, "migrated");
        if (!previousLocation.exists() || previousLocation.equals(currentLocation) || migratedFile.exists()) {
            return false;
        }
        File[] previousLocationFiles = previousLocation.listFiles();
        if (previousLocationFiles == null || previousLocationFiles.length == 0) {
            return false;
        }
        int response = new MigratorDialog().open();
        if (response == 1) {
            return false;
        }
        if (response == DONT_ASK_AGAIN) {
            Files.createFile(migratedFile.toPath(), new FileAttribute[0]);
            return false;
        }
        Exception[] exception = new Exception[1];
        boolean[] cancelled = new boolean[1];
        IRunnableWithProgress runnable = monitor -> {
            try {
                monitor.beginTask("Copying files...", -1);
                File previousDropinsLocation = ArchiPlugin.getInstance().getUserPropertyLocation("dropinsMigrationLocation");
                File[] fileArray2 = previousLocationFiles;
                int n = previousLocationFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    block17: {
                        block16: {
                            File file;
                            block15: {
                                file = fileArray2[n2];
                                if (!file.isFile()) break block15;
                                monitor.setTaskName("Copying: " + file.getName());
                                Files.copy(file.toPath(), currentLocation.toPath().resolve(file.toPath().getFileName()), StandardCopyOption.REPLACE_EXISTING);
                                break block16;
                            }
                            if (".config".equals(file.getName()) || previousDropinsLocation != null && previousDropinsLocation.equals(file)) break block17;
                            monitor.setTaskName("Copying: " + file.getName());
                            if ("dropins".equals(file.getName()) || ".metadata".equals(file.getName())) {
                                FileUtils.copyFolder(file, new File(currentLocation, file.getName()));
                            } else if (!previousLocation.equals(ArchiPlugin.getInstance().getUserDataFolder())) {
                                FileUtils.copyFolder(file, new File(ArchiPlugin.getInstance().getUserDataFolder(), file.getName()));
                            }
                        }
                        if (monitor.isCanceled()) {
                            blArray[0] = true;
                            break;
                        }
                    }
                    ++n2;
                }
                if (previousDropinsLocation != null && previousDropinsLocation.isDirectory()) {
                    File currentDropinsLocation = ArchiPlugin.getInstance().getUserDropinsFolder();
                    if (currentDropinsLocation == null) {
                        currentDropinsLocation = new File(currentLocation, "dropins");
                    }
                    if (!previousDropinsLocation.equals(currentDropinsLocation)) {
                        FileUtils.copyFolder(previousDropinsLocation, currentDropinsLocation);
                    }
                }
            }
            catch (Exception ex) {
                exceptionArray[0] = ex;
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            dialog.run(true, true, runnable);
        }
        catch (Exception ex) {
            exception[0] = ex;
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        if (cancelled[0]) {
            return false;
        }
        Files.createFile(migratedFile.toPath(), new FileAttribute[0]);
        return true;
    }

    private static class MigratorDialog
    extends TitleAreaDialog {
        protected MigratorDialog() {
            super(null);
        }

        protected Control createDialogArea(Composite parent) {
            this.setTitle("Archi 5 Migration");
            this.setTitleImage(IArchiImages.ImageFactory.getImage("img/importpref_wiz.png"));
            this.setMessage("Would you like to copy your Archi 4 settings and data to Archi 5?", 1);
            Composite area = (Composite)super.createDialogArea(parent);
            Composite container = new Composite(area, 0);
            GridDataFactory.create((int)1808).applyTo((Control)container);
            container.setLayout((Layout)new GridLayout(1, false));
            Text text = new Text(container, 74);
            GridDataFactory.create((int)1808).hint(80, -1).applyTo((Control)text);
            text.setText("Application data will be copied from '" + previousLocation.getAbsolutePath() + "' to '" + currentLocation.getAbsolutePath() + "'.\n\nUser data such as scripts and repositories will be copied from '" + previousLocation.getAbsolutePath() + "' to '" + ArchiPlugin.getInstance().getUserDataFolder().getAbsolutePath() + "'.");
            return area;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Archi 5");
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.getButton(1).setText("No");
            this.getButton(0).setText("Yes");
            this.createButton(parent, DONT_ASK_AGAIN, "Don't ask again", false);
        }

        protected void buttonPressed(int buttonId) {
            super.buttonPressed(buttonId);
            if (buttonId == DONT_ASK_AGAIN) {
                this.setReturnCode(DONT_ASK_AGAIN);
                this.close();
            }
        }

        protected Point getInitialSize() {
            return new Point(550, 300);
        }

        protected boolean isResizable() {
            return true;
        }
    }
}

