/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.ArchiWorkbenchWindowAdvisor;
import com.archimatetool.editor.OpenDocumentHandler;
import com.archimatetool.editor.utils.NetUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ArchiWorkbenchAdvisor
extends WorkbenchAdvisor {
    public void initialize(IWorkbenchConfigurer configurer) {
        IPreferenceNode systemNode;
        super.initialize(configurer);
        configurer.setSaveAndRestore(true);
        PlatformUI.getPreferenceStore().setValue("SHOW_MEMORY_MONITOR", "true".equals(System.getProperty("showheap")));
        if (PlatformUtils.isWindows() && ArchiPlugin.getInstance().getPreferenceStore().getBoolean("edgeBrowser")) {
            System.setProperty("org.eclipse.swt.browser.DefaultType", "edge");
        }
        TrayDialog.setDialogHelpAvailable((boolean)true);
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        if (pm != null && (systemNode = pm.find("org.eclipse.ui.preferencePages.Workbench")) != null) {
            IPreferenceNode securityNode;
            IPreferenceNode securityCategoryNode;
            IPreferenceNode helpNode = pm.find("org.eclipse.help.ui.browsersPreferencePage");
            if (helpNode != null) {
                pm.remove(helpNode);
                systemNode.add(helpNode);
            }
            if ((securityCategoryNode = systemNode.findSubNode("org.eclipse.equinox.security.ui.category")) != null && (securityNode = securityCategoryNode.findSubNode("org.eclipse.equinox.security.ui.storage")) != null) {
                systemNode.remove(securityCategoryNode);
                systemNode.add(securityNode);
            }
        }
        NetUtils.initialise();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ArchiWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "com.archimatetool.editor.perspectiveMain";
    }

    public void eventLoopIdle(Display display) {
        OpenDocumentHandler.getInstance().openQueuedFiles();
        super.eventLoopIdle(display);
    }
}

