/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.eclipse.ui.PlatformUI;

public class FileLogger {
    private static final int DEFAULT_MAX_BYTES = 0xA00000;
    private static final int DEFAULT_MAX_FILE_COUNT = 3;
    private static Map<String, FileLogger> loggers = new HashMap<String, FileLogger>();
    private String rootPackageName;
    private Logger rootLogger;
    private FileHandler fileHandler;

    public static FileLogger create(String rootPackageName, URL propertiesFile, File fileNamePattern) throws IOException {
        return FileLogger.create(rootPackageName, propertiesFile, fileNamePattern, 0xA00000, 3);
    }

    public static FileLogger create(String rootPackageName, URL propertiesFile, File fileNamePattern, int limit, int count) throws IOException {
        FileLogger logger = loggers.get(rootPackageName);
        if (logger == null) {
            logger = new FileLogger(rootPackageName, propertiesFile, fileNamePattern, limit, count);
            loggers.put(rootPackageName, logger);
        }
        return logger;
    }

    public static FileLogger get(String rootPackageName) {
        return loggers.get(rootPackageName);
    }

    private FileLogger() {
    }

    private FileLogger(String rootPackageName, URL propertiesFile, File fileNamePattern, int limit, int count) throws IOException {
        this.rootPackageName = rootPackageName;
        this.rootLogger = Logger.getLogger(rootPackageName);
        this.rootLogger.setUseParentHandlers(false);
        if (propertiesFile != null) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream is = propertiesFile.openStream();){
                LogManager.getLogManager().updateConfiguration(is, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        if (fileNamePattern.getParentFile() != null) {
            fileNamePattern.getParentFile().mkdirs();
        }
        this.fileHandler = new FileHandler(fileNamePattern.getAbsolutePath(), limit, count, true);
        String format = LogManager.getLogManager().getProperty(rootPackageName + ".format");
        this.fileHandler.setFormatter(new ExtSimpleFormatter(format));
        this.fileHandler.setEncoding("UTF-8");
        this.rootLogger.addHandler(this.fileHandler);
    }

    public void setLevel(Level newLevel) {
        if (this.rootLogger != null) {
            this.rootLogger.setLevel(newLevel);
        }
    }

    public void close() {
        if (this.fileHandler != null) {
            this.fileHandler.close();
        }
        if (this.rootLogger != null) {
            this.rootLogger.removeHandler(this.fileHandler);
        }
        this.fileHandler = null;
        this.rootLogger = null;
        loggers.remove(this.rootPackageName);
    }

    private static class ExtSimpleFormatter
    extends SimpleFormatter {
        private static final String DEFAULT_FORMAT = "[%1$tF %1$tH:%1$tM:%1$tS.%1$tL] %4$-7s [%2$s] %5$s%6$s%n";
        private String format;

        private ExtSimpleFormatter(String format) {
            this.format = format == null ? DEFAULT_FORMAT : format;
        }

        @Override
        public String format(LogRecord record) {
            Object source;
            ZonedDateTime zdt = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
            if (record.getSourceClassName() != null) {
                source = record.getSourceClassName();
                if (record.getSourceMethodName() != null) {
                    source = (String)source + " " + record.getSourceMethodName();
                }
            } else {
                source = record.getLoggerName();
            }
            String message = this.formatMessage(record);
            String throwable = "";
            if (record.getThrown() != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                record.getThrown().printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(this.format, zdt, source, record.getLoggerName(), record.getLevel().getLocalizedName(), message, throwable);
        }
    }
}

