/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import com.archimatetool.editor.model.IEditorModelManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenDocumentHandler {
    private static final File[] EMPTY_QUEUE = new File[0];
    private static final OpenDocumentHandler instance = new OpenDocumentHandler();
    private List<File> files = new ArrayList<File>();
    private Listener hook = null;

    public static OpenDocumentHandler getInstance() {
        return instance;
    }

    private OpenDocumentHandler() {
    }

    public void hook(Display display) {
        if (this.hook == null) {
            this.hook = new OpenDocumentHook();
        }
        display.addListener(46, this.hook);
    }

    public void unhook(Display display) {
        if (this.hook != null) {
            display.removeListener(46, this.hook);
        }
    }

    public void openQueuedFiles() {
        File[] files = this.drain();
        if (files.length > 0) {
            Shell shell;
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (shell = window.getShell()) != null && !shell.isDisposed()) {
                shell.setMinimized(false);
                shell.forceActive();
            }
            this.openFiles(files);
        }
    }

    private void openFiles(File[] files) {
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!IEditorModelManager.INSTANCE.isModelLoaded(file)) {
                IEditorModelManager.INSTANCE.openModel(file);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueue(File file) {
        OpenDocumentHandler openDocumentHandler = this;
        synchronized (openDocumentHandler) {
            this.files.add(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] drain() {
        OpenDocumentHandler openDocumentHandler = this;
        synchronized (openDocumentHandler) {
            if (this.files.isEmpty()) {
                return EMPTY_QUEUE;
            }
        }
        File[] array = this.files.toArray(new File[this.files.size()]);
        this.files.clear();
        return array;
    }

    private class OpenDocumentHook
    implements Listener {
        private OpenDocumentHook() {
        }

        public void handleEvent(Event event) {
            String str = event.text;
            if (str != null && !"".equals(str)) {
                File localFile = new File(str);
                try {
                    str = localFile.getCanonicalPath();
                }
                catch (Exception exception) {
                    str = localFile.getAbsolutePath();
                }
                File file = new File(str);
                if (file.exists() && file.isFile()) {
                    OpenDocumentHandler.this.enqueue(file);
                }
            }
        }
    }
}

