/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor;

import com.archimatetool.editor.Messages;
import com.archimatetool.editor.p2.P2;
import com.archimatetool.editor.utils.PlatformUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WorkbenchCleaner {
    private static final String METADATA_FOLDER = ".metadata";
    private static final String WORKBENCH_FILE = ".metadata/.plugins/org.eclipse.e4.workbench/workbench.xmi";
    private static final String CLEAN_CONFIG = "-cleanConfig";
    private static final String NO_CLEAN_CONFIG = "-noCleanConfig";
    private static final String[] CONFIG_FILES_TO_DELETE = new String[]{".baseConfigIniTimestamp", "config.ini", "eclipse.ini.ignored", "org.eclipse.core.runtime", "org.eclipse.equinox.app", "org.eclipse.equinox.simpleconfigurator", "org.eclipse.update", "org.eclipse.osgi"};
    private static final String ARTIFACTS_FILE = "artifacts.xml";
    private static int cleanWorkBench = -1;

    public static void askResetWorkbench() {
        int response = MessageDialog.open((int)3, (Shell)Display.getCurrent().getActiveShell(), (String)Messages.WorkbenchCleaner_0, (String)(Messages.WorkbenchCleaner_1 + "\n\n" + Messages.WorkbenchCleaner_3), (int)0, (String[])new String[]{Messages.WorkbenchCleaner_4, Messages.WorkbenchCleaner_5, Messages.WorkbenchCleaner_6});
        if (response == -1 || response == 2) {
            return;
        }
        if (PlatformUI.getWorkbench().restart()) {
            cleanWorkBench = response;
        }
    }

    static void clean(boolean isRestart) {
        WorkbenchCleaner.cleanWorkbench();
        WorkbenchCleaner.cleanConfigOnExit(isRestart);
    }

    static void cleanWorkbench() {
        if (cleanWorkBench == -1) {
            return;
        }
        File instanceLocationFolder = WorkbenchCleaner.getLocationAsFile(Platform.getInstanceLocation());
        if (instanceLocationFolder != null) {
            if (cleanWorkBench == 0) {
                WorkbenchCleaner.delete(new File(instanceLocationFolder, WORKBENCH_FILE));
            } else if (cleanWorkBench == 1) {
                WorkbenchCleaner.delete(new File(instanceLocationFolder, METADATA_FOLDER));
            }
        }
    }

    public static void cleanConfigOnExit(boolean isRestart) {
        List<String> appArgs = Arrays.asList(Platform.getApplicationArgs());
        if (Platform.inDevelopmentMode() || appArgs.contains(NO_CLEAN_CONFIG) || !appArgs.contains(CLEAN_CONFIG)) {
            return;
        }
        File configLocationFolder = WorkbenchCleaner.getLocationAsFile(Platform.getConfigurationLocation());
        File installationFolder = WorkbenchCleaner.getLocationAsFile(Platform.getInstallLocation());
        if (configLocationFolder == null || installationFolder == null) {
            return;
        }
        if (configLocationFolder.getName().equals("configuration") && installationFolder.equals(configLocationFolder.getParentFile())) {
            return;
        }
        File p2Folder = P2.getP2Location();
        Runnable runnable = () -> {
            File artifactsFile;
            String[] stringArray = CONFIG_FILES_TO_DELETE;
            int n = CONFIG_FILES_TO_DELETE.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                WorkbenchCleaner.delete(new File(configLocationFolder, path));
                ++n2;
            }
            if (p2Folder != null && !installationFolder.equals(p2Folder.getParentFile())) {
                WorkbenchCleaner.delete(p2Folder);
            }
            if (!installationFolder.equals((artifactsFile = new File(configLocationFolder.getParentFile(), ARTIFACTS_FILE)).getParentFile())) {
                WorkbenchCleaner.delete(artifactsFile);
            }
        };
        if (PlatformUtils.isMac() && isRestart) {
            runnable.run();
        } else {
            Runtime.getRuntime().addShutdownHook(new Thread(runnable));
        }
    }

    private static File getLocationAsFile(Location location) {
        if (location == null || location.getURL() == null) {
            return null;
        }
        return new File(location.getURL().getPath());
    }

    private static void delete(File file) {
        if (file.isDirectory()) {
            WorkbenchCleaner.deleteFolder(file);
        } else {
            file.delete();
        }
    }

    private static void deleteFolder(File folder) {
        if (folder.exists() && folder.isDirectory()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    file.delete();
                } else if (file.isDirectory()) {
                    WorkbenchCleaner.deleteFolder(file);
                }
                ++n2;
            }
            folder.delete();
        }
    }
}

