/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public abstract class AbstractDropDownAction
extends Action
implements IMenuCreator {
    protected Menu fMenu;
    protected List<IContributionItem> fItems = new ArrayList<IContributionItem>();

    public AbstractDropDownAction() {
        this(null);
    }

    public AbstractDropDownAction(String text) {
        this.setMenuCreator(this);
        this.setText(text);
        this.setToolTipText(text);
    }

    public Menu getMenu(Menu parent) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(parent);
            this.fill();
        }
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(parent);
            this.fill();
        }
        return this.fMenu;
    }

    public void runWithEvent(Event event) {
        ToolItem ti = (ToolItem)event.widget;
        Rectangle bounds = ti.getBounds();
        ToolBar control = ti.getParent();
        Menu menu = this.getMenu((Control)control);
        Point point = control.toDisplay(new Point(bounds.x, bounds.height));
        menu.setLocation(point);
        menu.setVisible(true);
    }

    private void fill() {
        for (IContributionItem item : this.fItems) {
            item.fill(this.fMenu, -1);
        }
    }

    public void add(IAction action) {
        this.add((IContributionItem)new ActionContributionItem(action));
    }

    public void add(IContributionItem item) {
        this.fItems.add(item);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }
}

