/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.actions;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.actions.Messages;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IArchimateModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class MRUMenuManager
extends MenuManager
implements PropertyChangeListener {
    static final String MRU_PREFS_KEY = "MRU";
    private List<File> fMRUList;
    private IWorkbenchWindow fWindow;

    public MRUMenuManager(IWorkbenchWindow window) {
        super(Messages.MRUMenuManager_0, "open_recent_menu");
        this.fWindow = window;
        this.createMenuItems();
        IEditorModelManager.INSTANCE.addPropertyChangeListener(this);
    }

    private List<File> loadMRUListFromPreferenceStore() {
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        while (i < this.getPreferencesMRUMax()) {
            String path = ArchiPlugin.getInstance().getPreferenceStore().getString(MRU_PREFS_KEY + i);
            if (StringUtils.isSet(path)) {
                list.add(new File(path));
            }
            ++i;
        }
        return list;
    }

    List<File> getMRUList() {
        if (this.fMRUList == null) {
            this.fMRUList = this.loadMRUListFromPreferenceStore();
        }
        return this.fMRUList;
    }

    void addToList(File file) {
        List<File> list = this.getMRUList();
        if (list.contains(file)) {
            list.remove(file);
            list.add(0, file);
        } else {
            list.add(0, file);
            while (list.size() > this.getPreferencesMRUMax()) {
                list.remove(list.size() - 1);
            }
        }
    }

    private void saveList() {
        int i = 0;
        while (i < 50) {
            ArchiPlugin.getInstance().getPreferenceStore().setValue(MRU_PREFS_KEY + i, "");
            ++i;
        }
        i = 0;
        while (i < this.getMRUList().size()) {
            ArchiPlugin.getInstance().getPreferenceStore().setValue(MRU_PREFS_KEY + i, this.getMRUList().get(i).getAbsolutePath());
            ++i;
        }
    }

    private void createMenuItems() {
        this.removeAll();
        for (File file : this.getMRUList()) {
            this.add((IAction)new RecentFileAction(file));
        }
        this.add((IContributionItem)new Separator());
        MRU_ClearAction clearAction = new MRU_ClearAction();
        clearAction.setEnabled(!this.getMRUList().isEmpty());
        this.add((IAction)clearAction);
        this.saveList();
    }

    void clearAll() {
        this.getMRUList().clear();
        this.createMenuItems();
    }

    int getPreferencesMRUMax() {
        int max = ArchiPlugin.getInstance().getPreferenceStore().getInt("mruMax");
        if (max < 3) {
            max = 3;
        }
        if (max > 15) {
            max = 15;
        }
        return max;
    }

    String getShortPath(File file) {
        Object path = file.getAbsolutePath();
        try {
            Object pathPart = file.getParent();
            if (pathPart != null && ((String)pathPart).length() > 38) {
                pathPart = ((String)pathPart).substring(0, 35);
                pathPart = (String)pathPart + "..." + File.separator;
                path = pathPart = (String)pathPart + file.getName();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return path;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IArchimateModel model;
        if (("IEditorModelManager.model.opened" == evt.getPropertyName() || "IEditorModelManager.model.saved" == evt.getPropertyName()) && (model = (IArchimateModel)evt.getNewValue()) != null && model.getFile() != null && model.getFile().exists() && !this.isTempFile(model.getFile())) {
            this.addToList(model.getFile());
            this.createMenuItems();
        }
    }

    boolean isTempFile(File file) {
        try {
            File tmpDir = new File(System.getProperty("java.io.tmpdir"));
            return file.getCanonicalPath().startsWith(tmpDir.getCanonicalPath());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public void dispose() {
        super.dispose();
        IEditorModelManager.INSTANCE.removePropertyChangeListener(this);
        this.saveList();
    }

    private class MRU_ClearAction
    extends Action {
        MRU_ClearAction() {
            this.setText(Messages.MRUMenuManager_3);
        }

        public void run() {
            MRUMenuManager.this.clearAll();
        }
    }

    private class RecentFileAction
    extends Action {
        File file;

        RecentFileAction(File file) {
            this.file = file;
            this.setText(MRUMenuManager.this.getShortPath(file));
            this.setToolTipText(file.getPath());
        }

        public void run() {
            if (this.file.exists()) {
                if (!IEditorModelManager.INSTANCE.isModelLoaded(this.file)) {
                    BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            IEditorModelManager.INSTANCE.openModel(RecentFileAction.this.file);
                        }
                    });
                }
            } else {
                MessageDialog.openInformation((Shell)MRUMenuManager.this.fWindow.getShell(), (String)Messages.MRUMenuManager_1, (String)NLS.bind((String)Messages.MRUMenuManager_2, (Object)this.file));
                MRUMenuManager.this.getMRUList().remove(this.file);
                MRUMenuManager.this.createMenuItems();
            }
        }
    }
}

