/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.actions.ArchiActionFactory;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.diagram.actions.ConnectionRouterAction;
import com.archimatetool.editor.diagram.actions.ObjectPositionAction;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractDiagramEditorContextMenuProvider
extends ContextMenuProvider {
    public static final String GROUP_UNDO = "group_undo";
    public static final String GROUP_EDIT = "group_edit";
    public static final String GROUP_RENAME = "group_rename";
    public static final String GROUP_EXPORT = "group_export";
    public static final String GROUP_ORDER = "group_order";
    public static final String GROUP_POSITION = "group_position";
    public static final String GROUP_CONNECTIONS = "group_connections";
    public static final String GROUP_PROPERTIES = "group_properties";
    protected ActionRegistry actionRegistry;

    public AbstractDiagramEditorContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
        super(viewer);
        this.actionRegistry = registry;
    }

    public void buildContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator(GROUP_UNDO));
        IAction action = this.actionRegistry.getAction((Object)ActionFactory.UNDO.getId());
        menu.appendToGroup(GROUP_UNDO, action);
        action = this.actionRegistry.getAction((Object)ActionFactory.REDO.getId());
        menu.appendToGroup(GROUP_UNDO, action);
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        action = this.actionRegistry.getAction((Object)ActionFactory.CUT.getId());
        menu.appendToGroup(GROUP_EDIT, action);
        action = this.actionRegistry.getAction((Object)ActionFactory.COPY.getId());
        menu.appendToGroup(GROUP_EDIT, action);
        action = this.actionRegistry.getAction((Object)"com.archimatetool.editor.action.exportAsImageToClipboard");
        menu.appendToGroup(GROUP_EDIT, action);
        action = this.actionRegistry.getAction((Object)ActionFactory.PASTE.getId());
        menu.appendToGroup(GROUP_EDIT, action);
        action = this.actionRegistry.getAction((Object)ArchiActionFactory.PASTE_SPECIAL.getId());
        menu.appendToGroup(GROUP_EDIT, action);
        menu.appendToGroup(GROUP_EDIT, (IContributionItem)new Separator());
        action = this.actionRegistry.getAction((Object)ActionFactory.DELETE.getId());
        menu.appendToGroup(GROUP_EDIT, action);
        menu.appendToGroup(GROUP_EDIT, this.actionRegistry.getAction((Object)"com.archimatetool.editor.action.deleteContainer"));
        action = this.actionRegistry.getAction((Object)"LockObjectAction");
        if (action.isEnabled()) {
            menu.appendToGroup(GROUP_EDIT, (IContributionItem)new Separator());
            menu.appendToGroup(GROUP_EDIT, action);
        }
        menu.add((IContributionItem)new Separator(GROUP_RENAME));
        action = this.actionRegistry.getAction((Object)ActionFactory.RENAME.getId());
        menu.appendToGroup(GROUP_RENAME, action);
        menu.appendToGroup(GROUP_RENAME, (IContributionItem)new Separator());
        menu.appendToGroup(GROUP_RENAME, this.actionRegistry.getAction((Object)"SelectElementInTreeAction"));
        menu.appendToGroup(GROUP_RENAME, this.actionRegistry.getAction((Object)"com.archimatetool.editor.selectSameObjectType"));
        menu.appendToGroup(GROUP_RENAME, (IContributionItem)new Separator());
        menu.add((IContributionItem)new Separator(GROUP_EXPORT));
        MenuManager exportMenu = new MenuManager(Messages.AbstractDiagramEditorContextMenuProvider_0, "menu_export");
        menu.add((IContributionItem)exportMenu);
        exportMenu.add(this.actionRegistry.getAction((Object)"ExportAsImageAction"));
        menu.add((IContributionItem)new Separator(GROUP_ORDER));
        MenuManager orderMenu = new MenuManager(Messages.AbstractDiagramEditorContextMenuProvider_1, "menu_order");
        menu.add((IContributionItem)orderMenu);
        ObjectPositionAction.ObjectPositionActionDefinition[] objectPositionActionDefinitionArray = ObjectPositionAction.getActionDefinitions();
        int n = objectPositionActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectPositionAction.ObjectPositionActionDefinition def = objectPositionActionDefinitionArray[n2];
            orderMenu.add(this.actionRegistry.getAction((Object)def.id()));
            ++n2;
        }
        menu.add((IContributionItem)new GroupMarker(GROUP_POSITION));
        MenuManager alignmentMenu = new MenuManager(Messages.AbstractDiagramEditorContextMenuProvider_2, "menu_position");
        menu.add((IContributionItem)alignmentMenu);
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.align_left"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.align_center"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.align_right"));
        alignmentMenu.add((IContributionItem)new Separator());
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.align_top"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.align_middle"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.align_bottom"));
        alignmentMenu.add((IContributionItem)new Separator());
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.match.width"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.match.height"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"org.eclipse.gef.match.size"));
        alignmentMenu.add((IContributionItem)new Separator());
        alignmentMenu.add(this.actionRegistry.getAction((Object)"com.archimatetool.action.defaultSize"));
        alignmentMenu.add(this.actionRegistry.getAction((Object)"ResetAspectRatioAction"));
        menu.add((IContributionItem)new Separator(GROUP_CONNECTIONS));
        MenuManager connectionMenu = new MenuManager(Messages.AbstractDiagramEditorContextMenuProvider_3, "menu_connection_router");
        menu.appendToGroup(GROUP_CONNECTIONS, (IContributionItem)connectionMenu);
        connectionMenu.add(this.actionRegistry.getAction((Object)ConnectionRouterAction.BendPointConnectionRouterAction.ID));
        connectionMenu.add(this.actionRegistry.getAction((Object)ConnectionRouterAction.ManhattanConnectionRouterAction.ID));
        menu.add((IContributionItem)new Separator(GROUP_PROPERTIES));
        action = this.actionRegistry.getAction((Object)ActionFactory.PROPERTIES.getId());
        menu.add(action);
    }
}

