/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.AbstractDiagramEditor;
import com.archimatetool.editor.diagram.ArchimateDiagramEditorContextMenuProvider;
import com.archimatetool.editor.diagram.ArchimateDiagramEditorPalette;
import com.archimatetool.editor.diagram.IArchimateDiagramEditor;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.diagram.actions.DeleteFromModelAction;
import com.archimatetool.editor.diagram.actions.GenerateViewAction;
import com.archimatetool.editor.diagram.actions.ViewpointAction;
import com.archimatetool.editor.diagram.dnd.ArchimateDiagramTransferDropTargetListener;
import com.archimatetool.editor.diagram.editparts.ArchimateDiagramEditPartFactory;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class ArchimateDiagramEditor
extends AbstractDiagramEditor
implements IArchimateDiagramEditor {
    @Override
    protected void applicationPreferencesChanged(PropertyChangeEvent event) {
        if ("viewpointsHidePaletteElements" == event.getProperty()) {
            this.getPaletteRoot().updateViewpoint();
        } else if ("showSpecializationsInPalette" == event.getProperty()) {
            this.getPaletteRoot().updateSpecializations();
        } else if ("viewpointsGhostDiagramElements" == event.getProperty()) {
            this.getGraphicalViewer().setContents((Object)this.getModel());
        } else {
            super.applicationPreferencesChanged(event);
        }
    }

    protected void setViewpoint() {
        this.getPaletteRoot().updateViewpoint();
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsGhostDiagramElements")) {
            this.getGraphicalViewer().setContents((Object)this.getModel());
        }
    }

    @Override
    public void doCreatePartControl(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.archimatetool.help.diagramEditorHelp");
    }

    public ArchimateDiagramEditorPalette getPaletteRoot() {
        if (this.fPaletteRoot == null) {
            this.fPaletteRoot = new ArchimateDiagramEditorPalette(this.getModel());
        }
        return (ArchimateDiagramEditorPalette)this.fPaletteRoot;
    }

    public IArchimateDiagramModel getModel() {
        return (IArchimateDiagramModel)super.getModel();
    }

    @Override
    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setEditPartFactory((EditPartFactory)new ArchimateDiagramEditPartFactory());
        viewer.setContents((Object)this.getModel());
        viewer.addDropTargetListener((TransferDropTargetListener)new ArchimateDiagramTransferDropTargetListener((EditPartViewer)viewer));
    }

    @Override
    protected void configurePaletteViewer(PaletteViewer viewer) {
        super.configurePaletteViewer(viewer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), "com.archimatetool.help.diagramEditorPaletteHelp");
    }

    @Override
    protected void registerContextMenu(GraphicalViewer viewer) {
        ArchimateDiagramEditorContextMenuProvider provider = new ArchimateDiagramEditorContextMenuProvider((EditPartViewer)viewer, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("ArchimateDiagramEditorContextMenuProvider", (MenuManager)provider, (ISelectionProvider)viewer);
    }

    @Override
    public void selectObjects(Object[] objects) {
        if (this.getModel() == null) {
            return;
        }
        HashSet<Object> selection = new HashSet<Object>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IArchimateConcept) {
                for (IDiagramModelComponent iDiagramModelComponent : DiagramModelUtils.findDiagramModelComponentsForArchimateConcept((IDiagramModel)this.getModel(), (IArchimateConcept)object)) {
                    selection.add(iDiagramModelComponent);
                }
            } else {
                selection.add(object);
            }
            ++n2;
        }
        super.selectObjects(selection.toArray());
    }

    @Override
    protected void createActions(GraphicalViewer viewer) {
        super.createActions(viewer);
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DeleteFromModelAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        for (IViewpoint viewPoint : ViewpointManager.INSTANCE.getAllViewpoints()) {
            action = new ViewpointAction((IWorkbenchPart)this, viewPoint);
            registry.registerAction((IAction)action);
        }
        action = new GenerateViewAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    @Override
    protected void notifyChanged(Notification msg) {
        if (msg.getNotifier() == this.getModel() && msg.getFeature() == IArchimatePackage.Literals.ARCHIMATE_DIAGRAM_MODEL__VIEWPOINT) {
            this.setViewpoint();
        } else {
            super.notifyChanged(msg);
        }
    }

    public int getContextChangeMask() {
        return 0;
    }

    public IContext getContext(Object target) {
        return HelpSystem.getContext((String)"com.archimatetool.help.diagramEditorHelp");
    }

    public String getSearchExpression(Object target) {
        return Messages.ArchimateDiagramEditor_0;
    }
}

