/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.AbstractPaletteRoot;
import com.archimatetool.editor.diagram.ArchimateDiagramModelFactory;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.diagram.PaletteKeyHandler;
import com.archimatetool.editor.diagram.tools.ExtConnectionCreationToolEntry;
import com.archimatetool.editor.diagram.tools.MagicConnectionCreationTool;
import com.archimatetool.editor.diagram.tools.MagicConnectionModelFactory;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.INameable;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.util.ArchimateModelUtils;
import com.archimatetool.model.util.LightweightEContentAdapter;
import com.archimatetool.model.viewpoints.IViewpoint;
import com.archimatetool.model.viewpoints.ViewpointManager;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.gef.palette.CombinedTemplateCreationEntry;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.resource.ImageDescriptor;

public class ArchimateDiagramEditorPalette
extends AbstractPaletteRoot {
    private static int RELATIONS_GROUP = 1;
    private static int SPECIALIZATIONS_GROUP = 5;
    private IArchimateDiagramModel fDiagramModel;
    private List<PaletteEntry> fElementEntries = new ArrayList<PaletteEntry>();
    private List<PaletteEntry> fRelationshipEntries = new ArrayList<PaletteEntry>();
    private List<PaletteEntry> fSpecializationEntries = new ArrayList<PaletteEntry>();
    private LightweightEContentAdapter eAdapter = new LightweightEContentAdapter(msg -> {
        if (msg.getFeature() == IArchimatePackage.Literals.ARCHIMATE_MODEL__PROFILES) {
            this.createSpecializationsGroup();
        }
    }, new Class[]{IProfile.class});

    public ArchimateDiagramEditorPalette(IArchimateDiagramModel dm) {
        this.fDiagramModel = dm;
        this.add((PaletteEntry)this.createToolsGroup());
        this.createArchimateRelationsGroup();
        this.createExtrasGroup();
        this.createSpecializationsGroup();
        this.createArchimateElementGroups();
    }

    void updateViewpoint() {
        this.createArchimateRelationsGroup();
        this.createSpecializationsGroup();
        this.createArchimateElementGroups();
    }

    void updateSpecializations() {
        this.createSpecializationsGroup();
    }

    private void createExtrasGroup() {
        PaletteGroup group = new PaletteGroup(Messages.ArchimateDiagramEditorPalette_1);
        CombinedTemplateCreationEntry noteEntry = new CombinedTemplateCreationEntry(ArchiLabelProvider.INSTANCE.getDefaultName(IArchimatePackage.eINSTANCE.getDiagramModelNote()), Messages.ArchimateDiagramEditorPalette_3, (CreationFactory)new ArchimateDiagramModelFactory(IArchimatePackage.eINSTANCE.getDiagramModelNote()), IArchiImages.ImageFactory.getImageDescriptor("img/note.png"), IArchiImages.ImageFactory.getImageDescriptor("img/note.png"));
        group.add((PaletteEntry)noteEntry);
        PaletteKeyHandler.setKeyBinding((ToolEntry)noteEntry, IArchimatePackage.eINSTANCE.getDiagramModelNote().getName());
        CombinedTemplateCreationEntry groupEntry = new CombinedTemplateCreationEntry(ArchiLabelProvider.INSTANCE.getDefaultName(IArchimatePackage.eINSTANCE.getDiagramModelGroup()), Messages.ArchimateDiagramEditorPalette_5, (CreationFactory)new ArchimateDiagramModelFactory(IArchimatePackage.eINSTANCE.getDiagramModelGroup()), IArchiImages.ImageFactory.getImageDescriptor("img/group.png"), IArchiImages.ImageFactory.getImageDescriptor("img/group.png"));
        group.add((PaletteEntry)groupEntry);
        PaletteKeyHandler.setKeyBinding((ToolEntry)groupEntry, IArchimatePackage.eINSTANCE.getDiagramModelGroup().getName());
        ToolEntry entry = this.createConnectionCreationToolEntry(IArchimatePackage.eINSTANCE.getDiagramModelConnection(), Messages.ArchimateDiagramEditorPalette_7);
        group.add((PaletteEntry)entry);
        this.add((PaletteEntry)group);
        this.add((PaletteEntry)new PaletteSeparator());
    }

    private void createArchimateRelationsGroup() {
        ToolEntry entry;
        EClass eClass;
        for (PaletteEntry entry2 : this.fRelationshipEntries) {
            this.remove(entry2);
        }
        this.fRelationshipEntries.clear();
        PaletteGroup group = new PaletteGroup(Messages.ArchimateDiagramEditorPalette_13);
        this.add(RELATIONS_GROUP, (PaletteEntry)group);
        this.fRelationshipEntries.add((PaletteEntry)group);
        ConnectionCreationToolEntry magicConnectionEntry = new ConnectionCreationToolEntry(Messages.ArchimateDiagramEditorPalette_14, Messages.ArchimateDiagramEditorPalette_15, (CreationFactory)new MagicConnectionModelFactory(), IArchiImages.ImageFactory.getImageDescriptor("img/magic_connection.png"), IArchiImages.ImageFactory.getImageDescriptor("img/magic_connection.png"));
        magicConnectionEntry.setToolClass(MagicConnectionCreationTool.class);
        magicConnectionEntry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, (Object)true);
        PaletteKeyHandler.setKeyBinding((ToolEntry)magicConnectionEntry, "MagicConnector");
        group.add((PaletteEntry)magicConnectionEntry);
        EClass[] eClassArray = ArchimateModelUtils.getRelationsClasses();
        int n = eClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            eClass = eClassArray[n2];
            if (this.isAllowedConceptForViewpoint(eClass)) {
                entry = this.createConnectionCreationToolEntry(eClass, Messages.ArchimateDiagramEditorPalette_6);
                group.add((PaletteEntry)entry);
            }
            ++n2;
        }
        eClassArray = ArchimateModelUtils.getConnectorClasses();
        n = eClassArray.length;
        n2 = 0;
        while (n2 < n) {
            eClass = eClassArray[n2];
            entry = this.createElementCreationToolEntry(eClass, Messages.ArchimateDiagramEditorPalette_19);
            group.add((PaletteEntry)entry);
            ++n2;
        }
        PaletteSeparator sep = new PaletteSeparator();
        this.add(RELATIONS_GROUP + 1, (PaletteEntry)sep);
        this.fRelationshipEntries.add((PaletteEntry)sep);
    }

    private void createArchimateElementGroups() {
        for (PaletteEntry entry : this.fElementEntries) {
            this.remove(entry);
        }
        this.fElementEntries.clear();
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_17, ArchimateModelUtils.getOtherClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_16, ArchimateModelUtils.getStrategyClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_8, ArchimateModelUtils.getBusinessClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_9, ArchimateModelUtils.getApplicationClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_10, ArchimateModelUtils.getTechnologyClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_18, ArchimateModelUtils.getPhysicalClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_11, ArchimateModelUtils.getMotivationClasses());
        this.createArchimateElementGroup(Messages.ArchimateDiagramEditorPalette_12, ArchimateModelUtils.getImplementationMigrationClasses());
    }

    private void createSpecializationsGroup() {
        ArrayList<IProfile> profiles;
        for (PaletteEntry entry : this.fSpecializationEntries) {
            this.remove(entry);
        }
        this.fSpecializationEntries.clear();
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("showSpecializationsInPalette")) {
            this.fDiagramModel.getArchimateModel().eAdapters().remove((Object)this.eAdapter);
            return;
        }
        if (!this.fDiagramModel.getArchimateModel().eAdapters().contains((Object)this.eAdapter)) {
            this.fDiagramModel.getArchimateModel().eAdapters().add((Object)this.eAdapter);
        }
        if ((profiles = new ArrayList<IProfile>((Collection<IProfile>)this.fDiagramModel.getArchimateModel().getProfiles())).isEmpty()) {
            return;
        }
        Collator collator = Collator.getInstance();
        profiles.sort(Comparator.comparing(IProfile::getConceptClass, (c1, c2) -> {
            if (IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(c1) && IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(c2) || IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(c1) && IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(c2)) {
                return 0;
            }
            if (IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(c1)) {
                return -1;
            }
            return 1;
        }).thenComparing(INameable::getName, (name1, name2) -> collator.compare((String)name1, (String)name2)));
        PaletteGroup group = new PaletteGroup(Messages.ArchimateDiagramEditorPalette_0);
        for (IProfile profile : profiles) {
            ExtConnectionCreationToolEntry entry;
            EClass eClass = profile.getConceptClass();
            ImageDescriptor id = ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass);
            if (IArchimatePackage.eINSTANCE.getArchimateElement().isSuperTypeOf(eClass) && this.isAllowedConceptForViewpoint(eClass)) {
                if (profile.getImagePath() != null) {
                    id = ArchiLabelProvider.INSTANCE.getImageDescriptorForSpecialization(profile);
                }
                entry = new CombinedTemplateCreationEntry(profile.getName(), ArchiLabelProvider.INSTANCE.getDefaultName(eClass), (CreationFactory)new ArchimateDiagramModelFactory(eClass, profile), id, id);
                group.add((PaletteEntry)entry);
                continue;
            }
            if (!IArchimatePackage.eINSTANCE.getArchimateRelationship().isSuperTypeOf(eClass)) continue;
            entry = new ExtConnectionCreationToolEntry(profile.getName(), ArchiLabelProvider.INSTANCE.getDefaultName(eClass), new ArchimateDiagramModelFactory(eClass, profile), id, id);
            entry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, true);
            group.add((PaletteEntry)entry);
        }
        if (!group.getChildren().isEmpty()) {
            this.add(SPECIALIZATIONS_GROUP, (PaletteEntry)group);
            this.fSpecializationEntries.add((PaletteEntry)group);
            PaletteSeparator sep = new PaletteSeparator();
            this.add(SPECIALIZATIONS_GROUP + 1, (PaletteEntry)sep);
            this.fSpecializationEntries.add((PaletteEntry)sep);
        }
    }

    private void createArchimateElementGroup(String title, EClass[] types) {
        PaletteGroup group = null;
        EClass[] eClassArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            EClass eClass = eClassArray[n2];
            if (this.isAllowedConceptForViewpoint(eClass)) {
                if (group == null) {
                    group = new PaletteGroup(title);
                    this.add((PaletteEntry)group);
                    this.fElementEntries.add((PaletteEntry)group);
                }
                ToolEntry entry = this.createElementCreationToolEntry(eClass, Messages.ArchimateDiagramEditorPalette_20);
                group.add((PaletteEntry)entry);
            }
            ++n2;
        }
        if (group != null) {
            PaletteSeparator sep = new PaletteSeparator();
            this.add((PaletteEntry)sep);
            this.fElementEntries.add((PaletteEntry)sep);
        }
    }

    private boolean isAllowedConceptForViewpoint(EClass eClass) {
        if (!ArchiPlugin.getInstance().getPreferenceStore().getBoolean("viewpointsHidePaletteElements")) {
            return true;
        }
        IViewpoint vp = ViewpointManager.INSTANCE.getViewpoint(this.fDiagramModel.getViewpoint());
        return vp == null || vp != null && vp.isAllowedConcept(eClass);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.fElementEntries = null;
        this.fRelationshipEntries = null;
        this.fSpecializationEntries = null;
        this.fDiagramModel.getArchimateModel().eAdapters().remove((Object)this.eAdapter);
        this.fDiagramModel = null;
        this.eAdapter = null;
    }

    private ToolEntry createElementCreationToolEntry(EClass eClass, String description) {
        CombinedTemplateCreationEntry entry = new CombinedTemplateCreationEntry(ArchiLabelProvider.INSTANCE.getDefaultName(eClass), description, (CreationFactory)new ArchimateDiagramModelFactory(eClass), ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass), ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass));
        PaletteKeyHandler.setKeyBinding((ToolEntry)entry, eClass.getName());
        return entry;
    }

    private ToolEntry createConnectionCreationToolEntry(EClass eClass, String description) {
        ExtConnectionCreationToolEntry entry = new ExtConnectionCreationToolEntry(ArchiLabelProvider.INSTANCE.getDefaultName(eClass), description, new ArchimateDiagramModelFactory(eClass), ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass), ArchiLabelProvider.INSTANCE.getImageDescriptor(eClass));
        entry.setToolProperty(AbstractTool.PROPERTY_UNLOAD_WHEN_FINISHED, true);
        PaletteKeyHandler.setKeyBinding((ToolEntry)entry, eClass.getName());
        return entry;
    }
}

