/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IArchimateDiagramEditor;
import com.archimatetool.editor.diagram.ICreationFactory;
import com.archimatetool.editor.ui.ArchiLabelProvider;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelGroup;
import com.archimatetool.model.IDiagramModelNote;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.ITextAlignment;
import com.archimatetool.model.ITextPosition;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.IEditorPart;

public class ArchimateDiagramModelFactory
implements ICreationFactory {
    private EClass fTemplate;
    private IProfile fProfile;

    public static IDiagramModelArchimateObject createDiagramModelArchimateObject(IArchimateElement element) {
        IDiagramModelArchimateObject dmo = IArchimateFactory.eINSTANCE.createDiagramModelArchimateObject();
        dmo.setArchimateElement(element);
        dmo.setType(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultFigure" + element.eClass().getName()));
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider((EObject)dmo);
        Dimension size = provider.getDefaultSize();
        dmo.setBounds(0, 0, size.width, size.height);
        dmo.setTextPosition(provider.getDefaultTextPosition());
        dmo.setTextAlignment(provider.getDefaultTextAlignment());
        ColorFactory.setDefaultColors((IDiagramModelComponent)dmo);
        dmo.setGradient(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultGradient"));
        return dmo;
    }

    public static IDiagramModelArchimateConnection createDiagramModelArchimateConnection(IArchimateRelationship relation) {
        IDiagramModelArchimateConnection connection = IArchimateFactory.eINSTANCE.createDiagramModelArchimateConnection();
        connection.setArchimateRelationship(relation);
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider((EObject)connection);
        connection.setTextAlignment(provider.getDefaultTextAlignment());
        ColorFactory.setDefaultColors((IDiagramModelComponent)connection);
        return connection;
    }

    public ArchimateDiagramModelFactory(EClass template) {
        this.fTemplate = template;
    }

    public ArchimateDiagramModelFactory(EClass template, IProfile profile) {
        this.fTemplate = template;
        this.fProfile = profile;
    }

    @Override
    public boolean isUsedFor(IEditorPart editor) {
        return editor instanceof IArchimateDiagramEditor;
    }

    public Object getNewObject() {
        if (this.fTemplate == null) {
            return null;
        }
        boolean isSpecialization = this.fProfile != null && this.fProfile.getArchimateModel() != null;
        EObject object = IArchimateFactory.eINSTANCE.create(this.fTemplate);
        if (object instanceof IArchimateConcept && isSpecialization) {
            ((IArchimateConcept)object).getProfiles().add((Object)this.fProfile);
        }
        if (object instanceof IArchimateRelationship) {
            return ArchimateDiagramModelFactory.createDiagramModelArchimateConnection((IArchimateRelationship)object);
        }
        if (object instanceof IArchimateElement) {
            IArchimateElement element = (IArchimateElement)object;
            element.setName(isSpecialization ? this.fProfile.getName() : ArchiLabelProvider.INSTANCE.getDefaultName(this.fTemplate));
            return ArchimateDiagramModelFactory.createDiagramModelArchimateObject(element);
        }
        if (object instanceof IDiagramModelGroup) {
            IDiagramModelGroup group = (IDiagramModelGroup)object;
            group.setName(ArchiLabelProvider.INSTANCE.getDefaultName(this.fTemplate));
            ColorFactory.setDefaultColors((IDiagramModelComponent)group);
            group.setGradient(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultGradient"));
        } else if (object instanceof IDiagramModelNote) {
            IDiagramModelNote note = (IDiagramModelNote)object;
            ColorFactory.setDefaultColors((IDiagramModelComponent)note);
            note.setGradient(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultGradient"));
        } else if (object instanceof IDiagramModelConnection) {
            ColorFactory.setDefaultColors((IDiagramModelComponent)((IDiagramModelConnection)object));
        }
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider(object);
        if (object instanceof ITextAlignment) {
            ((ITextAlignment)object).setTextAlignment(provider.getDefaultTextAlignment());
        }
        if (object instanceof ITextPosition) {
            ((ITextPosition)object).setTextPosition(provider.getDefaultTextPosition());
        }
        if (object instanceof IDiagramModelObject) {
            Dimension size = provider.getDefaultSize();
            ((IDiagramModelObject)object).setBounds(0, 0, size.width, size.height);
        }
        return object;
    }

    public Object getObjectType() {
        return this.fTemplate;
    }
}

