/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.diagram.IDiagramEditorFactory;
import com.archimatetool.model.IDiagramModel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class DiagramEditorFactoryExtensionHandler {
    public static String EXTENSIONPOINT = "com.archimatetool.editor.diagramEditorFactory";
    public static DiagramEditorFactoryExtensionHandler INSTANCE = new DiagramEditorFactoryExtensionHandler();
    private List<IDiagramEditorFactory> factories = new ArrayList<IDiagramEditorFactory>();

    private DiagramEditorFactoryExtensionHandler() {
        this.registerFactories();
    }

    public List<IDiagramEditorFactory> getRegisteredFactories() {
        return this.factories;
    }

    public IDiagramEditorFactory getFactory(IDiagramModel model) {
        for (IDiagramEditorFactory factory : this.factories) {
            if (!factory.isFactoryFor(model)) continue;
            return factory;
        }
        return null;
    }

    private void registerFactories() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = registry.getConfigurationElementsFor(EXTENSIONPOINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                String id = configurationElement.getAttribute("id");
                IDiagramEditorFactory factory = (IDiagramEditorFactory)configurationElement.createExecutableExtension("class");
                if (id != null && factory != null) {
                    this.factories.add(factory);
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
    }
}

