/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.diagram.editparts.AbstractDiagramPart;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.editor.ui.findreplace.AbstractFindReplaceProvider;
import com.archimatetool.editor.utils.StringUtils;
import com.archimatetool.model.IAdapter;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.INameable;
import com.archimatetool.model.ITextContent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DiagramEditorFindReplaceProvider
extends AbstractFindReplaceProvider {
    private GraphicalViewer fGraphicalViewer;
    boolean replaceSelection = false;

    public DiagramEditorFindReplaceProvider(GraphicalViewer graphicalViewer) {
        this.fGraphicalViewer = graphicalViewer;
    }

    @Override
    public boolean find(String toFind) {
        if (this.isAll()) {
            List<EditPart> editParts = this.getAllMatchingEditParts(toFind);
            this.fGraphicalViewer.setSelection((ISelection)new StructuredSelection(editParts));
            if (!editParts.isEmpty()) {
                this.fGraphicalViewer.reveal(editParts.get(0));
            }
            return !editParts.isEmpty();
        }
        EditPart editPart = this.findNextEditPart(this.getFirstSelectedEditPart(), toFind);
        if (editPart != null) {
            this.fGraphicalViewer.setSelection((ISelection)new StructuredSelection((Object)editPart));
            this.fGraphicalViewer.reveal(editPart);
        }
        return editPart != null;
    }

    @Override
    public boolean replace(String toFind, String toReplaceWith) {
        if (this.isAll()) {
            List<EditPart> editParts = this.getAllMatchingEditParts(toFind);
            if (!editParts.isEmpty()) {
                ArrayList<String> newStrings = new ArrayList<String>();
                for (EditPart editPart : editParts) {
                    String oldString = this.getStringFromEditPart(editPart);
                    String newString = this.getReplacedString(oldString, toFind, toReplaceWith);
                    newStrings.add(newString);
                }
                this.doReplaceStringCommands(editParts, newStrings);
                this.fGraphicalViewer.setSelection((ISelection)new StructuredSelection(editParts));
                this.fGraphicalViewer.reveal(editParts.get(0));
            }
            return !editParts.isEmpty();
        }
        if (this.replaceSelection) {
            List<EditPart> selected = this.getSelectedEditParts();
            if (!selected.isEmpty()) {
                ArrayList<EditPart> editParts = new ArrayList<EditPart>();
                ArrayList<String> newTexts = new ArrayList<String>();
                for (EditPart editPart : selected) {
                    if (!this.matches(editPart, toFind)) continue;
                    editParts.add(editPart);
                    String oldString = this.getStringFromEditPart(editPart);
                    String newString = this.getReplacedString(oldString, toFind, toReplaceWith);
                    newTexts.add(newString);
                }
                if (!editParts.isEmpty()) {
                    this.doReplaceStringCommands(editParts, newTexts);
                    return true;
                }
            }
        } else {
            EditPart editPart = this.getFirstSelectedEditPart();
            if (this.matches(editPart, toFind)) {
                String oldString = this.getStringFromEditPart(editPart);
                this.doReplaceStringCommand(editPart, this.getReplacedString(oldString, toFind, toReplaceWith));
                return true;
            }
        }
        return this.find(toFind);
    }

    EditPart findNextEditPart(EditPart startEditPart, String toFind) {
        int startIndex;
        List<EditPart> editParts = this.getAllEditParts();
        if (editParts.isEmpty()) {
            return null;
        }
        int increment = this.isForward() ? 1 : -1;
        int n = startIndex = this.isForward() ? 0 : editParts.size() - 1;
        if (startEditPart != null) {
            startIndex = editParts.indexOf(startEditPart) + increment;
        }
        int i = startIndex;
        while (!(this.isForward() ? i >= editParts.size() : i < 0)) {
            EditPart editPart = editParts.get(i);
            if (this.matches(editPart, toFind)) {
                return editPart;
            }
            i += increment;
        }
        if (startEditPart != null) {
            return this.findNextEditPart(null, toFind);
        }
        return null;
    }

    @Override
    public boolean understandsParameter(int parameter) {
        return parameter != 64 && parameter != 32 && parameter != 16;
    }

    List<EditPart> getAllMatchingEditParts(String toFind) {
        return this.getMatchingEditParts(this.fGraphicalViewer.getContents(), toFind);
    }

    List<EditPart> getMatchingEditParts(EditPart editPart, String toFind) {
        ArrayList<EditPart> list = new ArrayList<EditPart>();
        if (toFind == null) {
            list.add(editPart);
        } else if (this.matches(editPart, toFind)) {
            list.add(editPart);
        }
        if (this.isIncludeRelations() && editPart instanceof GraphicalEditPart) {
            for (Object connectionEditPart : ((GraphicalEditPart)editPart).getSourceConnections()) {
                if (toFind == null) {
                    list.add((EditPart)connectionEditPart);
                    continue;
                }
                if (!this.matches((EditPart)connectionEditPart, toFind)) continue;
                list.add((EditPart)connectionEditPart);
            }
        }
        for (Object object : editPart.getChildren()) {
            list.addAll(this.getMatchingEditParts((EditPart)object, toFind));
        }
        return list;
    }

    private List<EditPart> getAllEditParts() {
        return this.getAllMatchingEditParts(null);
    }

    private boolean matches(EditPart editPart, String toFind) {
        if (editPart instanceof AbstractDiagramPart || !(editPart instanceof GraphicalEditPart) || !editPart.isSelectable() || !StringUtils.isSet(toFind)) {
            return false;
        }
        String string = this.getStringFromEditPart(editPart);
        return string != null && string.matches(this.getSearchStringPattern(toFind));
    }

    private EditPart getFirstSelectedEditPart() {
        IStructuredSelection selection = (IStructuredSelection)this.fGraphicalViewer.getSelection();
        EditPart editPart = (EditPart)selection.getFirstElement();
        return editPart instanceof AbstractDiagramPart ? null : editPart;
    }

    private List<EditPart> getSelectedEditParts() {
        IStructuredSelection selection = (IStructuredSelection)this.fGraphicalViewer.getSelection();
        return selection.toList();
    }

    void doReplaceStringCommand(EditPart editPart, String newText) {
        Command command = this.createCommand(editPart, newText);
        CommandStack stack = (CommandStack)((IAdapter)editPart.getModel()).getAdapter(CommandStack.class);
        if (command != null && stack != null) {
            stack.execute(command);
        }
    }

    void doReplaceStringCommands(List<EditPart> editParts, List<String> newTexts) {
        if (editParts.size() != newTexts.size() || editParts.isEmpty()) {
            return;
        }
        CommandStack stack = (CommandStack)((IAdapter)editParts.get(0).getModel()).getAdapter(CommandStack.class);
        if (stack == null) {
            return;
        }
        NonNotifyingCompoundCommand compoundCommand = new NonNotifyingCompoundCommand(Messages.DiagramEditorFindReplaceProvider_0);
        int i = 0;
        while (i < editParts.size()) {
            String newText;
            EditPart editPart = editParts.get(i);
            Command command = this.createCommand(editPart, newText = newTexts.get(i));
            if (command != null) {
                compoundCommand.add(command);
            }
            ++i;
        }
        stack.execute(compoundCommand.unwrap());
    }

    Command createCommand(EditPart editPart, String newString) {
        if (editPart.getModel() instanceof ITextContent) {
            return new EObjectFeatureCommand(Messages.DiagramEditorFindReplaceProvider_0, (EObject)editPart.getModel(), (EStructuralFeature)IArchimatePackage.Literals.TEXT_CONTENT__CONTENT, newString);
        }
        if (editPart.getModel() instanceof INameable) {
            return new EObjectFeatureCommand(Messages.DiagramEditorFindReplaceProvider_0, (EObject)editPart.getModel(), (EStructuralFeature)IArchimatePackage.Literals.NAMEABLE__NAME, newString);
        }
        return null;
    }

    String getStringFromEditPart(EditPart editPart) {
        if (editPart.getModel() instanceof ITextContent) {
            return ((ITextContent)editPart.getModel()).getContent();
        }
        if (editPart.getModel() instanceof INameable) {
            return ((INameable)editPart.getModel()).getName();
        }
        return null;
    }
}

