/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.diagram.DiagramEditorInput;
import com.archimatetool.editor.diagram.NullDiagramEditorInput;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IDiagramModel;
import java.io.File;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;

public class DiagramEditorInputFactory
implements IElementFactory {
    public static final String ID_FACTORY = "com.archimatetool.editor.DiagramEditorInputFactory";
    public static final String TAG_VIEW_ID = "view_id";
    public static final String TAG_VIEW_FILE = "file";
    public static final String TAG_VIEW_NAME = "name";

    public IAdaptable createElement(IMemento memento) {
        String viewID = memento.getString(TAG_VIEW_ID);
        String fileName = memento.getString(TAG_VIEW_FILE);
        String viewName = memento.getString(TAG_VIEW_NAME);
        if (viewID != null && fileName != null) {
            File file = new File(fileName);
            for (IArchimateModel model : IEditorModelManager.INSTANCE.getModels()) {
                if (!file.equals(model.getFile())) continue;
                for (IDiagramModel diagramModel : model.getDiagramModels()) {
                    if (!viewID.equals(diagramModel.getId())) continue;
                    return new DiagramEditorInput(diagramModel);
                }
            }
        }
        return new NullDiagramEditorInput(fileName, viewName);
    }

    public static void saveState(IMemento memento, DiagramEditorInput input) {
        IDiagramModel diagramModel = input.getDiagramModel();
        if (diagramModel != null && diagramModel.getArchimateModel() != null) {
            File file;
            memento.putString(TAG_VIEW_ID, diagramModel.getId());
            String name = diagramModel.getName();
            if (name != null) {
                memento.putString(TAG_VIEW_NAME, name);
            }
            if ((file = diagramModel.getArchimateModel().getFile()) != null) {
                memento.putString(TAG_VIEW_FILE, file.getAbsolutePath());
            }
        }
    }
}

