/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.IDiagramModelEditor;
import com.archimatetool.editor.diagram.Messages;
import com.archimatetool.editor.ui.IArchiImages;
import com.archimatetool.editor.utils.StringUtils;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FloatingPalette {
    private IDiagramModelEditor fEditor;
    private Shell fParentShell;
    private Shell fShell;
    private Composite fClient;
    private PalettePage fPalettePage;
    private PaletteState fPaletteState = new PaletteState();

    public FloatingPalette(IDiagramModelEditor editor, Shell parentShell) {
        this.fEditor = editor;
        this.fParentShell = parentShell;
        this.loadState();
    }

    public void open() {
        this.loadState();
        if (this.fShell == null || this.fShell.isDisposed()) {
            this.createShell();
        }
        this.fShell.open();
        this.fPaletteState.isOpen = true;
    }

    public void close() {
        if (this.fShell != null && !this.fShell.isDisposed()) {
            this.saveState(this.fShell);
            this.fShell.dispose();
        }
    }

    public boolean isOpen() {
        return this.fShell != null && !this.fShell.isDisposed();
    }

    private void createShell() {
        this.fShell = new Shell(this.fParentShell, 84);
        if (this.fPaletteState.isTranslucent) {
            this.fShell.setAlpha(210);
        }
        this.checkSafeBounds(this.fParentShell);
        this.fShell.setBounds(this.fPaletteState.bounds);
        this.fShell.setImage(IArchiImages.ImageFactory.getImage("img/app-16.png"));
        this.fShell.setText(Messages.FloatingPalette_0);
        this.fShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FloatingPalette.this.fClient != null) {
                    FloatingPalette.this.fClient.dispose();
                }
                if (FloatingPalette.this.fPalettePage != null) {
                    FloatingPalette.this.fPalettePage.dispose();
                }
                FloatingPalette.this.fShell = null;
            }
        });
        this.fShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                FloatingPalette.this.fPaletteState.isOpen = false;
                FloatingPalette.this.saveState(FloatingPalette.this.fShell);
            }
        });
        this.fShell.setLayout((Layout)new FillLayout());
        this.fClient = new Composite((Composite)this.fShell, 0);
        this.fClient.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        this.fClient.setLayoutData((Object)gd);
        this.fPalettePage = (PalettePage)this.fEditor.getAdapter(PalettePage.class);
        this.fPalettePage.createControl(this.fClient);
    }

    private void checkSafeBounds(Shell parent) {
        Rectangle parentBounds = parent.getBounds();
        Rectangle paletteBounds = this.fPaletteState.bounds;
        if (paletteBounds.x >= parentBounds.x + parentBounds.width) {
            paletteBounds.x = parentBounds.x + parentBounds.width - 150;
        }
        if (paletteBounds.y >= parentBounds.y + parentBounds.height) {
            paletteBounds.y = parentBounds.y + parentBounds.height - 750;
        }
        if (paletteBounds.width > 800) {
            paletteBounds.width = 150;
        }
        if (paletteBounds.height > 1500) {
            paletteBounds.height = 750;
        }
    }

    public PaletteState getPaletteState() {
        return this.fPaletteState;
    }

    private void saveState(Shell shell) {
        Rectangle bounds = shell.getBounds();
        String s = bounds.x + "," + bounds.y + "," + bounds.width + "," + bounds.height + "," + this.fPaletteState.isOpen;
        ArchiPlugin.getInstance().getPreferenceStore().setValue("pallete_floater_state", s);
    }

    private void loadState() {
        String s = ArchiPlugin.getInstance().getPreferenceStore().getString("pallete_floater_state");
        if (StringUtils.isSet(s)) {
            try {
                String[] bits = s.split(",");
                if (bits.length == 5) {
                    this.fPaletteState.bounds.x = Integer.valueOf(bits[0]);
                    this.fPaletteState.bounds.y = Integer.valueOf(bits[1]);
                    this.fPaletteState.bounds.width = Integer.valueOf(bits[2]);
                    this.fPaletteState.bounds.height = Integer.valueOf(bits[3]);
                    this.fPaletteState.isOpen = Boolean.parseBoolean(bits[4]);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static class PaletteState {
        public Rectangle bounds = new Rectangle(600, 150, 180, 750);
        public boolean isOpen = true;
        public boolean isTranslucent = true;
    }
}

