/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.BorderColorCommand;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.CustomColorDialog;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IBorderObject;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPart;

public class BorderColorAction
extends SelectionAction {
    public static final String ID = "BorderColorAction";
    public static final String TEXT = Messages.BorderColorAction_0;

    public BorderColorAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return this.getFirstValidSelectedModelObject(this.getSelectedObjects()) != null;
    }

    private Object getFirstValidSelectedModelObject(List<?> selection) {
        for (Object object : this.getSelectedObjects()) {
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel())) continue;
            return model;
        }
        return null;
    }

    public void run() {
        List selection = this.getSelectedObjects();
        IBorderObject model = (IBorderObject)this.getFirstValidSelectedModelObject(selection);
        if (model == null) {
            return;
        }
        CustomColorDialog colorDialog = new CustomColorDialog(this.getWorkbenchPart().getSite().getShell());
        RGB defaultRGB = null;
        String s = model.getBorderColor();
        if (s != null) {
            defaultRGB = ColorFactory.convertStringToRGB(s);
        }
        if (defaultRGB != null) {
            colorDialog.setRGB(defaultRGB);
        } else {
            colorDialog.setRGB(new RGB(0, 0, 0));
        }
        RGB newColor = colorDialog.open();
        if (newColor != null) {
            this.execute(this.createCommand(selection, newColor));
        }
    }

    private Command createCommand(List<?> selection, RGB newColor) {
        CompoundCommand result = new CompoundCommand(Messages.BorderColorAction_1);
        for (Object object : selection) {
            BorderColorCommand cmd;
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel()) || !(cmd = new BorderColorCommand((IBorderObject)model, ColorFactory.convertRGBToString(newColor))).canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private boolean shouldEnable(Object model) {
        if (model instanceof ILockable && ((ILockable)model).isLocked()) {
            return false;
        }
        if (model instanceof IBorderObject) {
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)((IBorderObject)model));
            return provider != null && provider.shouldExposeFeature(IArchimatePackage.Literals.BORDER_OBJECT__BORDER_COLOR.getName());
        }
        return false;
    }
}

