/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.Logger;
import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.model.DiagramModelUtils;
import com.archimatetool.editor.model.IArchiveManager;
import com.archimatetool.editor.model.IEditorModelManager;
import com.archimatetool.editor.ui.LocalClipboard;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateModel;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IBounds;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelImageProvider;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.IDiagramModelReference;
import com.archimatetool.model.IProfile;
import com.archimatetool.model.IProfiles;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public final class CopySnapshot {
    static boolean COPY_SELECTED_CONNECTIONS = false;
    private List<IDiagramModelObject> fSnapshotObjects;
    private BidiHashtable<IConnectable, IConnectable> fOriginalToSnapshotComponentsMapping = new BidiHashtable();
    private IArchimateModel fSourceArchimateModel;
    private EClass fSourceDiagramClass;
    private boolean fDoCreateNewArchimateComponents;
    private int fXOffSet;
    private int fYOffSet;
    private Hashtable<IConnectable, IConnectable> fSnapshotToNewComponentMapping;
    private IDiagramModel fTargetDiagramModel;

    static {
        IEditorModelManager.INSTANCE.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object contents;
                if (evt.getPropertyName() == "IEditorModelManager.model.removed" && (contents = LocalClipboard.getDefault().getContents()) instanceof CopySnapshot) {
                    CopySnapshot copySnapshot = (CopySnapshot)contents;
                    IArchimateModel model = (IArchimateModel)evt.getNewValue();
                    if (copySnapshot.fSourceArchimateModel == model) {
                        LocalClipboard.getDefault().setContents("");
                    }
                }
            }
        });
    }

    public CopySnapshot(List<IDiagramModelComponent> selected) {
        if (selected == null || selected.isEmpty()) {
            return;
        }
        IDiagramModel diagramModel = selected.get(0).getDiagramModel();
        for (IDiagramModelComponent component : selected) {
            if (component.getDiagramModel() == diagramModel) continue;
            System.err.println("Different diagram models in " + String.valueOf(this.getClass()));
            return;
        }
        this.fSourceArchimateModel = diagramModel.getArchimateModel();
        this.fSourceDiagramClass = diagramModel.eClass();
        List<IDiagramModelObject> objectsToCopy = this.getTopLevelObjectsToCopy(selected);
        this.fSnapshotObjects = this.createSnapshotObjects(objectsToCopy);
        if (COPY_SELECTED_CONNECTIONS) {
            this.createSnapshotConnectionsForSelectedComponents(selected);
        } else {
            this.createAutomaticSnapshotConnections();
        }
    }

    private List<IDiagramModelObject> getTopLevelObjectsToCopy(List<IDiagramModelComponent> selected) {
        ArrayList<IDiagramModelObject> objects = new ArrayList<IDiagramModelObject>();
        for (IDiagramModelComponent component : selected) {
            if (!(component instanceof IDiagramModelObject) || this.hasAncestorSelected((IDiagramModelObject)component, selected)) continue;
            objects.add((IDiagramModelObject)component);
        }
        Collections.sort(objects, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                IDiagramModelContainer parent2;
                IDiagramModelContainer parent1;
                if (o1 instanceof IDiagramModelObject && o2 instanceof IDiagramModelObject && (parent1 = (IDiagramModelContainer)((IDiagramModelObject)o1).eContainer()) == (parent2 = (IDiagramModelContainer)((IDiagramModelObject)o2).eContainer())) {
                    int index1 = parent1.getChildren().indexOf(o1);
                    int index2 = parent2.getChildren().indexOf(o2);
                    return index1 - index2;
                }
                return 0;
            }
        });
        return objects;
    }

    private List<IDiagramModelObject> createSnapshotObjects(List<IDiagramModelObject> objectsToCopy) {
        ArrayList<IDiagramModelObject> topLevelObjects = new ArrayList<IDiagramModelObject>();
        for (IDiagramModelObject dmo : objectsToCopy) {
            IDiagramModelObject snapshotObject = this.createSnapshotObject(dmo);
            topLevelObjects.add(snapshotObject);
        }
        return topLevelObjects;
    }

    private IDiagramModelObject createSnapshotObject(IDiagramModelObject originalObject) {
        IDiagramModelObject snapshotObject = (IDiagramModelObject)originalObject.getCopy();
        this.fOriginalToSnapshotComponentsMapping.put((IConnectable)originalObject, (IConnectable)snapshotObject);
        if (snapshotObject instanceof IDiagramModelContainer) {
            for (IDiagramModelObject child : ((IDiagramModelContainer)originalObject).getChildren()) {
                IDiagramModelObject dmo = this.createSnapshotObject(child);
                ((IDiagramModelContainer)snapshotObject).getChildren().add((Object)dmo);
            }
        }
        return snapshotObject;
    }

    private void createAutomaticSnapshotConnections() {
        ArrayList<IDiagramModelConnection> allConnections = new ArrayList<IDiagramModelConnection>();
        for (IConnectable iConnectable : this.fOriginalToSnapshotComponentsMapping.keySet()) {
            for (IDiagramModelConnection connection : iConnectable.getSourceConnections()) {
                if (allConnections.contains(connection)) continue;
                allConnections.add(connection);
            }
            for (IDiagramModelConnection connection : iConnectable.getTargetConnections()) {
                if (allConnections.contains(connection)) continue;
                allConnections.add(connection);
            }
        }
        for (IDiagramModelConnection iDiagramModelConnection : allConnections) {
            if (!this.isSelectedConnectionCopyable(iDiagramModelConnection, allConnections)) continue;
            IDiagramModelConnection newConnection = (IDiagramModelConnection)iDiagramModelConnection.getCopy();
            this.fOriginalToSnapshotComponentsMapping.put((IConnectable)iDiagramModelConnection, (IConnectable)newConnection);
        }
        for (Map.Entry entry : this.fOriginalToSnapshotComponentsMapping.entrySet()) {
            if (!(entry.getKey() instanceof IDiagramModelConnection)) continue;
            IDiagramModelConnection originalConnection = (IDiagramModelConnection)entry.getKey();
            IConnectable newSource = (IConnectable)this.fOriginalToSnapshotComponentsMapping.get(originalConnection.getSource());
            IConnectable newTarget = (IConnectable)this.fOriginalToSnapshotComponentsMapping.get(originalConnection.getTarget());
            if (newSource != null && newTarget != null) {
                IDiagramModelConnection newConnection = (IDiagramModelConnection)entry.getValue();
                newConnection.connect(newSource, newTarget);
                continue;
            }
            System.err.println("No source or target in CopySnapshot!");
        }
    }

    private void createSnapshotConnectionsForSelectedComponents(List<IDiagramModelComponent> selected) {
        for (IDiagramModelComponent iDiagramModelComponent : selected) {
            IDiagramModelConnection connection;
            if (!(iDiagramModelComponent instanceof IDiagramModelConnection) || !this.isSelectedConnectionCopyable(connection = (IDiagramModelConnection)iDiagramModelComponent, selected)) continue;
            IDiagramModelConnection newConnection = (IDiagramModelConnection)connection.getCopy();
            this.fOriginalToSnapshotComponentsMapping.put((IConnectable)connection, (IConnectable)newConnection);
        }
        for (Map.Entry entry : this.fOriginalToSnapshotComponentsMapping.entrySet()) {
            if (!(entry.getKey() instanceof IDiagramModelConnection)) continue;
            IDiagramModelConnection originalConnection = (IDiagramModelConnection)entry.getKey();
            IConnectable newSource = (IConnectable)this.fOriginalToSnapshotComponentsMapping.get(originalConnection.getSource());
            IConnectable newTarget = (IConnectable)this.fOriginalToSnapshotComponentsMapping.get(originalConnection.getTarget());
            if (newSource == null || newTarget == null) continue;
            IDiagramModelConnection newConnection = (IDiagramModelConnection)entry.getValue();
            newConnection.connect(newSource, newTarget);
        }
    }

    private boolean isSelectedConnectionCopyable(IDiagramModelConnection connection, List<?> selected) {
        boolean result;
        boolean bl = result = !(!selected.contains(connection.getSource()) && !this.fOriginalToSnapshotComponentsMapping.containsKey(connection.getSource()) || !selected.contains(connection.getTarget()) && !this.fOriginalToSnapshotComponentsMapping.containsKey(connection.getTarget()));
        if (connection.getSource() instanceof IDiagramModelConnection) {
            result &= this.isSelectedConnectionCopyable((IDiagramModelConnection)connection.getSource(), selected);
        }
        if (connection.getTarget() instanceof IDiagramModelConnection) {
            result &= this.isSelectedConnectionCopyable((IDiagramModelConnection)connection.getTarget(), selected);
        }
        return result;
    }

    private boolean hasAncestorSelected(IDiagramModelObject object, List<?> selected) {
        EObject container = object.eContainer();
        while (!(container instanceof IDiagramModel)) {
            if (selected.contains(container)) {
                return true;
            }
            container = container.eContainer();
        }
        return false;
    }

    public boolean canPasteToDiagram(IDiagramModel targetDiagramModel) {
        if (this.fOriginalToSnapshotComponentsMapping.isEmpty()) {
            return false;
        }
        if (targetDiagramModel.eClass() != this.fSourceDiagramClass) {
            return false;
        }
        for (Map.Entry entry : this.fOriginalToSnapshotComponentsMapping.entrySet()) {
            if (!this.isValidPasteComponent(targetDiagramModel, (IDiagramModelComponent)entry.getValue())) continue;
            return true;
        }
        return false;
    }

    private boolean isValidPasteComponent(IDiagramModel targetDiagramModel, IDiagramModelComponent component) {
        if (component instanceof IDiagramModelReference) {
            IDiagramModel ref = ((IDiagramModelReference)component).getReferencedModel();
            for (IDiagramModel diagramModel : targetDiagramModel.getArchimateModel().getDiagramModels()) {
                if (ref != diagramModel) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public Command getPasteCommand(IDiagramModel targetDiagramModel, GraphicalViewer viewer, Point mousePosition, boolean pasteSpecial) {
        if (targetDiagramModel == null) {
            return null;
        }
        this.fTargetDiagramModel = targetDiagramModel;
        if (pasteSpecial) {
            switch (ArchiPlugin.getInstance().getPreferenceStore().getInt("pasteSpecialBehavior")) {
                case 0: {
                    this.fDoCreateNewArchimateComponents = !this.isSourceAndTargetArchiMateModelSame();
                    break;
                }
                case 1: {
                    this.fDoCreateNewArchimateComponents = true;
                    break;
                }
                default: {
                    this.fDoCreateNewArchimateComponents = !this.isSourceAndTargetArchiMateModelSame();
                    break;
                }
            }
        } else {
            this.fDoCreateNewArchimateComponents = this.needsNewArchimateConcepts();
        }
        this.calculateXYOffset(mousePosition);
        this.fSnapshotToNewComponentMapping = new Hashtable();
        List<IDiagramModelObject> pasteObjects = this.createPasteObjects();
        List<IDiagramModelConnection> pasteConnections = this.createPasteConnections();
        return new PasteCommand(targetDiagramModel, pasteObjects, pasteConnections, viewer, this.fDoCreateNewArchimateComponents);
    }

    private List<IDiagramModelObject> createPasteObjects() {
        ArrayList<IDiagramModelObject> topLevelObjects = new ArrayList<IDiagramModelObject>();
        for (IDiagramModelObject object : this.fSnapshotObjects) {
            IDiagramModelObject dmo = this.createPasteObject((IDiagramModelContainer)this.fTargetDiagramModel, object);
            if (dmo == null) continue;
            topLevelObjects.add(dmo);
        }
        return topLevelObjects;
    }

    private IDiagramModelObject createPasteObject(IDiagramModelContainer container, IDiagramModelObject snapshotObject) {
        if (!this.isValidPasteComponent(this.fTargetDiagramModel, (IDiagramModelComponent)snapshotObject)) {
            return null;
        }
        IDiagramModelObject pasteObject = (IDiagramModelObject)snapshotObject.getCopy();
        if (container instanceof IDiagramModel) {
            IDiagramModelObject originalObject = (IDiagramModelObject)this.fOriginalToSnapshotComponentsMapping.getKey(snapshotObject);
            IBounds bounds = originalObject.getBounds().getCopy();
            Point pt = new Point(bounds.getX(), bounds.getY());
            this.translateToAbsolute(originalObject, pt);
            bounds.setX(pt.x + this.fXOffSet);
            bounds.setY(pt.y + this.fYOffSet);
            pasteObject.setBounds(bounds);
        }
        if (pasteObject instanceof IDiagramModelArchimateObject) {
            IDiagramModelArchimateObject dmo = (IDiagramModelArchimateObject)pasteObject;
            if (!this.fDoCreateNewArchimateComponents) {
                IDiagramModelArchimateObject originalDiagramObject = (IDiagramModelArchimateObject)this.fOriginalToSnapshotComponentsMapping.getKey(snapshotObject);
                IArchimateElement element = originalDiagramObject.getArchimateElement();
                dmo.setArchimateElement(element);
            }
            if (this.fDoCreateNewArchimateComponents && this.isSourceAndTargetArchiMateModelSame()) {
                String name = dmo.getArchimateElement().getName();
                dmo.getArchimateElement().setName(name + " " + Messages.CopySnapshot_1);
            }
        }
        this.fSnapshotToNewComponentMapping.put((IConnectable)snapshotObject, (IConnectable)pasteObject);
        if (snapshotObject instanceof IDiagramModelContainer) {
            for (IDiagramModelObject child : ((IDiagramModelContainer)snapshotObject).getChildren()) {
                IDiagramModelObject dmo = this.createPasteObject((IDiagramModelContainer)pasteObject, child);
                if (dmo == null) continue;
                ((IDiagramModelContainer)pasteObject).getChildren().add((Object)dmo);
            }
        }
        return pasteObject;
    }

    private List<IDiagramModelConnection> createPasteConnections() {
        IDiagramModelConnection snapshotConnection;
        ArrayList<IDiagramModelConnection> connections = new ArrayList<IDiagramModelConnection>();
        for (IConnectable iConnectable : this.fOriginalToSnapshotComponentsMapping.values()) {
            if (!(iConnectable instanceof IDiagramModelConnection)) continue;
            snapshotConnection = (IDiagramModelConnection)iConnectable;
            IDiagramModelConnection newConnection = (IDiagramModelConnection)snapshotConnection.getCopy();
            connections.add(newConnection);
            this.fSnapshotToNewComponentMapping.put((IConnectable)snapshotConnection, (IConnectable)newConnection);
            if (this.fDoCreateNewArchimateComponents || !(snapshotConnection instanceof IDiagramModelArchimateConnection)) continue;
            IDiagramModelArchimateConnection originalDiagramConnection = (IDiagramModelArchimateConnection)this.fOriginalToSnapshotComponentsMapping.getKey(snapshotConnection);
            IArchimateRelationship relationship = originalDiagramConnection.getArchimateRelationship();
            ((IDiagramModelArchimateConnection)newConnection).setArchimateRelationship(relationship);
        }
        for (Map.Entry entry : this.fSnapshotToNewComponentMapping.entrySet()) {
            if (!(entry.getKey() instanceof IDiagramModelConnection)) continue;
            snapshotConnection = (IDiagramModelConnection)entry.getKey();
            IConnectable newSource = this.fSnapshotToNewComponentMapping.get(snapshotConnection.getSource());
            IConnectable newTarget = this.fSnapshotToNewComponentMapping.get(snapshotConnection.getTarget());
            if (newSource == null || newTarget == null) continue;
            IDiagramModelConnection newConnection = (IDiagramModelConnection)entry.getValue();
            newConnection.connect(newSource, newTarget);
        }
        return connections;
    }

    private boolean needsNewArchimateConcepts() {
        if (!this.isSourceAndTargetArchiMateModelSame()) {
            return true;
        }
        for (IConnectable object : this.fOriginalToSnapshotComponentsMapping.keySet()) {
            if (!(object instanceof IDiagramModelArchimateComponent)) continue;
            IArchimateConcept originalConcept = ((IDiagramModelArchimateComponent)object).getArchimateConcept();
            if (originalConcept == null || originalConcept.eContainer() == null) {
                return true;
            }
            if (DiagramModelUtils.findDiagramModelComponentsForArchimateConcept(this.fTargetDiagramModel, originalConcept).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isSourceAndTargetArchiMateModelSame() {
        return this.fSourceArchimateModel == this.fTargetDiagramModel.getArchimateModel();
    }

    private void calculateXYOffset(Point mousePosition) {
        if (mousePosition == null) {
            this.fXOffSet += 10;
            this.fYOffSet += 10;
            return;
        }
        Point ptSmallest = this.getMinimumPoint(this.fOriginalToSnapshotComponentsMapping.keySet());
        if (ptSmallest != null) {
            this.fXOffSet = mousePosition.x - ptSmallest.x;
            this.fYOffSet = mousePosition.y - ptSmallest.y;
        }
    }

    private void translateToAbsolute(IDiagramModelObject object, Point pt) {
        if (object.eContainer() instanceof IDiagramModelContainer && !(object.eContainer() instanceof IDiagramModel)) {
            IDiagramModelObject parent = (IDiagramModelObject)object.eContainer();
            pt.performTranslate(parent.getBounds().getX(), parent.getBounds().getY());
            this.translateToAbsolute(parent, pt);
        }
    }

    private Point getMinimumPoint(Set<IConnectable> selectedObjects) {
        int xOrigin = 99999;
        int yOrigin = 99999;
        for (IConnectable object : selectedObjects) {
            if (!(object instanceof IDiagramModelObject)) continue;
            IDiagramModelObject dmo = (IDiagramModelObject)object;
            Point pt = new Point(dmo.getBounds().getX(), dmo.getBounds().getY());
            this.translateToAbsolute(dmo, pt);
            if (dmo.eContainer() instanceof IDiagramModelObject && selectedObjects.contains(dmo.eContainer())) continue;
            if (pt.x < xOrigin) {
                xOrigin = pt.x;
            }
            if (pt.y >= yOrigin) continue;
            yOrigin = pt.y;
        }
        return xOrigin == 99999 || yOrigin == 99999 ? null : new Point(xOrigin, yOrigin);
    }

    static class BidiHashtable<K, V>
    extends Hashtable<K, V> {
        BidiHashtable() {
        }

        public synchronized K getKey(Object value) {
            for (Map.Entry entry : this.entrySet()) {
                Object v = entry.getValue();
                if (!v.equals(value)) continue;
                return entry.getKey();
            }
            return null;
        }
    }

    private class PasteCommand
    extends Command {
        private IDiagramModel targetDiagramModel;
        private List<IDiagramModelObject> topLevelObjects;
        private List<IDiagramModelConnection> connections;
        private GraphicalViewer viewer;
        private boolean doAddArchimateComponentToModel;
        private List<IProfile> previousTargetModelProfiles;
        private List<IProfile> newTargetModelProfiles;

        PasteCommand(IDiagramModel targetDiagramModel, List<IDiagramModelObject> topLevelObjects, List<IDiagramModelConnection> connections, GraphicalViewer viewer, boolean doAddArchimateComponentToModel) {
            super(Messages.CopySnapshot_0);
            this.targetDiagramModel = targetDiagramModel;
            this.topLevelObjects = topLevelObjects;
            this.connections = connections;
            this.viewer = viewer;
            this.doAddArchimateComponentToModel = doAddArchimateComponentToModel;
        }

        public void execute() {
            if (!CopySnapshot.this.isSourceAndTargetArchiMateModelSame()) {
                this.previousTargetModelProfiles = List.copyOf(this.targetDiagramModel.getArchimateModel().getProfiles());
                this.newTargetModelProfiles = new ArrayList<IProfile>();
                TreeIterator iter = EcoreUtil.getAllContents(this.topLevelObjects);
                while (iter.hasNext()) {
                    EObject eObject = (EObject)iter.next();
                    if (eObject instanceof IDiagramModelImageProvider) {
                        this.copyImageToTargetModel((IDiagramModelImageProvider)eObject);
                    }
                    if (!(eObject instanceof IDiagramModelArchimateComponent)) continue;
                    this.copyProfiles((IProfiles)((IDiagramModelArchimateComponent)eObject).getArchimateConcept());
                }
            }
            this.copyObjects();
        }

        public void redo() {
            if (!CopySnapshot.this.isSourceAndTargetArchiMateModelSame() && !this.newTargetModelProfiles.isEmpty()) {
                this.targetDiagramModel.getArchimateModel().getProfiles().addAll(this.newTargetModelProfiles);
            }
            this.copyObjects();
        }

        public void undo() {
            for (IDiagramModelObject dmo : this.topLevelObjects) {
                this.targetDiagramModel.getChildren().remove((Object)dmo);
                if (!this.doAddArchimateComponentToModel) continue;
                this.removeArchimateComponentsFromModel(dmo);
            }
            if (this.doAddArchimateComponentToModel) {
                for (IDiagramModelConnection dmc : this.connections) {
                    if (!(dmc instanceof IDiagramModelArchimateConnection)) continue;
                    ((IDiagramModelArchimateConnection)dmc).removeArchimateConceptFromModel();
                }
            }
            if (!CopySnapshot.this.isSourceAndTargetArchiMateModelSame() && !this.newTargetModelProfiles.isEmpty()) {
                this.targetDiagramModel.getArchimateModel().getProfiles().clear();
                this.targetDiagramModel.getArchimateModel().getProfiles().addAll(this.previousTargetModelProfiles);
            }
        }

        private void copyObjects() {
            for (IDiagramModelObject dmo : this.topLevelObjects) {
                this.targetDiagramModel.getChildren().add((Object)dmo);
                if (!this.doAddArchimateComponentToModel) continue;
                this.addArchimateComponentsToModel(dmo);
            }
            if (this.doAddArchimateComponentToModel) {
                for (IDiagramModelConnection dmc : this.connections) {
                    if (!(dmc instanceof IDiagramModelArchimateConnection)) continue;
                    ((IDiagramModelArchimateConnection)dmc).addArchimateConceptToModel(null);
                }
            }
            this.selectNewObjects();
        }

        private void copyProfiles(IProfiles profilesObject) {
            for (IProfile profile : profilesObject.getProfiles()) {
                IProfile targetProfile = ArchimateModelUtils.getProfileByNameAndType((IArchimateModel)this.targetDiagramModel.getArchimateModel(), (String)profile.getName(), (String)profile.getConceptType());
                if (targetProfile == null) {
                    targetProfile = (IProfile)profile.getCopy();
                    CopySnapshot.this.fTargetDiagramModel.getArchimateModel().getProfiles().add((Object)targetProfile);
                    this.newTargetModelProfiles.add(targetProfile);
                    this.copyImageToTargetModel((IDiagramModelImageProvider)profile);
                }
                profilesObject.getProfiles().clear();
                profilesObject.getProfiles().add((Object)targetProfile);
            }
        }

        private void copyImageToTargetModel(IDiagramModelImageProvider imageProvider) {
            IArchiveManager sourceArchiveManager = (IArchiveManager)CopySnapshot.this.fSourceArchimateModel.getAdapter(IArchiveManager.class);
            IArchiveManager targetArchiveManager = (IArchiveManager)this.targetDiagramModel.getAdapter(IArchiveManager.class);
            String imagePath = imageProvider.getImagePath();
            if (imagePath != null) {
                try {
                    imagePath = targetArchiveManager.copyImageBytes(sourceArchiveManager, imagePath);
                    imageProvider.setImagePath(imagePath);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    Logger.logError("Could not copy image bytes when copying and pasting objects.", ex);
                }
            }
        }

        private void addArchimateComponentsToModel(IDiagramModelObject dmo) {
            if (dmo instanceof IDiagramModelArchimateObject) {
                ((IDiagramModelArchimateObject)dmo).addArchimateConceptToModel(null);
            }
            if (dmo instanceof IDiagramModelContainer) {
                for (IDiagramModelObject child : ((IDiagramModelContainer)dmo).getChildren()) {
                    this.addArchimateComponentsToModel(child);
                }
            }
        }

        private void removeArchimateComponentsFromModel(IDiagramModelObject dmo) {
            if (dmo instanceof IDiagramModelArchimateObject) {
                ((IDiagramModelArchimateObject)dmo).removeArchimateConceptFromModel();
            }
            if (dmo instanceof IDiagramModelContainer) {
                for (IDiagramModelObject child : ((IDiagramModelContainer)dmo).getChildren()) {
                    this.removeArchimateComponentsFromModel(child);
                }
            }
        }

        private void selectNewObjects() {
            if (this.viewer != null) {
                ArrayList<EditPart> selected = new ArrayList<EditPart>();
                for (EObject eObject : this.topLevelObjects) {
                    EditPart editPart = (EditPart)this.viewer.getEditPartRegistry().get(eObject);
                    if (editPart == null || !editPart.isSelectable()) continue;
                    selected.add(editPart);
                }
                this.viewer.setSelection((ISelection)new StructuredSelection(selected));
            }
        }

        public void dispose() {
            this.targetDiagramModel = null;
            this.topLevelObjects = null;
            this.connections = null;
            this.viewer = null;
            this.previousTargetModelProfiles = null;
            this.newTargetModelProfiles = null;
        }
    }
}

