/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.DiagramCommandFactory;
import com.archimatetool.editor.model.commands.DeleteArchimateElementCommand;
import com.archimatetool.editor.model.commands.DeleteArchimateRelationshipCommand;
import com.archimatetool.editor.model.commands.NonNotifyingCompoundCommand;
import com.archimatetool.model.IArchimateConcept;
import com.archimatetool.model.IArchimateElement;
import com.archimatetool.model.IArchimateRelationship;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.util.ArchimateModelUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class DeleteFromModelAction
extends SelectionAction {
    public static final String ID = "com.archimatetool.editor.action.deleteFromModel";
    public static final String TEXT = Messages.DeleteFromModelAction_0;

    public DeleteFromModelAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
        this.setActionDefinitionId(ID);
    }

    protected boolean calculateEnabled() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return false;
        }
        for (Object object : list) {
            Object model;
            if (!(object instanceof EditPart) || !((model = ((EditPart)object).getModel()) instanceof IDiagramModelArchimateComponent)) continue;
            return true;
        }
        return false;
    }

    public void run() {
        List selection = this.getSelectedObjects();
        HashSet<IArchimateConcept> archimateConcepts = new HashSet<IArchimateConcept>();
        for (Object object : selection) {
            if (!(object instanceof EditPart)) continue;
            Object model = ((EditPart)object).getModel();
            if (model instanceof IDiagramModelArchimateObject) {
                IArchimateElement element = ((IDiagramModelArchimateObject)model).getArchimateElement();
                archimateConcepts.add((IArchimateConcept)element);
                for (IArchimateRelationship relation : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)element)) {
                    archimateConcepts.add((IArchimateConcept)relation);
                    for (IArchimateRelationship r : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)relation)) {
                        archimateConcepts.add((IArchimateConcept)r);
                    }
                }
                continue;
            }
            if (!(model instanceof IDiagramModelArchimateConnection)) continue;
            IArchimateRelationship relation = ((IDiagramModelArchimateConnection)model).getArchimateRelationship();
            archimateConcepts.add((IArchimateConcept)relation);
            for (IArchimateRelationship r : ArchimateModelUtils.getAllRelationshipsForConcept((IArchimateConcept)relation)) {
                archimateConcepts.add((IArchimateConcept)r);
            }
        }
        if (this.hasMoreThanOneReference(archimateConcepts) && !MessageDialog.openQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeleteFromModelAction_0, (String)(Messages.DeleteFromModelAction_1 + "\n" + Messages.DeleteFromModelAction_2))) {
            return;
        }
        final NonNotifyingCompoundCommand compoundCommand = new NonNotifyingCompoundCommand(TEXT);
        for (IArchimateConcept archimateConcept : archimateConcepts) {
            Command cmd;
            if (archimateConcept instanceof IArchimateElement) {
                cmd = new DeleteArchimateElementCommand((IArchimateElement)archimateConcept);
                compoundCommand.add(cmd);
                for (IDiagramModelObject dmo : ((IArchimateElement)archimateConcept).getReferencingDiagramObjects()) {
                    cmd = DiagramCommandFactory.createDeleteDiagramObjectCommand(dmo);
                    compoundCommand.add(cmd);
                }
                continue;
            }
            if (!(archimateConcept instanceof IArchimateRelationship)) continue;
            cmd = new DeleteArchimateRelationshipCommand((IArchimateRelationship)archimateConcept);
            compoundCommand.add(cmd);
            for (IDiagramModelArchimateConnection dmc : ((IArchimateRelationship)archimateConcept).getReferencingDiagramConnections()) {
                cmd = DiagramCommandFactory.createDeleteDiagramConnectionCommand((IDiagramModelConnection)dmc);
                compoundCommand.add(cmd);
            }
        }
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                DeleteFromModelAction.this.execute((Command)compoundCommand);
            }
        });
    }

    private boolean hasMoreThanOneReference(Set<IArchimateConcept> archimateConcepts) {
        for (IArchimateConcept archimateConcept : archimateConcepts) {
            if (archimateConcept.getReferencingDiagramComponents().size() <= 1) continue;
            return true;
        }
        return false;
    }
}

