/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.FillColorCommand;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.components.CustomColorDialog;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPart;

public class FillColorAction
extends SelectionAction {
    public static final String ID = "FillColorAction";
    public static final String TEXT = Messages.FillColorAction_0;

    public FillColorAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return this.getFirstValidSelectedModelObject(this.getSelectedObjects()) != null;
    }

    private Object getFirstValidSelectedModelObject(List<?> selection) {
        for (Object object : this.getSelectedObjects()) {
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel())) continue;
            return model;
        }
        return null;
    }

    public void run() {
        RGB newColor;
        List selection = this.getSelectedObjects();
        IDiagramModelObject model = (IDiagramModelObject)this.getFirstValidSelectedModelObject(selection);
        if (model == null) {
            return;
        }
        CustomColorDialog colorDialog = new CustomColorDialog(this.getWorkbenchPart().getSite().getShell());
        RGB defaultRGB = null;
        String s = model.getFillColor();
        defaultRGB = s == null ? ColorFactory.getDefaultFillColor(model).getRGB() : ColorFactory.convertStringToRGB(s);
        if (defaultRGB != null) {
            colorDialog.setRGB(defaultRGB);
        }
        if ((newColor = colorDialog.open()) != null) {
            this.execute(this.createCommand(selection, newColor));
        }
    }

    private Command createCommand(List<?> selection, RGB newColor) {
        CompoundCommand result = new CompoundCommand(Messages.FillColorAction_1);
        for (Object object : selection) {
            FillColorCommand cmd;
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel()) || !(cmd = new FillColorCommand((IDiagramModelObject)model, ColorFactory.convertRGBToString(newColor))).canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private boolean shouldEnable(Object model) {
        if (model instanceof ILockable && ((ILockable)model).isLocked()) {
            return false;
        }
        if (model instanceof IDiagramModelObject) {
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)((IDiagramModelObject)model));
            return provider != null && provider.shouldExposeFeature(IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__FILL_COLOR.getName());
        }
        return false;
    }
}

