/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.FontCompoundCommand;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.FontFactory;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IFontAttribute;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.ui.IWorkbenchPart;

public class FontAction
extends SelectionAction {
    public static final String ID = "FontAction";
    public static final String TEXT = Messages.FontAction_0;

    public FontAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return this.getFirstValidSelectedModelObject(this.getSelectedObjects()) != null;
    }

    private Object getFirstValidSelectedModelObject(List<?> selection) {
        for (Object object : this.getSelectedObjects()) {
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel())) continue;
            return model;
        }
        return null;
    }

    public void run() {
        List selection = this.getSelectedObjects();
        IFontAttribute model = (IFontAttribute)this.getFirstValidSelectedModelObject(selection);
        if (model == null) {
            return;
        }
        FontData fontData = FontFactory.getDefaultUserViewFontData();
        String rgbValue = null;
        rgbValue = model.getFontColor();
        String fontValue = model.getFont();
        if (fontValue != null) {
            try {
                fontData = new FontData(fontValue);
            }
            catch (Exception exception) {}
        }
        FontDialog dialog = new FontDialog(this.getWorkbenchPart().getSite().getShell());
        dialog.setText(Messages.FontAction_1);
        dialog.setEffectsVisible(false);
        dialog.setFontList(new FontData[]{fontData});
        dialog.setRGB(ColorFactory.convertStringToRGB(rgbValue));
        FontData selectedFontData = dialog.open();
        if (selectedFontData != null) {
            this.execute(this.createCommand(selection, selectedFontData, dialog.getRGB()));
        }
    }

    private Command createCommand(List<?> selection, FontData selectedFontData, RGB newColor) {
        CompoundCommand result = new CompoundCommand(Messages.FontAction_2);
        for (Object object : selection) {
            FontCompoundCommand cmd;
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel()) || !(cmd = new FontCompoundCommand((IFontAttribute)model, selectedFontData.toString(), newColor)).canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    private boolean shouldEnable(Object model) {
        if (model instanceof ILockable && ((ILockable)model).isLocked()) {
            return false;
        }
        if (model instanceof IFontAttribute) {
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)((IFontAttribute)model));
            return provider != null && provider.shouldExposeFeature(IArchimatePackage.Literals.FONT_ATTRIBUTE__FONT.getName());
        }
        return false;
    }
}

