/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.RetargetAction;

public class ObjectPositionAction
extends SelectionAction {
    public static final String ACTION_BRINGTOFRONT_ID = "com.archimatetool.editor.bringToFront";
    public static final String ACTION_BRINGFORWARD_ID = "com.archimatetool.editor.bringForward";
    public static final String ACTION_SENDTOBACK_ID = "com.archimatetool.editor.sendToBack";
    public static final String ACTION_SENDBACKWARD_ID = "com.archimatetool.editor.sendBackward";

    public static final ObjectPositionActionDefinition[] getActionDefinitions() {
        return new ObjectPositionActionDefinition[]{new ObjectPositionActionDefinition(ACTION_BRINGTOFRONT_ID, Messages.BringToFrontAction_0), new ObjectPositionActionDefinition(ACTION_BRINGFORWARD_ID, Messages.BringForwardAction_0), new ObjectPositionActionDefinition(ACTION_SENDTOBACK_ID, Messages.SendToBackAction_0), new ObjectPositionActionDefinition(ACTION_SENDBACKWARD_ID, Messages.SendBackwardAction_0)};
    }

    public static List<RetargetAction> createRetargetActions() {
        ArrayList<RetargetAction> list = new ArrayList<RetargetAction>();
        ObjectPositionActionDefinition[] objectPositionActionDefinitionArray = ObjectPositionAction.getActionDefinitions();
        int n = objectPositionActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectPositionActionDefinition a = objectPositionActionDefinitionArray[n2];
            RetargetAction action = new RetargetAction(a.id(), a.label());
            action.setActionDefinitionId(a.id());
            list.add(action);
            ++n2;
        }
        return list;
    }

    public static List<ObjectPositionAction> createActions(IWorkbenchPart part) {
        ArrayList<ObjectPositionAction> list = new ArrayList<ObjectPositionAction>();
        ObjectPositionActionDefinition[] objectPositionActionDefinitionArray = ObjectPositionAction.getActionDefinitions();
        int n = objectPositionActionDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectPositionActionDefinition a = objectPositionActionDefinitionArray[n2];
            list.add(new ObjectPositionAction(part, a.id(), a.label()));
            ++n2;
        }
        return list;
    }

    public ObjectPositionAction(IWorkbenchPart part, String id, String text) {
        super(part);
        this.setText(text);
        this.setId(id);
        this.setActionDefinitionId(id);
    }

    public void run() {
        this.execute(this.createCommand());
    }

    protected boolean calculateEnabled() {
        return this.createCommand().canExecute();
    }

    private Command createCommand() {
        CompoundCommand result = new CompoundCommand(this.getText());
        for (Object object : this.getSelectedObjects()) {
            PositionCommand cmd;
            ILockable lockable;
            IDiagramModelObject dmo;
            EditPart editPart;
            Object object2;
            if (!(object instanceof EditPart) || !((object2 = (editPart = (EditPart)object).getModel()) instanceof IDiagramModelObject) || !((dmo = (IDiagramModelObject)object2).eContainer() instanceof IDiagramModelContainer) || dmo instanceof ILockable && (lockable = (ILockable)dmo).isLocked() || !(cmd = new PositionCommand(dmo, this.getText(), this.getId())).canExecute()) continue;
            result.add((Command)cmd);
        }
        return result.unwrap();
    }

    public record ObjectPositionActionDefinition(String id, String label) {
    }

    private static class PositionCommand
    extends Command {
        private IDiagramModelObject dmo;
        private EList<IDiagramModelObject> children;
        private int oldPos;
        private String actionId;

        PositionCommand(IDiagramModelObject dmo, String label, String actionId) {
            this.setLabel(label);
            this.dmo = dmo;
            this.actionId = actionId;
            this.children = ((IDiagramModelContainer)dmo.eContainer()).getChildren();
            this.oldPos = this.children.indexOf((Object)dmo);
        }

        public boolean canExecute() {
            return switch (this.actionId) {
                case ObjectPositionAction.ACTION_BRINGTOFRONT_ID, ObjectPositionAction.ACTION_BRINGFORWARD_ID -> {
                    if (this.oldPos < this.children.size() - 1) {
                        yield true;
                    }
                    yield false;
                }
                case ObjectPositionAction.ACTION_SENDTOBACK_ID, ObjectPositionAction.ACTION_SENDBACKWARD_ID -> {
                    if (this.oldPos > 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public void execute() {
            this.oldPos = this.children.indexOf((Object)this.dmo);
            int newPosition = switch (this.actionId) {
                case ObjectPositionAction.ACTION_BRINGTOFRONT_ID -> this.children.size() - 1;
                case ObjectPositionAction.ACTION_BRINGFORWARD_ID -> this.oldPos + 1;
                case ObjectPositionAction.ACTION_SENDTOBACK_ID -> 0;
                case ObjectPositionAction.ACTION_SENDBACKWARD_ID -> this.oldPos - 1;
                default -> this.oldPos;
            };
            this.children.move(newPosition, this.oldPos);
        }

        public void undo() {
            this.children.move(this.oldPos, this.children.indexOf((Object)this.dmo));
        }

        public void dispose() {
            this.dmo = null;
            this.children = null;
        }
    }
}

