/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.commands.DiagramModelObjectAlphaCommand;
import com.archimatetool.editor.ui.factory.IObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModelObject;
import com.archimatetool.model.ILockable;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPart;

public class OpacityAction
extends SelectionAction {
    public static final String ID = "OpacityAction";
    public static final String TEXT = Messages.OpacityAction_0 + "...";

    public OpacityAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        return this.getFirstValidSelectedModelObject(this.getSelectedObjects()) != null;
    }

    protected Object getFirstValidSelectedModelObject(List<?> selection) {
        for (Object object : this.getSelectedObjects()) {
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel())) continue;
            return model;
        }
        return null;
    }

    public void run() {
        List selection = this.getSelectedObjects();
        IDiagramModelObject dmo = (IDiagramModelObject)this.getFirstValidSelectedModelObject(selection);
        if (dmo == null) {
            return;
        }
        int alpha = dmo.getAlpha();
        OpacityDialog dialog = new OpacityDialog(this.getWorkbenchPart().getSite().getShell(), alpha);
        if (dialog.open() == 0) {
            this.execute(this.createCommand(selection, dialog.getAlpha()));
        }
    }

    protected Command createCommand(List<?> selection, int alpha) {
        CompoundCommand result = new CompoundCommand(Messages.OpacityAction_0);
        for (Object object : selection) {
            Command cmd;
            Object model;
            if (!(object instanceof EditPart) || !this.shouldEnable(model = ((EditPart)object).getModel()) || !(cmd = this.getCommand((IDiagramModelObject)model, alpha)).canExecute()) continue;
            result.add(cmd);
        }
        return result.unwrap();
    }

    private boolean shouldEnable(Object model) {
        if (model instanceof ILockable && ((ILockable)model).isLocked()) {
            return false;
        }
        if (model instanceof IDiagramModelObject) {
            IObjectUIProvider provider = ObjectUIFactory.INSTANCE.getProvider((EObject)((IDiagramModelObject)model));
            return provider != null && provider.shouldExposeFeature(this.getFeatureName());
        }
        return false;
    }

    protected String getFeatureName() {
        return IArchimatePackage.Literals.DIAGRAM_MODEL_OBJECT__ALPHA.getName();
    }

    protected Command getCommand(IDiagramModelObject dmo, int newValue) {
        return new DiagramModelObjectAlphaCommand(dmo, newValue);
    }

    protected static class OpacityDialog
    extends Dialog {
        private Spinner fSpinner;
        private int fAlpha;

        protected OpacityDialog(Shell parent, int alpha) {
            super(parent);
            this.fAlpha = alpha;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(Messages.OpacityAction_1);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            composite.setLayout((Layout)new GridLayout(2, true));
            Label label = new Label(composite, 0);
            label.setText(Messages.OpacityAction_1 + ": ");
            this.fSpinner = new Spinner(composite, 2048);
            this.fSpinner.setMinimum(0);
            this.fSpinner.setMaximum(255);
            this.fSpinner.setIncrement(5);
            this.fSpinner.setSelection(this.fAlpha);
            return composite;
        }

        protected int getAlpha() {
            return this.fAlpha;
        }

        protected void okPressed() {
            this.fAlpha = this.fSpinner.getSelection();
            super.okPressed();
        }
    }
}

