/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.diagram.actions.OpacityAction;
import com.archimatetool.editor.diagram.commands.DiagramModelObjectOutlineAlphaCommand;
import com.archimatetool.model.IDiagramModelObject;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class OutlineOpacityAction
extends OpacityAction {
    public static final String ID = "OutlineOpacityAction";
    public static final String TEXT = Messages.OutlineOpacityAction_0 + "...";

    public OutlineOpacityAction(IWorkbenchPart part) {
        super(part);
        this.setText(TEXT);
        this.setId(ID);
    }

    @Override
    public void run() {
        List selection = this.getSelectedObjects();
        IDiagramModelObject dmo = (IDiagramModelObject)this.getFirstValidSelectedModelObject(selection);
        if (dmo == null) {
            return;
        }
        int alpha = dmo.getLineAlpha();
        OpacityAction.OpacityDialog dialog = new OpacityAction.OpacityDialog(this.getWorkbenchPart().getSite().getShell(), alpha);
        if (dialog.open() == 0) {
            this.execute(this.createCommand(selection, dialog.getAlpha()));
        }
    }

    @Override
    protected String getFeatureName() {
        return "lineAlpha";
    }

    @Override
    protected Command getCommand(IDiagramModelObject dmo, int newValue) {
        return new DiagramModelObjectOutlineAlphaCommand(dmo, newValue);
    }
}

