/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.PrintModeDialog;
import com.archimatetool.editor.diagram.util.DiagramUtils;
import com.archimatetool.editor.utils.PlatformUtils;
import com.archimatetool.model.IDiagramModel;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.print.PrintGraphicalViewerOperation;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class PrintDiagramAction
extends WorkbenchPartAction {
    public PrintDiagramAction(IWorkbenchPart part) {
        super(part);
        this.setId(ActionFactory.PRINT.getId());
    }

    protected boolean calculateEnabled() {
        return true;
    }

    public void run() {
        PrintModeDialog modeDialog = new PrintModeDialog(this.getWorkbenchPart().getSite().getShell());
        modeDialog.open();
        int printMode = modeDialog.getPrintMode();
        if (printMode == -1) {
            return;
        }
        PrintDialog printDialog = new PrintDialog(this.getWorkbenchPart().getSite().getShell(), 0);
        PrinterData data = printDialog.open();
        if (data != null) {
            IDiagramModel diagramModel = (IDiagramModel)this.getWorkbenchPart().getAdapter(IDiagramModel.class);
            Shell tempShell = null;
            Printer printer = null;
            try {
                tempShell = new Shell();
                GraphicalViewerImpl viewer = DiagramUtils.createViewer(diagramModel, (Composite)tempShell);
                printer = new Printer(data);
                PrintGraphicalViewerOperation op = new PrintGraphicalViewerOperation(printer, (GraphicalViewer)viewer);
                op.setPrintMode(printMode);
                if (PlatformUtils.isMac()) {
                    op.setUseScaledGraphics(false);
                }
                op.run(this.getWorkbenchPart().getTitle());
            }
            finally {
                if (tempShell != null) {
                    tempShell.dispose();
                }
                if (printer != null) {
                    printer.dispose();
                }
            }
        }
    }
}

