/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.ui.services.ViewManager;
import com.archimatetool.editor.views.tree.ITreeModelView;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelArchimateComponent;
import com.archimatetool.model.IDiagramModelArchimateConnection;
import com.archimatetool.model.IDiagramModelArchimateObject;
import com.archimatetool.model.IDiagramModelReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;

public class SelectElementInTreeAction
extends SelectionAction {
    public static final String ID = "SelectElementInTreeAction";

    public SelectElementInTreeAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.SelectElementInTreeAction_0);
        this.setToolTipText(Messages.SelectElementInTreeAction_1);
        this.setId(ID);
        this.setActionDefinitionId("com.archimatetool.editor.selectInModelTree");
        IHandlerService service = (IHandlerService)part.getSite().getService(IHandlerService.class);
        service.activateHandler(this.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this));
    }

    public void run() {
        List selection = this.getSelectedObjects();
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object object : selection) {
            if (!(object instanceof EditPart)) continue;
            Object model = ((EditPart)object).getModel();
            if (model instanceof IDiagramModel) {
                elements.add(model);
                continue;
            }
            if (model instanceof IDiagramModelReference) {
                elements.add(((IDiagramModelReference)model).getReferencedModel());
                continue;
            }
            if (!(model instanceof IDiagramModelArchimateComponent)) continue;
            elements.add(((IDiagramModelArchimateComponent)model).getArchimateConcept());
        }
        ITreeModelView view = (ITreeModelView)ViewManager.showViewPart("com.archimatetool.editor.treeModelView", true);
        if (view != null) {
            view.getViewer().setSelection((ISelection)new StructuredSelection(elements), true);
        }
    }

    protected boolean calculateEnabled() {
        List list = this.getSelectedObjects();
        if (list.isEmpty()) {
            return false;
        }
        for (Object object : list) {
            Object model;
            if (!(object instanceof EditPart) || !((model = ((EditPart)object).getModel()) instanceof IDiagramModel) && !(model instanceof IDiagramModelReference) && !(model instanceof IDiagramModelArchimateConnection) && !(model instanceof IDiagramModelArchimateObject)) continue;
            return true;
        }
        return false;
    }
}

