/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.actions;

import com.archimatetool.editor.diagram.actions.Messages;
import com.archimatetool.editor.model.commands.EObjectFeatureCommand;
import com.archimatetool.model.IArchimateDiagramModel;
import com.archimatetool.model.IArchimatePackage;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.viewpoints.IViewpoint;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.Disposable;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchPart;

public class ViewpointAction
extends Action
implements Disposable {
    private IWorkbenchPart part;
    private IArchimateDiagramModel diagramModel;
    private IViewpoint viewPoint;
    private Adapter eAdapter = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            Object feature = msg.getFeature();
            if (feature == IArchimatePackage.Literals.ARCHIMATE_DIAGRAM_MODEL__VIEWPOINT) {
                ViewpointAction.this.update();
            }
        }
    };

    public ViewpointAction(IWorkbenchPart part, IViewpoint viewPoint) {
        super(viewPoint.getName(), 8);
        this.setId(viewPoint.toString());
        this.part = part;
        this.viewPoint = viewPoint;
        this.diagramModel = (IArchimateDiagramModel)part.getAdapter(IDiagramModel.class);
        this.diagramModel.eAdapters().add((Object)this.eAdapter);
        this.update();
    }

    public void run() {
        if (this.isChecked()) {
            CommandStack stack = (CommandStack)this.part.getAdapter(CommandStack.class);
            stack.execute((Command)new EObjectFeatureCommand(Messages.ViewpointAction_0, (EObject)this.diagramModel, (EStructuralFeature)IArchimatePackage.Literals.ARCHIMATE_DIAGRAM_MODEL__VIEWPOINT, this.viewPoint.getID()));
        }
    }

    protected void update() {
        this.setChecked(this.diagramModel.getViewpoint().equals(this.viewPoint.getID()));
    }

    public void dispose() {
        this.diagramModel.eAdapters().remove((Object)this.eAdapter);
        this.viewPoint = null;
        this.part = null;
        this.diagramModel = null;
    }
}

