/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.ArchiPlugin;
import com.archimatetool.editor.diagram.commands.Messages;
import com.archimatetool.editor.ui.ColorFactory;
import com.archimatetool.editor.ui.factory.IGraphicalObjectUIProvider;
import com.archimatetool.editor.ui.factory.ObjectUIFactory;
import com.archimatetool.model.IArchimateFactory;
import com.archimatetool.model.IDiagramModel;
import com.archimatetool.model.IDiagramModelComponent;
import com.archimatetool.model.IDiagramModelContainer;
import com.archimatetool.model.IDiagramModelReference;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.commands.Command;

public class AddDiagramModelReferenceCommand
extends Command {
    private IDiagramModelContainer fParent;
    private IDiagramModelReference fReference;

    public AddDiagramModelReferenceCommand(IDiagramModelContainer parent, IDiagramModel diagramModel, int x, int y) {
        this.setLabel(Messages.AddDiagramModelReferenceCommand_0);
        this.fParent = parent;
        this.fReference = IArchimateFactory.eINSTANCE.createDiagramModelReference();
        this.fReference.setReferencedModel(diagramModel);
        IGraphicalObjectUIProvider provider = (IGraphicalObjectUIProvider)ObjectUIFactory.INSTANCE.getProvider((EObject)this.fReference);
        Dimension size = provider.getDefaultSize();
        this.fReference.setBounds(x, y, size.width, size.height);
        this.fReference.setGradient(ArchiPlugin.getInstance().getPreferenceStore().getInt("defaultGradient"));
        ColorFactory.setDefaultColors((IDiagramModelComponent)this.fReference);
    }

    public void execute() {
        this.fParent.getChildren().add((Object)this.fReference);
    }

    public void undo() {
        this.fParent.getChildren().remove((Object)this.fReference);
    }

    public void dispose() {
        this.fParent = null;
        this.fReference = null;
    }
}

