/*
 * Decompiled with CFR 0.152.
 */
package com.archimatetool.editor.diagram.commands;

import com.archimatetool.editor.diagram.commands.CreateBendpointCommand;
import com.archimatetool.editor.diagram.commands.Messages;
import com.archimatetool.model.IConnectable;
import com.archimatetool.model.IDiagramModelConnection;
import com.archimatetool.model.IDiagramModelObject;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.swt.widgets.Display;

public class CreateDiagramConnectionCommand
extends Command {
    protected CreateConnectionRequest fRequest;
    protected IDiagramModelConnection fConnection;
    protected IConnectable fSource;
    protected IConnectable fTarget;

    public CreateDiagramConnectionCommand(CreateConnectionRequest request) {
        this.fRequest = request;
        this.setLabel(Messages.CreateDiagramConnectionCommand_0);
    }

    public void setSource(IConnectable source) {
        if (source == null) {
            throw new IllegalArgumentException("Source connected model object cannot be null");
        }
        this.fSource = source;
    }

    public void setTarget(IConnectable target) {
        if (target == null) {
            throw new IllegalArgumentException("Target connected model object cannot be null");
        }
        this.fTarget = target;
    }

    public boolean canExecute() {
        return this.fTarget != null && this.fSource != null;
    }

    public void execute() {
        Command cmd;
        if (this.fConnection == null) {
            this.fConnection = this.createNewConnection();
        }
        this.fConnection.connect(this.fSource, this.fTarget);
        if (this.fConnection.getSource() == this.fConnection.getTarget() && (cmd = CreateDiagramConnectionCommand.createBendPointsForCircularConnectionCommand(this.fConnection)) != null) {
            cmd.execute();
        }
        this.selectConnection();
    }

    public void redo() {
        this.fConnection.reconnect();
    }

    public void undo() {
        this.fConnection.disconnect();
    }

    protected IDiagramModelConnection createNewConnection() {
        return (IDiagramModelConnection)this.fRequest.getNewObject();
    }

    protected void selectConnection() {
        EditPartViewer viewer;
        EditPart editPart;
        if (this.fRequest.getSourceEditPart() != null && this.fRequest.getSourceEditPart().getViewer() != null && (editPart = (EditPart)(viewer = this.fRequest.getSourceEditPart().getViewer()).getEditPartRegistry().get(this.fConnection)) != null) {
            Display.getCurrent().asyncExec(() -> viewer.select(editPart));
        }
    }

    public static Command createBendPointsForCircularConnectionCommand(IDiagramModelConnection connection) {
        int height;
        if (!(connection.getSource() instanceof IDiagramModelObject) && !(connection.getTarget() instanceof IDiagramModelObject)) {
            return null;
        }
        IDiagramModelObject source = (IDiagramModelObject)connection.getSource();
        IDiagramModelObject target = (IDiagramModelObject)connection.getTarget();
        int width = source.getBounds().getWidth();
        if (width == -1) {
            width = 100;
        }
        if ((height = target.getBounds().getHeight()) == -1) {
            height = 60;
        }
        width = (int)Math.max(100.0, (double)width * 0.6);
        height = (int)Math.max(60.0, (double)height * 0.6);
        CompoundCommand result = new CompoundCommand();
        CreateBendpointCommand cmd = new CreateBendpointCommand();
        cmd.setDiagramModelConnection(connection);
        cmd.setRelativeDimensions(new Dimension(width, 0), new Dimension(width, 0));
        result.add((Command)cmd);
        cmd = new CreateBendpointCommand();
        cmd.setDiagramModelConnection(connection);
        cmd.setRelativeDimensions(new Dimension(width, height), new Dimension(width, height));
        result.add((Command)cmd);
        cmd = new CreateBendpointCommand();
        cmd.setDiagramModelConnection(connection);
        cmd.setRelativeDimensions(new Dimension(0, height), new Dimension(0, height));
        result.add((Command)cmd);
        return result;
    }

    public void dispose() {
        this.fRequest = null;
        this.fConnection = null;
        this.fSource = null;
        this.fTarget = null;
    }
}

